/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.utility;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.localdb.statusdb.server.TrendingData;
import org.lsst.ccs.localdb.trendserver.TrendingClientService;
import org.lsst.ccs.localdb.utils.TrendingConnectionUtils;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.DerivedChannel;

public class AccumTimeChannel
extends DerivedChannel {
    @LookupPath
    private String path;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem subsys;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private TrendingClientService trendingService;
    private Channel channel;
    private static final Logger LOG = Logger.getLogger(AccumTimeChannel.class.getName());
    private long readTime = 0L;
    private double accumTime = 0.0;

    public void init() {
        if (this.channel == null) {
            throw new RuntimeException(this.getPath() + " parameter error: channel has not been defined");
        }
        super.init();
    }

    public void start() {
        TrendingConnectionUtils trendingUtils = this.trendingService.getBusTrendingConnection();
        if (trendingUtils == null) {
            LOG.log(Level.SEVERE, "Trending data cannot be accessed");
        } else {
            String chName = this.subsys.getName() + "/" + this.path;
            TrendingData data = trendingUtils.getLatestData(chName);
            double d = this.accumTime = data == null ? Double.NaN : data.getValue("value");
            if (Double.isNaN(this.accumTime)) {
                LOG.log(Level.WARNING, "No trending data present for channel {0}", chName);
                this.accumTime = 0.0;
            } else {
                LOG.log(Level.INFO, "Got trending data for channel {0}", chName);
            }
        }
        super.start();
    }

    public double evaluateDerivedValue() {
        long currTime = System.currentTimeMillis();
        if (this.readTime != 0L && this.channel.getValue() > 0.0) {
            this.accumTime += (double)(currTime - this.readTime) / 3600000.0;
        }
        this.readTime = currTime;
        return this.accumTime;
    }

    @Command(type=Command.CommandType.ACTION, description="Set the accumulated time")
    public void setAccumTime(@Argument(description="Time period (hrs)") double time) {
        this.accumTime = time;
    }
}

