/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.ads.ADSDriver;
import org.lsst.ccs.drivers.ads.Notification;
import org.lsst.ccs.drivers.ads.VariableHandle;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisAbsolute;
import org.lsst.ccs.subsystem.shutter.Alerts;
import org.lsst.ccs.subsystem.shutter.PLCEventSubmitter;
import org.lsst.ccs.subsystem.shutter.PLCVariableDictionary;
import org.lsst.ccs.subsystem.shutter.Publisher;
import org.lsst.ccs.subsystem.shutter.SimMessage;
import org.lsst.ccs.subsystem.shutter.SimulatedShutter;
import org.lsst.ccs.subsystem.shutter.StateMachine;
import org.lsst.ccs.subsystem.shutter.Watchdog;
import org.lsst.ccs.subsystem.shutter.common.Axis;
import org.lsst.ccs.subsystem.shutter.common.HallTransition;
import org.lsst.ccs.subsystem.shutter.common.ShutterSide;
import org.lsst.ccs.subsystem.shutter.plc.BladeSetPosition;
import org.lsst.ccs.subsystem.shutter.plc.CalibDone;
import org.lsst.ccs.subsystem.shutter.plc.Calibrate;
import org.lsst.ccs.subsystem.shutter.plc.ChangeAxisEnablePLC;
import org.lsst.ccs.subsystem.shutter.plc.ChangeBrakeState;
import org.lsst.ccs.subsystem.shutter.plc.ClearAllFaultsPLC;
import org.lsst.ccs.subsystem.shutter.plc.ClearAxisFaultsPLC;
import org.lsst.ccs.subsystem.shutter.plc.CloseShutter;
import org.lsst.ccs.subsystem.shutter.plc.Disable;
import org.lsst.ccs.subsystem.shutter.plc.DisableAllAxesPLC;
import org.lsst.ccs.subsystem.shutter.plc.Enable;
import org.lsst.ccs.subsystem.shutter.plc.EnableAllAxesPLC;
import org.lsst.ccs.subsystem.shutter.plc.Error;
import org.lsst.ccs.subsystem.shutter.plc.GoToProd;
import org.lsst.ccs.subsystem.shutter.plc.HomeAxisPLC;
import org.lsst.ccs.subsystem.shutter.plc.Ignored;
import org.lsst.ccs.subsystem.shutter.plc.MotionDonePLC;
import org.lsst.ccs.subsystem.shutter.plc.MoveAxisAbsolutePLC;
import org.lsst.ccs.subsystem.shutter.plc.MoveAxisRelativePLC;
import org.lsst.ccs.subsystem.shutter.plc.MsgToCCS;
import org.lsst.ccs.subsystem.shutter.plc.MsgToPLC;
import org.lsst.ccs.subsystem.shutter.plc.OpenShutter;
import org.lsst.ccs.subsystem.shutter.plc.PLCMsg;
import org.lsst.ccs.subsystem.shutter.plc.Reset;
import org.lsst.ccs.subsystem.shutter.plc.ShutterStatusPLC;
import org.lsst.ccs.subsystem.shutter.plc.TakeExposure;
import org.lsst.ccs.subsystem.shutter.plc.Timer;
import org.lsst.ccs.subsystem.shutter.plc.ToggleSafetyCheck;
import org.lsst.ccs.subsystem.shutter.sim.CubicSCurve;
import org.lsst.ccs.subsystem.shutter.statemachine.EventReply;
import org.lsst.ccs.subsystem.shutter.statemachine.SynchronousChannel;
import org.lsst.ccs.subsystem.shutter.status.MotionDone;
import org.lsst.ccs.subsystem.shutter.status.ShutterStatus;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.scheduler.PeriodicTask;
import org.lsst.ccs.utilities.scheduler.Scheduler;

public class Controller
implements HasLifecycle {
    @ConfigurationParameter(isFinal=true, description="IP address of the shutter controller.")
    private volatile String plcIPaddr = "0.0.0.0";
    @ConfigurationParameter(isFinal=true, description="AMS address of the shutter controller.")
    private volatile String plcAMSaddr = "0.0.0.0.1.1";
    @ConfigurationParameter(isFinal=true, description="Local AMS address used by the subsystem.")
    private volatile String localAMSaddr = "0.0.0.1.1.1";
    @ConfigurationParameter(description="Startup delay for the notification reader.", units="s")
    private volatile Duration noticeReaderStartupDelay = Duration.ofSeconds(2L);
    @ConfigurationParameter(description="Restart delay for the notification reader.", units="s")
    private volatile Duration noticeReaderRestartDelay = Duration.ofMillis(10L);
    @ConfigurationParameter(description="Ack timeout for commands sent to the shutter controller.", units="s")
    private volatile Duration plcAckTimeout = Duration.ofSeconds(30L);
    @ConfigurationParameter(description="The minimum exposure time.", units="s")
    private volatile Duration minExposureTime = Duration.ofMillis(100L);
    @ConfigurationParameter(isFinal=true, description="Reference positions for the -X blade set.", maxLength=4, units="mm")
    private volatile Map<String, Double> referenceMinusXpositions = new HashMap<String, Double>();
    @ConfigurationParameter(isFinal=true, description="Reference positions for the +X blade set.", maxLength=4, units="mm")
    private volatile Map<String, Double> referencePlusXpositions = new HashMap<String, Double>();
    @ConfigurationParameter(description="Move blade sets at this speed when centering.", units="mm/s")
    private volatile double centeringSpeed = 20.0;
    @ConfigurationParameter(description="Max speed (to attain during a stroke.", units="mm/s")
    private volatile double maxStrokeSpeed = 1667.0;
    @ConfigurationParameter(isFinal=true, description="Max allowed difference of a Hall transition position from prediction.", units="mm")
    private volatile double maxHallPositionError = 5.0;
    @ConfigurationParameter(description="Safe operating range for motor temperature.", units="Celsius", maxLength=2)
    private volatile List<Double> safeMotorTempRange = Arrays.asList(-20.0, 50.0);
    private static final Logger LOG = Logger.getLogger((String)Controller.class.getName());
    private ADSDriver driver;
    private PeriodicTask plcReceptionTask;
    private Map<Class<? extends MsgToPLC>, VariableHandle> writableVarHandles;
    private CountDownLatch plcReceptionStopLatch;
    private List<Axis> centeringOrder;
    private SimulatedShutter simShutter;
    private final PLCVariableDictionary plcVarDict;
    private final MessageWithState pendingMessage;
    private final Scheduler eventSched;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private volatile Publisher publish;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private volatile StateMachine centralSmComponent;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private volatile Subsystem subsys;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private volatile Watchdog wdog;
    private static final int PLC_DISABLED_STATE = 10000;
    private static final int PLC_STILL_STATE = 21010;
    private BlockingQueue<SimMessage> simulationQueue;

    public Controller() {
        this.referencePlusXpositions.put(BladeSetPosition.HOME.getKey(), 0.0);
        this.referencePlusXpositions.put(BladeSetPosition.RETRACTED.getKey(), 1.0);
        this.referencePlusXpositions.put(BladeSetPosition.CENTERED.getKey(), 374.5);
        this.referencePlusXpositions.put(BladeSetPosition.EXTENDED.getKey(), 749.0);
        this.referenceMinusXpositions.put(BladeSetPosition.HOME.getKey(), 750.0);
        this.referenceMinusXpositions.put(BladeSetPosition.RETRACTED.getKey(), 749.0);
        this.referenceMinusXpositions.put(BladeSetPosition.CENTERED.getKey(), 375.5);
        this.referenceMinusXpositions.put(BladeSetPosition.EXTENDED.getKey(), 1.0);
        this.eventSched = new Scheduler("Controller tasks", 1);
        PLCVariableDictionary dict = new PLCVariableDictionary();
        dict.addMsgToPLC(Calibrate.class, Calibrate::new);
        dict.addMsgToPLC(ChangeAxisEnablePLC.class, ChangeAxisEnablePLC::new);
        dict.addMsgToPLC(ChangeBrakeState.class, ChangeBrakeState::new);
        dict.addMsgToPLC(ClearAllFaultsPLC.class, ClearAllFaultsPLC::new);
        dict.addMsgToPLC(ClearAxisFaultsPLC.class, ClearAxisFaultsPLC::new);
        dict.addMsgToPLC(CloseShutter.class, CloseShutter::new);
        dict.addMsgToPLC(DisableAllAxesPLC.class, DisableAllAxesPLC::new);
        dict.addMsgToPLC(EnableAllAxesPLC.class, EnableAllAxesPLC::new);
        dict.addMsgToPLC(GoToProd.class, GoToProd::new);
        dict.addMsgToPLC(MoveAxisAbsolutePLC.class, MoveAxisAbsolutePLC::new);
        dict.addMsgToPLC(MoveAxisRelativePLC.class, MoveAxisRelativePLC::new);
        dict.addMsgToPLC(HomeAxisPLC.class, HomeAxisPLC::new);
        dict.addMsgToPLC(OpenShutter.class, OpenShutter::new);
        dict.addMsgToPLC(Reset.class, Reset::new);
        dict.addMsgToPLC(TakeExposure.class, TakeExposure::new);
        dict.addMsgToPLC(ToggleSafetyCheck.class, ToggleSafetyCheck::new);
        dict.addMsgToCCS(CalibDone.class, CalibDone::new, (chan, msg) -> this.centralSmComponent.calibDone(chan, (CalibDone)msg));
        dict.addMsgToCCS(Disable.class, Disable::new, (chan, msg) -> this.centralSmComponent.disable(chan));
        dict.addMsgToCCS(Enable.class, Enable::new, (chan, msg) -> this.centralSmComponent.enable(chan));
        dict.addMsgToCCS(Error.class, Error::new, (chan, msg) -> this.centralSmComponent.error(chan, (Error)msg));
        dict.addMsgToCCS(Ignored.class, Ignored::new, (chan, msg) -> this.centralSmComponent.ignored(chan, ((Ignored)msg).getReason()));
        dict.addMsgToCCS(MotionDonePLC.class, MotionDonePLC::new, (chan, msg) -> this.centralSmComponent.motionDone(chan, (MotionDonePLC)msg));
        dict.addMsgToCCS(ShutterStatusPLC.class, ShutterStatusPLC::new, (chan, msg) -> {});
        dict.addMsgToCCS(Timer.class, Timer::new, (chan, msg) -> this.centralSmComponent.timer(chan));
        this.plcVarDict = dict;
        this.pendingMessage = new MessageWithState();
    }

    public void init() {
        HashMap<ShutterSide, ShutterStatus.AxisStatus> axes = new HashMap<ShutterSide, ShutterStatus.AxisStatus>();
        axes.put(ShutterSide.PLUSX, new ShutterStatus.AxisStatus(0.0, 0.0, 0.0, false, false, false, false, false, 0, 0.0, false));
        axes.put(ShutterSide.MINUSX, (ShutterStatus.AxisStatus)axes.get((Object)ShutterSide.PLUSX));
        ShutterStatus exampleStatus = new ShutterStatus(0, false, 0, axes, false, Arrays.asList(0, 0, 0));
        ((DataProviderDictionaryService)this.subsys.getAgentService(DataProviderDictionaryService.class)).registerData(new KeyValueData("ShutterStatus", (Serializable)exampleStatus));
    }

    public void shutdown() {
        this.eventSched.shutdown();
    }

    public void postShutdown() {
        this.eventSched.shutdownNow();
    }

    boolean isBadExposureTime(Duration exposureTime) {
        return exposureTime.compareTo(this.minExposureTime) < 0;
    }

    synchronized void terminateContact() {
        if (this.plcReceptionTask != null) {
            this.plcReceptionTask.cancel(true);
        }
        if (this.driver != null) {
            this.driver.close();
        }
    }

    synchronized boolean makePartialContact() {
        try {
            if (this.plcReceptionTask != null) {
                this.plcReceptionTask.cancel(true);
            }
            if (this.driver == null) {
                this.driver = new ADSDriver(this.localAMSaddr);
            } else {
                this.driver.close();
            }
            if (this.writableVarHandles != null) {
                this.writableVarHandles.clear();
            } else {
                this.writableVarHandles = new HashMap<Class<? extends MsgToPLC>, VariableHandle>();
            }
            this.driver.open(this.plcAMSaddr, this.plcIPaddr);
            PLCVariableDictionary.InVariable vreset = this.plcVarDict.getInVariable(Reset.class);
            this.writableVarHandles.put(vreset.klass, this.driver.getVariableHandle(vreset.varName));
            this.driver.requestNotifications(this.driver.getVariableHandle(vreset.ackName), Duration.ZERO, Duration.ZERO, true);
            this.driver.requestNotifications(this.driver.getVariableHandle(this.plcVarDict.getOutVariable(ShutterStatusPLC.class).varName), Duration.ZERO, Duration.ZERO, true);
            this.subsys.getScheduler().setLogger(LOG);
            this.startPLCReceptionTask();
            return true;
        }
        catch (Exception exc) {
            LOG.severe((Object)"Could not contact the shutter controller.", (Throwable)exc);
            this.submitContactLost();
            return false;
        }
    }

    synchronized boolean makeFullContact() {
        try {
            this.plcReceptionTask.cancel(true);
            this.plcReceptionStopLatch.await();
            List<PLCVariableDictionary.InVariable> inVars = this.plcVarDict.getAllInVariables();
            for (PLCVariableDictionary.InVariable var : inVars) {
                this.writableVarHandles.put(var.klass, this.driver.getVariableHandle(var.varName));
            }
            for (PLCVariableDictionary.InVariable var : inVars) {
                this.driver.requestNotifications(this.driver.getVariableHandle(var.ackName), Duration.ZERO, Duration.ZERO, true);
            }
            List<PLCVariableDictionary.OutVariable> outVars = this.plcVarDict.getAllOutVariables();
            for (PLCVariableDictionary.OutVariable var : outVars) {
                this.driver.requestNotifications(this.driver.getVariableHandle(var.varName), Duration.ZERO, Duration.ZERO, true);
            }
            this.startPLCReceptionTask();
            return true;
        }
        catch (Exception exc) {
            LOG.severe((Object)"Lost contact with the shutter controller.", (Throwable)exc);
            this.submitContactLost();
            return false;
        }
    }

    synchronized String shutterIsReady() {
        ShutterStatus status = this.publish.getShutterStatus();
        if (status == null) {
            LOG.warning((Object)"No shutter status has yet been received.");
            return "No shutter status has yet been received.";
        }
        ShutterInfo info = new ShutterInfo(status, this.referenceMinusXpositions, this.referencePlusXpositions);
        return info.shutterIsReady();
    }

    private void submitContactLost() {
        PLCEventSubmitter submitter = (chan, msg) -> this.centralSmComponent.contactLost(chan);
        this.submitEvent("contactLost", submitter, null, Level.SEVERE);
    }

    private void submitEvent(String eventName, PLCEventSubmitter submitter, MsgToCCS msg, Level logLevel) {
        Runnable subCode = () -> {
            try {
                SynchronousChannel<EventReply> chan = new SynchronousChannel<EventReply>();
                submitter.submit(chan, msg);
                EventReply reply = (EventReply)chan.read();
                if (!reply.wasAccepted(null)) {
                    LOG.log(logLevel, "Event {0}() was rejected by the central state machine.", (Object)eventName);
                    LOG.log(logLevel, reply.getMessage(), new Object[0]);
                }
            }
            catch (InterruptedException exc) {
                LOG.warning((Object)String.format("The submission of event %s() to the central state machine was interrupted.", eventName));
            }
            catch (TimeoutException exc) {
                LOG.severe((Object)String.format("A wait for a central state machine reply to event %s() timed out.", eventName));
            }
        };
        this.eventSched.schedule(subCode, 0L, TimeUnit.MILLISECONDS);
    }

    synchronized boolean readyForCalibration() {
        ShutterStatus status = this.publish.getShutterStatus();
        if (status == null) {
            LOG.warning((Object)"No shutter status has yet been received.");
            return false;
        }
        ShutterInfo info = new ShutterInfo(status, this.referenceMinusXpositions, this.referencePlusXpositions);
        return info.readyForCalibration();
    }

    synchronized void startFirstCentering() {
        ShutterStatus status = this.publish.getShutterStatus();
        ShutterInfo info = new ShutterInfo(status, this.referenceMinusXpositions, this.referencePlusXpositions);
        assert (status != null) : "Null shutter status";
        assert (this.centeringOrder == null) : "A centering order should not exist yet.";
        this.centeringOrder = info.getCenteringOrder();
        this.centralSmComponent.getActions().relay(new MoveAxisAbsolutePLC(new MoveAxisAbsolute(this.centeringOrder.get(0).getName(), info.getCentered(this.centeringOrder.get(0)), this.centeringSpeed)));
    }

    synchronized void startSecondCentering() {
        assert (this.centeringOrder != null) : "A centering order wasn't chosen.";
        ShutterStatus status = this.publish.getShutterStatus();
        ShutterInfo info = new ShutterInfo(status, this.referenceMinusXpositions, this.referencePlusXpositions);
        this.centralSmComponent.getActions().relay(new MoveAxisAbsolutePLC(new MoveAxisAbsolute(this.centeringOrder.get(1).getName(), info.getCentered(this.centeringOrder.get(1)), this.centeringSpeed)));
        this.centeringOrder = null;
    }

    private void startPLCReceptionTask() throws InterruptedException {
        ADSDriver drv = this.driver;
        CountDownLatch startLatch = new CountDownLatch(1);
        CountDownLatch stopLatch = new CountDownLatch(1);
        Runnable reception = () -> this.plcReceptionTaskBody(drv, this.plcVarDict, this.pendingMessage, this.publish, this.centralSmComponent, startLatch, stopLatch);
        this.plcReceptionStopLatch = stopLatch;
        this.plcReceptionTask = this.subsys.getScheduler().scheduleWithFixedDelay(reception, this.noticeReaderStartupDelay.toMillis(), this.noticeReaderRestartDelay.toMillis(), TimeUnit.MILLISECONDS, "Notification reception", Level.SEVERE);
        startLatch.await();
    }

    public void checkHallTransitions(MotionDonePLC motplc) {
        MotionDone mot = motplc.getStatusBusMessage();
        CubicSCurve profile = new CubicSCurve(mot.endPosition() - mot.startPosition(), 0.001 * (double)mot.actualDuration().toMillis());
        Instant tstart = mot.startTime().getTAIInstant();
        int badCount = 0;
        for (HallTransition htran : mot.hallTransitions()) {
            double a;
            double t = 0.001 * (double)Duration.between(tstart, htran.getTime().getTAIInstant()).toMillis();
            double p = mot.startPosition() + profile.distance(t);
            if (!(Math.abs(p - (a = htran.getPosition())) > this.maxHallPositionError)) continue;
            ++badCount;
            LOG.warning((Object)String.format("Hall ID %d transition at %g mm, prediction = %g mm.", htran.getSensorId(), a, p));
        }
        if (badCount > 0) {
            ((AlertService)this.subsys.getAgentService(AlertService.class)).raiseAlert(Alerts.MOTION, AlertState.WARNING, String.format("There were %d Hall transitions more than %g mm off prediction.", badCount, this.maxHallPositionError));
        }
    }

    private void plcReceptionTaskBody(ADSDriver driver, PLCVariableDictionary plcVarDict, MessageWithState pendingMessage, Publisher publish, StateMachine machine, CountDownLatch startLatch, CountDownLatch stopLatch) {
        ArrayList leftovers = new ArrayList();
        driver.drainNotifications(leftovers);
        startLatch.countDown();
        LOG.info((Object)"The notice-reading task has started.");
        try {
            while (true) {
                Notification notice = driver.takeNotification();
                this.wdog.countMessage();
                String varName = notice.getVariableHandle().getName();
                ByteBuffer data = notice.getData();
                this.processMessageData(varName, data, plcVarDict, pendingMessage, publish, machine);
            }
        }
        catch (InterruptedException exc) {
            stopLatch.countDown();
            LOG.info((Object)"Normal stop of the notice-reading loop.");
            return;
        }
    }

    private void simReceptionTaskBody(PLCVariableDictionary plcVarDict, MessageWithState pendingMessage, Publisher publish, StateMachine machine, BlockingQueue<SimMessage> simulationQueue) {
        LOG.info((Object)"The simulated notice-reading loop has started.");
        try {
            while (true) {
                SimMessage msg = simulationQueue.take();
                this.wdog.countMessage();
                String varName = msg.varName;
                ByteBuffer data = msg.data;
                LOG.info((Object)("Read message with var name " + varName));
                this.processMessageData(varName, data, plcVarDict, pendingMessage, publish, machine);
            }
        }
        catch (InterruptedException exc) {
            LOG.info((Object)"Normal stop of the simulated notice-reading loop.");
            return;
        }
    }

    private void processMessageData(String varName, ByteBuffer data, PLCVariableDictionary plcVarDict, MessageWithState pendingMessage, Publisher publish, StateMachine machine) throws InterruptedException {
        if (this.checkMessageSetVersion(data)) {
            return;
        }
        PLCVariableDictionary.InVariable ackVar = plcVarDict.getInVariable(varName);
        PLCVariableDictionary.OutVariable outVar = plcVarDict.getOutVariable(varName);
        assert (ackVar != null || outVar != null) : "Unknown message type received from PLC.";
        assert (ackVar == null || outVar == null) : "Ambiguous message received from PLC.";
        if (ackVar != null) {
            LOG.fine((Object)"Calling handleAckMessage().");
            this.handleAckMessage(data, ackVar, pendingMessage);
            LOG.fine((Object)"Returned from handleAckMessage()");
        } else if (outVar != null && outVar.klass == ShutterStatusPLC.class) {
            LOG.fine((Object)"Calling handleStatusMessage().");
            this.handleStatusMessage(data, outVar, publish, machine);
            LOG.fine((Object)"Returned from handleStatusMessage().");
        } else if (outVar != null) {
            LOG.fine((Object)"Calling handleEventMessage");
            this.handleEventMessage(data, outVar);
            LOG.fine((Object)"Returned from handleEventMessage().");
        }
    }

    private boolean checkMessageSetVersion(ByteBuffer data) {
        boolean failure = false;
        if (PLCMsg.messageVersionIsBad(data)) {
            this.submitContactLost();
            failure = true;
        }
        return failure;
    }

    private void handleAckMessage(ByteBuffer data, PLCVariableDictionary.InVariable ackVar, MessageWithState pending) {
        try {
            MsgToPLC msg = ackVar.ackDecoder.apply(data);
            MessageWithState.Disposition disp = pending.ack(msg);
            switch (disp) {
                case OK: 
                case WRONG_ACK: {
                    break;
                }
                case WRONG_STATE: {
                    LOG.severe((Object)String.format("Received an unexpected ack message of type %s.", msg.getClass().getSimpleName()));
                    this.submitContactLost();
                    break;
                }
                default: {
                    LOG.warning((Object)String.format("Unexpected status of %s from ack processing.", new Object[]{disp}));
                    break;
                }
            }
        }
        catch (Exception exc) {
            LOG.severe((Object)"Error during ack processing.", (Throwable)exc);
        }
    }

    private void handleStatusMessage(ByteBuffer data, PLCVariableDictionary.OutVariable outVar, Publisher publish, StateMachine machine) throws InterruptedException {
        PLCEventSubmitter submitter;
        ShutterStatusPLC status;
        try {
            status = (ShutterStatusPLC)outVar.decoder.apply(data);
        }
        catch (Exception exc) {
            LOG.severe((Object)"Error during status message decoding.", (Throwable)exc);
            return;
        }
        LOG.fine((Object)("Received ShutterStatusPLC. " + status.toString()));
        EnumMap<ShutterSide, ShutterStatus.AxisStatus> axes = new EnumMap<ShutterSide, ShutterStatus.AxisStatus>(ShutterSide.class);
        for (ShutterSide side : ShutterSide.values()) {
            ShutterStatusPLC.AxisStatusPLC axplc = status.getAxisStatus(side);
            ShutterStatus.AxisStatus ax = new ShutterStatus.AxisStatus(axplc.getActPos(), axplc.getActVel(), axplc.getSetAcc(), axplc.isEnabled(), axplc.isBrakeEngaged(), axplc.atLowLimit(), axplc.atHighLimit(), axplc.isBrakeEngaged(), axplc.getErrorID(), axplc.getMotorTemp(), axplc.getMotorTemp() >= this.safeMotorTempRange.get(0) && axplc.getMotorTemp() <= this.safeMotorTempRange.get(1));
            if (!ax.hasSafeTemp()) {
                String msg2 = String.format("%s motor temperature of %5.1f \u2103 outside of range [%5.1f, %5.1f].", new Object[]{side, ax.getMotorTemp(), this.safeMotorTempRange.get(0), this.safeMotorTempRange.get(1)});
                ((AlertService)this.subsys.getAgentService(AlertService.class)).raiseAlert(Alerts.MOTOR, AlertState.ALARM, msg2);
            }
            axes.put(side, ax);
        }
        publish.updateShutterStatus(new ShutterStatus(status.getMotionProfile(), status.isCalibrated(), status.getSmState(), axes, status.isSafetyOn(), status.getTemperature()));
        if (status.getSmState() == 10000) {
            submitter = (replyChan, msg) -> machine.plcIsDisabled(replyChan);
            this.submitEvent("plcIsDisabled", submitter, null, Level.FINER);
        } else if (status.getSmState() == 21010) {
            submitter = (replyChan, msg) -> machine.plcIsEnabled(replyChan);
            this.submitEvent("plcIsEnabled", submitter, null, Level.FINER);
        }
    }

    private void handleEventMessage(ByteBuffer data, PLCVariableDictionary.OutVariable outVar) throws InterruptedException {
        MsgToCCS msg;
        try {
            msg = outVar.decoder.apply(data);
        }
        catch (Exception exc) {
            LOG.severe((Object)String.format("Error during the decoding of event message %s from the PLC.", outVar.varName), (Throwable)exc);
            return;
        }
        String clsnm = msg.getClass().getSimpleName();
        String eventName = clsnm.substring(0, 1).toLowerCase() + clsnm.substring(1);
        this.submitEvent(eventName, outVar.submitter, msg, Level.SEVERE);
    }

    synchronized void resetPLC() {
        this.relay(new Reset(this.maxStrokeSpeed));
    }

    void simulateResetPLC() {
        this.simulateRelay(new Reset(this.maxStrokeSpeed));
    }

    void relay(MsgToPLC msg) {
        LOG.fine((Object)String.format("Sending message %s to PLC.", msg.getClass().getSimpleName()));
        MessageWithState.Disposition disp = this.sendPendingMessage(msg);
        switch (disp) {
            case OK: {
                this.finishPendingMessage();
                break;
            }
            case SEND_ERROR: {
                this.submitContactLost();
                break;
            }
            default: {
                LOG.warning((Object)String.format("Unexpected message sending disposition of %s.", new Object[]{disp}));
            }
        }
    }

    private MessageWithState.Disposition sendPendingMessage(MsgToPLC msg) {
        PLCVariableDictionary.InVariable inVar = this.plcVarDict.getInVariable(msg.getClass());
        assert (inVar != null) : "Message not recognized by relay().";
        VariableHandle handle = this.writableVarHandles.get(msg.getClass());
        assert (handle != null) : "No handle for writing the PLC message variable.";
        return this.pendingMessage.send(this.driver, msg, handle);
    }

    void simulateRelay(MsgToPLC msg) {
        LOG.info((Object)String.format("Sending message %s to simulated PLC.", msg.getClass().getSimpleName()));
        MessageWithState.Disposition disp = this.pendingMessage.simSend(this.simShutter, msg);
        switch (disp) {
            case OK: {
                this.finishPendingMessage();
                break;
            }
            case SEND_ERROR: {
                this.submitContactLost();
                break;
            }
            default: {
                LOG.warning((Object)String.format("Unexpected message sending disposition of %s.", new Object[]{disp}));
            }
        }
    }

    synchronized void simulateContact() {
        if (this.plcReceptionTask == null) {
            Runnable reception = () -> this.simReceptionTaskBody(this.plcVarDict, this.pendingMessage, this.publish, this.centralSmComponent, this.simulationQueue);
            this.simulationQueue = new ArrayBlockingQueue<SimMessage>(1000);
            this.plcReceptionTask = this.subsys.getScheduler().scheduleWithFixedDelay(reception, this.noticeReaderStartupDelay.toMillis(), this.noticeReaderRestartDelay.toMillis(), TimeUnit.MILLISECONDS, "Simulated notification reception", Level.SEVERE);
            this.simShutter = new SimulatedShutter(this.subsys.getScheduler(), this.simulationQueue, this.plcVarDict);
            this.simShutter.start();
        }
    }

    private void finishPendingMessage() {
        MessageWithState.Disposition disp;
        LOG.fine((Object)String.format("Waiting %s for ack.", this.plcAckTimeout));
        try {
            disp = this.pendingMessage.awaitAck(this.plcAckTimeout);
        }
        catch (InterruptedException exc) {
            LOG.warning((Object)"Interrupted while waiting for an ack from the shutter controller.");
            return;
        }
        LOG.fine((Object)"Done waiting.");
        switch (disp) {
            case OK: {
                LOG.fine((Object)"Correct ack received from the shutter controller.");
                break;
            }
            case WRONG_STATE: {
                LOG.severe((Object)"Attempted to wait for an ack from the shutter controller when none was expected.");
                break;
            }
            case WRONG_ACK: {
                LOG.severe((Object)"Ack from the shutter controller had the wrong message ID.");
                this.submitContactLost();
                break;
            }
            case ACK_TIMEOUT: {
                LOG.severe((Object)"Timed out waiting for an ack from the shutter controller.");
                this.submitContactLost();
                break;
            }
            default: {
                LOG.severe((Object)String.format("Unexpected status of %s from awaitAck().", new Object[]{disp}));
            }
        }
    }

    static class ShutterInfo {
        private final ShutterStatus status;
        private final Map<Axis, Map<BladeSetPosition, Double>> config;

        ShutterInfo(ShutterStatus status, Map<String, Double> minusXConfig, Map<String, Double> plusXConfig) {
            this.status = status;
            this.config = new EnumMap<Axis, Map<BladeSetPosition, Double>>(Axis.class);
            EnumMap<Axis, Map<String, Double>> conf = new EnumMap<Axis, Map<String, Double>>(Axis.class);
            conf.put(Axis.getPlusXSide(), plusXConfig);
            conf.put(Axis.getMinusXSide(), minusXConfig);
            for (Axis ax : Axis.values()) {
                EnumMap posmap = new EnumMap(BladeSetPosition.class);
                for (BladeSetPosition pos : BladeSetPosition.values()) {
                    posmap.put(pos, ((Map)conf.get((Object)ax)).get(pos.getKey()));
                }
                this.config.put(ax, posmap);
            }
        }

        private double getParam(Axis axis, BladeSetPosition pos) {
            return this.config.get((Object)axis).get((Object)pos);
        }

        public double getHome(Axis axis) {
            return this.getParam(axis, BladeSetPosition.HOME);
        }

        public double getRetracted(Axis axis) {
            return this.getParam(axis, BladeSetPosition.RETRACTED);
        }

        public double getCentered(Axis axis) {
            return this.getParam(axis, BladeSetPosition.CENTERED);
        }

        public double getExtended(Axis axis) {
            return this.getParam(axis, BladeSetPosition.EXTENDED);
        }

        public boolean isRetracted(Axis axis) {
            double pos = this.status.getAxisStatus(ShutterSide.fromAxis(axis)).getActPos();
            return Math.abs(pos - this.getHome(axis)) <= Math.abs(this.getRetracted(axis) - this.getHome(axis));
        }

        public boolean isExtended(Axis axis) {
            double pos = this.status.getAxisStatus(ShutterSide.fromAxis(axis)).getActPos();
            return Math.abs(pos - this.getHome(axis)) >= Math.abs(this.getExtended(axis) - this.getHome(axis));
        }

        public boolean shutterIsClosed() {
            return this.isRetracted(Axis.AXIS0) && this.isExtended(Axis.AXIS1) || this.isExtended(Axis.AXIS0) && this.isRetracted(Axis.AXIS1);
        }

        public boolean axesAreEnabled() {
            return this.status.getAxisStatus(ShutterSide.PLUSX).isEnabled() && this.status.getAxisStatus(ShutterSide.MINUSX).isEnabled();
        }

        public boolean brakesAreReleased() {
            return !this.status.getAxisStatus(ShutterSide.PLUSX).isBrakeEngaged() && !this.status.getAxisStatus(ShutterSide.MINUSX).isBrakeEngaged();
        }

        public boolean axesAreHomed() {
            return this.status.getAxisStatus(ShutterSide.PLUSX).isHomed() && this.status.getAxisStatus(ShutterSide.MINUSX).isHomed();
        }

        public boolean shutterIsCalibrated() {
            return this.status.isCalibrated();
        }

        public boolean isSafetyOn() {
            return this.status.isSafetyOn();
        }

        public String shutterIsReady() {
            boolean ready = true;
            StringBuilder errors = new StringBuilder("The shutter is not ready.");
            if (!this.shutterIsClosed()) {
                ready = false;
                errors.append("\nIt's not completely closed.");
            }
            if (!this.axesAreEnabled()) {
                ready = false;
                errors.append("\nAt least one axis is disabled.");
            }
            if (!this.brakesAreReleased()) {
                ready = false;
                errors.append("At least one brake is still engaged.");
            }
            if (!this.axesAreHomed()) {
                ready = false;
                errors.append("\nAt least one axis needs to be homed.");
            }
            if (!this.shutterIsCalibrated()) {
                ready = false;
                errors.append("\nIt's not calibrated.");
            }
            if (!this.isSafetyOn()) {
                ready = false;
                errors.append("\nSafety checks are not enabled.");
            }
            if (!ready) {
                LOG.warning((Object)errors.toString());
            }
            return ready ? null : errors.toString();
        }

        public boolean readyForCalibration() {
            boolean ready = true;
            if (!this.axesAreEnabled()) {
                LOG.warning((Object)"Shutter not ready - axes not enabled.");
                ready = false;
            }
            if (!this.brakesAreReleased()) {
                LOG.warning((Object)"Shutter not ready - brakes not released.");
                ready = false;
            }
            return ready;
        }

        public List<Axis> getCenteringOrder() {
            double extent2;
            double extent1 = Math.abs(this.status.getAxisStatus(ShutterSide.fromAxis(Axis.AXIS0)).getActPos() - this.getHome(Axis.AXIS0));
            if (extent1 >= (extent2 = Math.abs(this.status.getAxisStatus(ShutterSide.fromAxis(Axis.AXIS1)).getActPos() - this.getHome(Axis.AXIS1)))) {
                return Arrays.asList(Axis.AXIS0, Axis.AXIS1);
            }
            return Arrays.asList(Axis.AXIS1, Axis.AXIS0);
        }
    }

    private static class MessageWithState {
        private final BlockingQueue<Disposition> result = new ArrayBlockingQueue<Disposition>(1);
        private MsgToPLC sentMsg = null;
        private State curstate = State.NO_MESSAGE;

        public synchronized Disposition send(ADSDriver driver, MsgToPLC msg, VariableHandle handle) {
            Disposition disp = Disposition.OK;
            if (this.curstate == State.NO_MESSAGE) {
                try {
                    ByteBuffer buf = handle.createBuffer();
                    msg.encode(buf);
                    driver.writeVariable(handle, buf);
                    this.curstate = State.MESSAGE_SENT;
                    this.sentMsg = msg;
                    this.result.poll();
                }
                catch (DriverException exc) {
                    LOG.severe((Object)"Sending of a message to the shutter PLC failed.", (Throwable)exc);
                    disp = Disposition.SEND_ERROR;
                }
            } else {
                disp = Disposition.WRONG_STATE;
            }
            return disp;
        }

        public synchronized Disposition simSend(SimulatedShutter sim, MsgToPLC msg) {
            Disposition disp = Disposition.OK;
            if (this.curstate == State.NO_MESSAGE) {
                try {
                    sim.accept(msg);
                    this.curstate = State.MESSAGE_SENT;
                    this.sentMsg = msg;
                    this.result.poll();
                }
                catch (Exception exc) {
                    LOG.severe((Object)"Sending of a message to the shutter simulation failed.", (Throwable)exc);
                    disp = Disposition.SEND_ERROR;
                }
            } else {
                disp = Disposition.WRONG_STATE;
            }
            return disp;
        }

        public synchronized Disposition ack(MsgToPLC ackMsg) throws InterruptedException {
            if (this.curstate != State.MESSAGE_SENT) {
                return Disposition.WRONG_STATE;
            }
            this.curstate = State.MESSAGE_ACKED;
            if (this.sentMsg.hasSameIdent(ackMsg)) {
                this.result.put(Disposition.OK);
                return Disposition.OK;
            }
            this.result.put(Disposition.WRONG_ACK);
            return Disposition.WRONG_ACK;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Disposition awaitAck(Duration timeout) throws InterruptedException {
            try {
                Disposition disp = this.result.poll(timeout.toMillis(), TimeUnit.MILLISECONDS);
                Disposition disposition = disp != null ? disp : Disposition.ACK_TIMEOUT;
                return disposition;
            }
            finally {
                MessageWithState messageWithState = this;
                synchronized (messageWithState) {
                    this.curstate = State.NO_MESSAGE;
                    this.result.poll();
                }
            }
        }

        public static enum Disposition {
            OK,
            SEND_ERROR,
            WRONG_ACK,
            ACK_TIMEOUT,
            WRONG_STATE;

        }

        public static enum State {
            NO_MESSAGE,
            MESSAGE_SENT,
            MESSAGE_ACKED;

        }
    }
}

