/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.devices.dataforth;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.dataforth.Maq20Discrete;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20Device;

public class Maq20DiscControl
implements HasLifecycle {
    @LookupName
    protected String name;
    @LookupPath
    protected String path;
    @LookupField(strategy=LookupField.Strategy.ANCESTORS)
    protected Maq20Device maqDevc;
    protected Integer modIndex;
    private static final Logger LOG = Logger.getLogger(Maq20DiscControl.class.getName());
    private Maq20Device.ModuleData modData;

    public void init() {
        if (this.modIndex == null) {
            ErrorUtils.reportConfigError(LOG, this.path, "modIndex", "not specified");
        }
        this.modData = this.maqDevc.getModuleData(this.modIndex);
        if (this.modData == null) {
            ErrorUtils.reportConfigError(LOG, this.path, "modIndex (" + this.modIndex + ")", "specifies non-existent module");
        }
        if (this.modData.modDef.opType != 2) {
            ErrorUtils.reportConfigError(LOG, this.path, "modIndex (" + this.modIndex + ")", "specifies non-discrete module");
        }
    }

    public void setLineOn(int chan, boolean on) throws DriverException {
        this.getDisc().writeDisc(chan, on ? 1 : 0);
    }

    public Boolean isLineOn(int chan) {
        Boolean on = null;
        if (this.maqDevc.isOnline()) {
            try {
                on = this.getDisc().readDiscOut(chan) != 0;
            }
            catch (DriverException e) {
                LOG.log(Level.SEVERE, "Error reading {0} channel {1} state: {2}", new Object[]{this.path, chan, e});
                this.maqDevc.setOnline(false);
            }
        }
        return on;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    private Maq20Discrete getDisc() throws DriverException {
        if (this.modData.maqDisc == null) {
            throw new DriverException("Connection not open");
        }
        return this.modData.maqDisc;
    }
}

