/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.airwatch.main;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.framework.Signal;
import org.lsst.ccs.framework.SignalHandler;
import org.lsst.ccs.framework.SignalLevel;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.airwatch.main.Alerts;
import org.lsst.ccs.subsystem.airwatch.main.AnalogPoint;
import org.lsst.ccs.subsystem.airwatch.main.CounterPoint;
import org.lsst.ccs.subsystem.airwatch.main.DataPoint;
import org.lsst.ccs.subsystem.airwatch.main.DummyLocation;
import org.lsst.ccs.subsystem.airwatch.main.Location;
import org.lsst.ccs.subsystem.airwatch.main.LocationReport;
import org.lsst.ccs.subsystem.airwatch.main.LocationStatus;
import org.lsst.ccs.subsystem.airwatch.main.RestfulLocationSource;
import org.lsst.ccs.subsystem.airwatch.main.Utility;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.scheduler.PeriodicTask;

public final class AirwatchMain
extends Subsystem
implements ClearAlertHandler,
HasLifecycle,
SignalHandler {
    private static final int BUSY_TIMEOUT = 120000;
    @ConfigurationParameter(description="The interval between readings of server data.", units="s")
    private volatile Duration readoutInterval;
    @ConfigurationParameter(description="Gives both the valid location names and whether they're in working order (1) or broken (0).")
    private volatile Map<String, Integer> workingLocations;
    @ConfigurationParameter(description="The set of valid channel names.")
    private volatile List<String> channelNames;
    @ConfigurationParameter(description="The URL used to contact the RESTful location-data server.")
    private volatile URL restfulUrl;
    @ConfigurationParameter(description="How long to wait for a connection to the server.", units="s")
    private volatile Duration connectionTimeout;
    @ConfigurationParameter(description="How long to wait for data from the server after making the connection.", units="s")
    private volatile Duration readTimeout;
    @ConfigurationParameter(description="Use these locations, when possible, to calculate a dew point temperature for the IR2 main clean room.")
    private volatile List<String> dewLocations;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private volatile AlertService alertService;
    private final AtomicReference<Map<String, Location>> locations;
    private final Lock stateChangeLock;
    private PeriodicTask readoutTask;
    private final Logger log;
    public static final String N_DEW_TEMPS_KEY = "calculated/nDewTemps";
    public static final String N_DEW_HUMIDS_KEY = "calculated/nDewHumids";
    public static final String DEW_POINT_KEY = "calculated/dewPoint";

    @Command(type=Command.CommandType.QUERY, description="Displays a short report on location status.", level=0)
    public String locations() {
        return new LocationReport(this.locations.get()).toString();
    }

    @Command(type=Command.CommandType.ACTION, description="Suppresses data check alerts for a location. Use if the sensor is broken.", level=1, timeout=120100)
    public String disable(@Argument(description="The location name. Case is ignored.") String locName) throws Exception {
        return this.callIfNotBusy(() -> {
            HashMap<String, Location> mylocs = new HashMap<String, Location>(this.locations.get());
            Location loc = (Location)mylocs.get(locName.toUpperCase());
            if (loc == null) {
                throw new IllegalArgumentException("Invalid location name.");
            }
            mylocs.put(locName.toUpperCase(), loc.disable());
            this.locations.set(mylocs);
            return "OK";
        });
    }

    @Command(type=Command.CommandType.ACTION, description="Enables data check alerts for a location.", level=1, timeout=120100)
    public String enable(@Argument(description="The location name. Case is ignored.") String locName) throws Exception {
        return this.callIfNotBusy(() -> {
            HashMap<String, Location> mylocs = new HashMap<String, Location>(this.locations.get());
            Location loc = (Location)mylocs.get(locName.toUpperCase());
            if (loc == null) {
                throw new IllegalArgumentException("Invalid location name.");
            }
            mylocs.put(locName.toUpperCase(), loc.enable());
            this.locations.set(mylocs);
            return "OK";
        });
    }

    public TreeWalkerDiag signal(Signal sig) {
        if (sig.getLevel() == SignalLevel.STOP) {
            this.readoutTask.cancel(false);
        } else if (sig.getLevel() == SignalLevel.HALT) {
            this.readoutTask.cancel(true);
        }
        return TreeWalkerDiag.GO;
    }

    public AirwatchMain() {
        super("airwatch", AgentInfo.AgentType.WORKER);
        this.getAgentInfo().getAgentProperties().setProperty("org.lsst.ccs.use.full.paths", "true");
        this.alertService = null;
        this.log = Logger.getLogger((String)AirwatchMain.class.getName());
        this.readoutTask = null;
        this.stateChangeLock = new ReentrantLock();
        this.locations = new AtomicReference();
    }

    public void init() {
        ArrayList<String> missing = new ArrayList<String>();
        if (this.alertService == null) {
            missing.add("CCS alert service");
        }
        if (!missing.isEmpty()) {
            throw new RuntimeException("Can't find " + String.join((CharSequence)", ", missing));
        }
        DataProviderDictionaryService dictionary = (DataProviderDictionaryService)this.getAgentService(DataProviderDictionaryService.class);
        for (String locName : this.workingLocations.keySet()) {
            for (String chanName : this.channelNames) {
                DataPoint datum = null;
                datum = Character.isDigit(chanName.charAt(0)) ? new CounterPoint() : new AnalogPoint();
                dictionary.registerData((KeyValueData)datum.makeKvdList(locName, chanName));
            }
        }
        KeyValueDataList dew = new KeyValueDataList();
        dew.addData(N_DEW_TEMPS_KEY, (Serializable)Integer.valueOf(0));
        dew.addData(N_DEW_HUMIDS_KEY, (Serializable)Integer.valueOf(0));
        dew.addData(DEW_POINT_KEY, (Serializable)Double.valueOf(0.0));
        dictionary.registerData((KeyValueData)dew);
    }

    public void postStart() {
        this.locations.set(this.workingLocations.entrySet().stream().map(loc -> new DummyLocation((String)loc.getKey(), (Integer)loc.getValue() != 0)).collect(Collectors.toMap(dummy -> dummy.getStatus().location, dummy -> dummy)));
        this.readoutTask = this.getScheduler().scheduleWithFixedDelay(this::readoutTaskBody, 0L, this.readoutInterval.toMillis(), TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readoutTaskBody() {
        try {
            this.stateChangeLock.lockInterruptibly();
        }
        catch (InterruptedException exc) {
            Thread.currentThread().interrupt();
            return;
        }
        try {
            Set<String> enabledLocs = this.locations.get().entrySet().stream().filter(entry -> ((Location)entry.getValue()).getStatus().enabled).map(entry -> (String)entry.getKey()).collect(Collectors.toSet());
            RestfulLocationSource source = new RestfulLocationSource(this.restfulUrl, this.connectionTimeout, this.readTimeout, enabledLocs);
            Map<String, Location> newLocs = source.getLocations().stream().collect(Collectors.toMap(loc -> loc.getStatus().location, loc -> loc));
            this.locations.set(newLocs);
            for (Location loc2 : this.locations.get().values()) {
                LocationStatus status = loc2.getStatus();
                if (status.enabled) {
                    loc2.checkData(this.alertService);
                }
                loc2.publishGoodData(this);
            }
            this.publishDewPoint();
            TimeUnit.SECONDS.sleep(2L);
        }
        catch (InterruptedException exc) {
            Thread.currentThread().interrupt();
        }
        catch (IOException exc) {
            this.alertService.raiseAlert(Alerts.sensorIOAlert(), AlertState.WARNING, exc.getMessage());
        }
        finally {
            this.stateChangeLock.unlock();
        }
    }

    private String callIfNotBusy(Callable<String> cmd) throws Exception {
        if (!this.stateChangeLock.tryLock(120000L, TimeUnit.MILLISECONDS)) {
            return "BUSY";
        }
        try {
            String string = cmd.call();
            return string;
        }
        finally {
            this.stateChangeLock.unlock();
        }
    }

    private void publishDewPoint() {
        List<Double> temps = this.getGoodAnalogData("temp");
        List<Double> humids = this.getGoodAnalogData("humid");
        if (temps.isEmpty() || humids.isEmpty()) {
            this.log.log(Level.WARNING, "Cannot calculate dew point: nDewTemps = {0}, nDewHumids = {1}.", new Object[]{temps.size(), humids.size()});
            return;
        }
        double tempMean = temps.stream().mapToDouble(Double::doubleValue).average().getAsDouble();
        double humidMean = humids.stream().mapToDouble(Double::doubleValue).average().getAsDouble();
        double tdp = Utility.dewPoint(tempMean, humidMean);
        KeyValueDataList calc = new KeyValueDataList();
        calc.addData(N_DEW_TEMPS_KEY, (Serializable)Integer.valueOf(temps.size()));
        calc.addData(N_DEW_HUMIDS_KEY, (Serializable)Integer.valueOf(humids.size()));
        calc.addData(DEW_POINT_KEY, (Serializable)Double.valueOf(tdp));
        this.publishSubsystemDataOnStatusBus((KeyValueData)calc);
    }

    private List<Double> getGoodAnalogData(String chanName) {
        Map<String, Location> locs = this.locations.get();
        return locs.keySet().stream().filter(locName -> this.dewLocations.contains(locName)).map(locName -> (Location)locs.get(locName)).filter(loc -> loc.getDataPoints().containsKey(chanName)).map(loc -> loc.getDataPoints().get(chanName)).map(dp -> (AnalogPoint)dp).filter(ap -> ap.getQuality().equals("Good") && !ap.hasMalfunction()).map(ap -> ap.getValue()).collect(Collectors.toList());
    }
}

