/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.motorplatform.gantry;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.aerotech.AerotechPro165;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.framework.HardwareController;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.motorplatform.bus.AxisStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.ChangeAxisEnable;
import org.lsst.ccs.subsystem.motorplatform.bus.ChangeOutputLine;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAllFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAxisFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearCapture;
import org.lsst.ccs.subsystem.motorplatform.bus.ControllerStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.DisableAllAxes;
import org.lsst.ccs.subsystem.motorplatform.bus.EnableAllAxes;
import org.lsst.ccs.subsystem.motorplatform.bus.HomeAxis;
import org.lsst.ccs.subsystem.motorplatform.bus.IOStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.MotorCommandListener;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisAbsolute;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisRelative;
import org.lsst.ccs.subsystem.motorplatform.bus.PlatformConfig;
import org.lsst.ccs.subsystem.motorplatform.bus.SendAxisStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.SendConfiguration;
import org.lsst.ccs.subsystem.motorplatform.bus.SendControllerStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.SetupCapture;
import org.lsst.ccs.subsystem.motorplatform.bus.StopAllMotion;
import org.lsst.ccs.subsystem.motorplatform.bus.gantry.GantryCommandListener;
import org.lsst.ccs.subsystem.motorplatform.bus.gantry.GantryOrientation;
import org.lsst.ccs.subsystem.motorplatform.bus.gantry.GantryStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.gantry.IgnoreLoadCell;
import org.lsst.ccs.subsystem.motorplatform.bus.gantry.LoadCellStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.gantry.SetOrientation;
import org.lsst.ccs.subsystem.motorplatform.bus.gantry.StopAxis;
import org.lsst.ccs.subsystem.motorplatform.bus.gantry.WeighRaft;
import org.lsst.ccs.subsystem.motorplatform.gantry.AnalogInput;
import org.lsst.ccs.subsystem.motorplatform.gantry.Axis;
import org.lsst.ccs.subsystem.motorplatform.gantry.DigitalInput;
import org.lsst.ccs.subsystem.motorplatform.gantry.DigitalOutput;
import org.lsst.ccs.subsystem.motorplatform.gantry.DriverErrorType;
import org.lsst.ccs.subsystem.motorplatform.gantry.LoadCellAxis;
import org.lsst.ccs.subsystem.motorplatform.main.CheckException;
import org.lsst.ccs.utilities.logging.Logger;

public class Ensemble
implements MotorCommandListener,
GantryCommandListener,
HardwareController,
HasLifecycle {
    private static final Logger LOG = Logger.getLogger((String)Ensemble.class.getPackage().getName());
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Subsystem subsys;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alerts;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private List<Axis> axisComponents = Collections.synchronizedList(new ArrayList());
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private List<LoadCellAxis> loadCellAxes = Collections.synchronizedList(new ArrayList());
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private List<DigitalInput> digitalIns = Collections.synchronizedList(new ArrayList());
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private List<DigitalOutput> digitalOuts = Collections.synchronizedList(new ArrayList());
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private List<AnalogInput> analogs = Collections.synchronizedList(new ArrayList());
    @ConfigurationParameter(description="The name of the configuration used.")
    private volatile String configurationName = "<safe default>";
    @ConfigurationParameter(description="The IP address of the motor controller.")
    private volatile String IPv4Address = "192.168.10.40";
    @ConfigurationParameter(description="The interval between periodic status updates.")
    private volatile Duration statusUpdateInterval = Duration.ofMillis(1000L);
    @ConfigurationParameter(description="The minimum good air pressure value in bars.")
    private volatile double minAirPressure = 5.5;
    @ConfigurationParameter(description="The maximum good aire pressure value in bars.")
    private volatile double maxAirPressure = 6.5;
    private volatile Map<String, Axis> axisMap;
    private volatile ExecutorService mainExec;
    private volatile ScheduledExecutorService queryExec;
    private volatile BlockingQueue<KeyValueData> resultQueue;
    private volatile String commStatus;
    private volatile boolean mainLinkIsUp = false;
    private volatile boolean queryLinkIsUp = false;
    private final AtomicInteger mainDriverErrorCount;
    private final AtomicInteger queryDriverErrorCount;
    private static final int ERROR_COUNT_INIT = 10;
    private volatile String actionStatus;
    private volatile GantryOrientation currentOrientation;
    private volatile double raftWeight = 0.0;
    private volatile AerotechPro165 mainLink;
    private volatile AerotechPro165 queryLink;
    private static final Alert commandAlert = new Alert("COMMAND", "Illegal or failed controller command.");
    private static final Alert commAlert = new Alert("COMMUNICATION", "Comm problem with controller.");
    private static final Alert usageAlert = new Alert("USAGE", "Wrong use of driver call or subsystem.");
    private static final Alert otherAlert = new Alert("OTHER", "An unexpected exception or other problem.");
    private final AtomicReference<List<Integer>> ioDescriptors = new AtomicReference();
    private static final int TASK_RUNNING = 3;
    private final int MAIN_LINK_PORT = 8000;
    private final int QUERY_LINK_PORT = 8001;

    private Ensemble() {
        this.mainDriverErrorCount = new AtomicInteger(10);
        this.queryDriverErrorCount = new AtomicInteger(10);
    }

    public KeyValueData getNextResult() throws InterruptedException {
        return this.resultQueue.take();
    }

    public void init() {
        if (this.loadCellAxes.size() != 1) {
            throw new RuntimeException("There must be exactly one LoadCellAxis component.");
        }
        if (this.digitalIns.size() + this.digitalOuts.size() + this.analogs.size() > 19) {
            throw new RuntimeException("Too many Aerotech I/O channels are defined.");
        }
        this.digitalIns.sort((x, y) -> Integer.compare(x.getOrder(), y.getOrder()));
        this.digitalOuts.sort((x, y) -> Integer.compare(x.getOrder(), y.getOrder()));
        this.analogs.sort((x, y) -> Integer.compare(x.getOrder(), y.getOrder()));
        ArrayList<Integer> iodesc = new ArrayList<Integer>();
        int globalOrder = 0;
        for (DigitalInput din : this.digitalIns) {
            din.setGlobalOrder(globalOrder++);
            iodesc.add(din.getDescriptor());
        }
        for (DigitalOutput dout : this.digitalOuts) {
            dout.setGlobalOrder(globalOrder++);
            iodesc.add(dout.getDescriptor());
        }
        for (AnalogInput ana : this.analogs) {
            ana.setGlobalOrder(globalOrder++);
            iodesc.add(ana.getDescriptor());
        }
        this.ioDescriptors.set(Collections.unmodifiableList(iodesc));
    }

    public void start() {
        long updateMillis = this.statusUpdateInterval.toMillis();
        if (this.queryExec != null) {
            this.queryExec.scheduleWithFixedDelay(this::publishControllerStatus, 0L, updateMillis, TimeUnit.MILLISECONDS);
            this.queryExec.scheduleWithFixedDelay(this::publishAllAxisStatus, 0L, updateMillis, TimeUnit.MILLISECONDS);
            this.queryExec.scheduleWithFixedDelay(this::publishIOStatus, 0L, updateMillis, TimeUnit.MILLISECONDS);
            this.queryExec.scheduleWithFixedDelay(this::publishLoadCellStatus, 0L, updateMillis, TimeUnit.MILLISECONDS);
            this.queryExec.scheduleWithFixedDelay(this::publishGantryStatus, 0L, updateMillis, TimeUnit.MILLISECONDS);
        }
    }

    public TreeWalkerDiag checkHardware() throws HardwareException {
        try {
            this.createCommLinks();
            this.queryLinkIsUp = true;
            this.mainLinkIsUp = true;
        }
        catch (Exception ex) {
            throw new HardwareException(true, (Throwable)ex);
        }
        this.resultQueue = new ArrayBlockingQueue<KeyValueData>(1000);
        this.axisMap = new TreeMap<String, Axis>();
        for (Axis a : this.axisComponents) {
            this.axisMap.put(a.getName(), a);
        }
        this.currentOrientation = GantryOrientation.DEGREES_0;
        this.actionStatus = "OK";
        this.mainExec = Executors.newSingleThreadExecutor();
        this.queryExec = Executors.newSingleThreadScheduledExecutor();
        try {
            Ensemble.setDGlobal(this.mainLink, 10, (double)this.statusUpdateInterval.toMillis() / 1000.0);
            for (int i = 0; i < this.ioDescriptors.get().size(); ++i) {
                Ensemble.setDGlobal(this.mainLink, 12 + i, this.ioDescriptors.get().get(i).intValue());
            }
            Ensemble.setDGlobal(this.mainLink, 11, this.ioDescriptors.get().size());
            this.loadCellAxes.get(0).uploadTables(this.mainLink);
        }
        catch (DriverException exc) {
            throw new HardwareException(true, (Throwable)exc);
        }
        return TreeWalkerDiag.GO;
    }

    private static void setDGlobal(AerotechPro165 aero, int index, double value) throws DriverException {
        aero.readAP(String.format("DGLOBAL(%d) = %g", index, value));
    }

    public void checkStopped() throws HardwareException {
        try {
            this.mainExec.shutdownNow();
            this.mainExec.awaitTermination(50L, TimeUnit.MILLISECONDS);
            this.queryExec.shutdownNow();
            this.queryExec.awaitTermination(50L, TimeUnit.MILLISECONDS);
            this.stopEverything(this.mainLink);
        }
        catch (InterruptedException exc) {
            LOG.log(Level.SEVERE, "Hardware shutdown was interrupted!", (Throwable)exc);
            Thread.currentThread().interrupt();
        }
        finally {
            this.queryLinkIsUp = false;
            this.mainLinkIsUp = false;
            this.actionStatus = "STOPPED";
        }
    }

    public void changeAxisEnable(ChangeAxisEnable cmdOrig) {
        ChangeAxisEnable cmd = this.transform(cmdOrig);
        this.runMotionControl(aero -> {
            Axis axis = this.getAxis(cmd.getAxisName());
            if (cmd.isEnabled()) {
                axis.enable((AerotechPro165)aero);
            } else {
                axis.disable((AerotechPro165)aero);
            }
            this.sendAxisStatus(new SendAxisStatus(cmdOrig.getAxisName()));
        }, "changeAxisEnable");
    }

    public void changeOutputLine(ChangeOutputLine cmd) {
        DigitalOutput out = this.digitalOuts.get(cmd.getLineIndex());
        this.runMotionControl(aero -> out.setState((AerotechPro165)aero, cmd.getNewState()), "changeOutputLine");
        this.publishIOStatus();
    }

    public void clearAllFaults(ClearAllFaults cmd) {
        this.runMotionControl(aero -> {
            this.acknowledgeAll((AerotechPro165)aero);
            this.axisMap.values().stream().forEach(axis -> this.sendAxisStatus(new SendAxisStatus(axis.getName())));
        }, "clearAllFaults");
    }

    public void clearAxisFaults(ClearAxisFaults cmdOrig) {
        ClearAxisFaults cmd = this.transform(cmdOrig);
        this.runMotionControl(aero -> {
            Axis axis = this.getAxis(cmd.getAxisName());
            axis.clearFaults((AerotechPro165)aero);
            this.sendAxisStatus(new SendAxisStatus(cmdOrig.getAxisName()));
        }, "clearAxisFaults");
    }

    public void clearCapture(ClearCapture cmd) {
    }

    public void enableAllAxes(EnableAllAxes cmd) {
        this.runMotionControl(aero -> this.axisMap.keySet().stream().forEach(name -> {
            this.axisMap.get(name).enable((AerotechPro165)aero);
            TransformInfo info = this.transformFromMotor((String)name, 0.0, false);
            this.sendAxisStatus(new SendAxisStatus(info.axisName));
        }), "enableAllAxes");
    }

    public void disableAllAxes(DisableAllAxes cmd) {
        this.runMotionControl(aero -> this.axisMap.keySet().stream().forEach(name -> {
            this.axisMap.get(name).disable((AerotechPro165)aero);
            TransformInfo info = this.transformFromMotor((String)name, 0.0, false);
            this.sendAxisStatus(new SendAxisStatus(info.axisName));
        }), "disableAllAxes");
    }

    public void moveAxisRelative(MoveAxisRelative cmdOrig) {
        MoveAxisRelative cmd = this.transform(cmdOrig);
        this.runMotionControl(aero -> {
            if (this.motionInProgress((AerotechPro165)aero)) {
                throw new CheckException("BUSY", "Controller is busy with a prior move.");
            }
            Axis axis = this.getAxis(cmd.getAxisName());
            int code = axis.getMoveCompletionCode((AerotechPro165)aero);
            if (code != 0) {
                this.actionStatus = "CODE " + code;
            }
            double startPos = axis.getPosition((AerotechPro165)aero);
            axis.moveRelative((AerotechPro165)aero, cmd);
            this.sendAxisStatus(new SendAxisStatus(cmdOrig.getAxisName()));
        }, "moveAxisRelative");
    }

    public void moveAxisAbsolute(MoveAxisAbsolute cmdOrig) {
        MoveAxisAbsolute cmd = this.transform(cmdOrig);
        this.runMotionControl(aero -> {
            Axis axis = this.getAxis(cmd.getAxisName());
            axis.moveAbsolute((AerotechPro165)aero, cmd);
            this.sendAxisStatus(new SendAxisStatus(cmdOrig.getAxisName()));
        }, "moveAxisAbsolute");
    }

    public void homeAxis(HomeAxis cmd) {
    }

    public void sendAxisStatus(SendAxisStatus cmdOrig) {
        SendAxisStatus cmd = this.transform(cmdOrig);
        this.publishAxisStatus(cmd.getAxisName());
    }

    public void sendConfiguration(SendConfiguration cmd) {
        PlatformConfig config = this.getConfiguration();
        try {
            this.resultQueue.put(new KeyValueData("PlatformConfig", (Serializable)config));
        }
        catch (InterruptedException ex) {
            LOG.log(Level.SEVERE, "Sending of platform configuration was interrupted.", (Throwable)ex);
            Thread.currentThread().interrupt();
        }
    }

    public PlatformConfig getConfiguration() {
        ArrayList<Axis> axes = new ArrayList<Axis>(this.axisComponents);
        axes.sort((x, y) -> Integer.compare(x.getIndex(), y.getIndex()));
        ArrayList<DigitalInput> dins = new ArrayList<DigitalInput>(this.digitalIns);
        dins.sort((x, y) -> Integer.compare(x.getOrder(), y.getOrder()));
        ArrayList<DigitalOutput> douts = new ArrayList<DigitalOutput>(this.digitalOuts);
        douts.sort((x, y) -> Integer.compare(x.getOrder(), y.getOrder()));
        ArrayList<AnalogInput> ains = new ArrayList<AnalogInput>(this.analogs);
        ains.sort((x, y) -> Integer.compare(x.getOrder(), y.getOrder()));
        PlatformConfig config = new PlatformConfig(axes.stream().map(Axis::getName).collect(Collectors.toList()), Collections.emptyList(), dins.stream().map(DigitalInput::getName).collect(Collectors.toList()), douts.stream().map(DigitalOutput::getName).collect(Collectors.toList()), ains.stream().map(AnalogInput::getDescription).collect(Collectors.toList()), this.configurationName, axes.stream().map(Axis::getUnits).collect(Collectors.toList()));
        return config;
    }

    public void sendControllerStatus(SendControllerStatus cmd) {
        this.publishControllerStatus();
    }

    public void setupCapture(SetupCapture cmd) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAllMotion(StopAllMotion cmd) {
        String actstat = "FAILED";
        try {
            String cmdstr = this.axisMap.values().stream().map(Axis::getName).collect(Collectors.joining(" ", "ABORT ", ""));
            Ensemble ensemble = this;
            synchronized (ensemble) {
                this.mainLink.writeAP(cmdstr);
            }
            actstat = "OK";
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Could not stop motion.", (Throwable)ex);
        }
        finally {
            this.actionStatus = actstat;
        }
    }

    private ChangeAxisEnable transform(ChangeAxisEnable cmd) {
        TransformInfo motor = this.transformToMotor(cmd.getAxisName(), 0.0);
        return new ChangeAxisEnable(motor.axisName, cmd.isEnabled());
    }

    private ClearAxisFaults transform(ClearAxisFaults cmd) {
        TransformInfo motor = this.transformToMotor(cmd.getAxisName(), 0.0);
        return new ClearAxisFaults(motor.axisName);
    }

    private MoveAxisRelative transform(MoveAxisRelative cmd) {
        TransformInfo motor = this.transformToMotor(cmd.getAxisName(), cmd.getDistance());
        return new MoveAxisRelative(motor.axisName, motor.coord, cmd.getTime());
    }

    private MoveAxisAbsolute transform(MoveAxisAbsolute cmd) {
        TransformInfo motor = this.transformToMotor(cmd.getAxisName(), cmd.getPosition());
        return new MoveAxisAbsolute(motor.axisName, motor.coord, cmd.getSpeed());
    }

    private SendAxisStatus transform(SendAxisStatus cmd) {
        TransformInfo motor = this.transformToMotor(cmd.getAxisName(), 0.0);
        return new SendAxisStatus(motor.axisName);
    }

    private StopAxis transform(StopAxis cmd) {
        TransformInfo motor = this.transformToMotor(cmd.getAxisName(), 0.0);
        return new StopAxis(motor.axisName);
    }

    private AxisStatus transform(AxisStatus status) {
        TransformInfo global = this.transformFromMotor(status.getAxisName(), status.getPosition(), true);
        return new AxisStatus(global.axisName, status.isEnabled(), status.isMoving(), status.isAtHome(), status.isAtLowLimit(), status.isAtHighLimit(), status.getFaults(), global.coord);
    }

    private TransformInfo transformToMotor(String globalAxisName, double globalCoordinate) {
        String motorAxisName = globalAxisName;
        double motorCoordinate = globalCoordinate;
        if (globalAxisName.equals("X")) {
            switch (this.currentOrientation) {
                case DEGREES_0: {
                    break;
                }
                case DEGREES_90: {
                    motorAxisName = "Y";
                    motorCoordinate = -globalCoordinate;
                    break;
                }
                case DEGREES_180: {
                    motorAxisName = "X";
                    motorCoordinate = -globalCoordinate;
                    break;
                }
                case DEGREES_270: {
                    motorAxisName = "Y";
                    motorCoordinate = globalCoordinate;
                }
            }
        } else if (globalAxisName.equals("Y")) {
            switch (this.currentOrientation) {
                case DEGREES_0: {
                    break;
                }
                case DEGREES_90: {
                    motorAxisName = "X";
                    motorCoordinate = globalCoordinate;
                    break;
                }
                case DEGREES_180: {
                    motorAxisName = "Y";
                    motorCoordinate = -globalCoordinate;
                    break;
                }
                case DEGREES_270: {
                    motorAxisName = "X";
                    motorCoordinate = -globalCoordinate;
                }
            }
        }
        return new TransformInfo(motorAxisName, motorCoordinate);
    }

    private TransformInfo transformFromMotor(String motorAxisName, double motorCoordinate, boolean isAbsolute) {
        String globalAxisName = motorAxisName;
        double globalCoordinate = motorCoordinate;
        if (motorAxisName.equals("X")) {
            switch (this.currentOrientation) {
                case DEGREES_0: {
                    break;
                }
                case DEGREES_90: {
                    globalAxisName = "Y";
                    globalCoordinate = motorCoordinate;
                    break;
                }
                case DEGREES_180: {
                    globalAxisName = "X";
                    globalCoordinate = -motorCoordinate;
                    break;
                }
                case DEGREES_270: {
                    globalAxisName = "Y";
                    globalCoordinate = -motorCoordinate;
                }
            }
        } else if (motorAxisName.equals("Y")) {
            switch (this.currentOrientation) {
                case DEGREES_0: {
                    break;
                }
                case DEGREES_90: {
                    globalAxisName = "X";
                    globalCoordinate = -motorCoordinate;
                    break;
                }
                case DEGREES_180: {
                    globalAxisName = "Y";
                    globalCoordinate = -motorCoordinate;
                    break;
                }
                case DEGREES_270: {
                    globalAxisName = "X";
                    globalCoordinate = motorCoordinate;
                }
            }
        }
        return new TransformInfo(globalAxisName, globalCoordinate);
    }

    public void ignoreLoadCell(IgnoreLoadCell cmd) {
        this.loadCellAxes.get(0).setIgnoreLoadCell(cmd.isIgnored());
    }

    public void weighRaft(WeighRaft cmd) {
        this.runMotionControl(aero -> {
            LoadCellAxis axis = this.getLoadCellAxis();
            AnalogInput load = axis.getLoadCell();
            this.raftWeight = load.readValue((AerotechPro165)aero);
            aero.readAP(String.format("DGLOBAL(%d) = %g", 180, load.engineeringUnitsToVolts(this.raftWeight)));
        }, "weighRaft");
    }

    public void setOrientation(SetOrientation cmd) {
        this.currentOrientation = cmd.getOrientation();
    }

    public void stopAxis(StopAxis cmdOrig) {
        StopAxis cmd = this.transform(cmdOrig);
        this.runMotionControl(aero -> aero.readAP("ABORT " + cmd.getAxisName()), "stopAxis");
    }

    private void publishIOStatus() {
        this.runQueryCommand(aero -> {
            int state = (int)aero.readDoubleAP("TASKSTATE(5)");
            int error = (int)aero.readDoubleAP("TASKERROR(5)");
            if (state != 3) {
                aero.readAP("PROGRAM RUN 5, \"ReadIO.bcx\"");
                LOG.log(Level.WARNING, "ReadIO was restarted; task state was {0}, error code was {1}.", (Object[])new Integer[]{state, error});
                throw new IllegalStateException("ReadIO had to be restarted.");
            }
            int dins = 0;
            int douts = 0;
            ArrayList<Double> anas = new ArrayList<Double>();
            for (DigitalInput din : this.digitalIns) {
                dins |= din.readValue((AerotechPro165)aero) << din.getOrder();
            }
            for (DigitalOutput dout : this.digitalOuts) {
                douts |= dout.readValue((AerotechPro165)aero) << dout.getOrder();
            }
            for (AnalogInput ana : this.analogs) {
                anas.add(ana.readValue((AerotechPro165)aero));
            }
            this.resultQueue.put(new KeyValueData("IOStatus", (Serializable)new IOStatus(dins, douts, anas)));
        });
    }

    private void publishLoadCellStatus() {
        this.runQueryCommand(aero -> {
            double z = this.loadCellAxes.get(0).getPosition((AerotechPro165)aero);
            AnalogInput ana = this.loadCellAxes.get(0).getLoadCell();
            this.resultQueue.put(new KeyValueData("LoadCellStatus", (Serializable)new LoadCellStatus(ana.readValue((AerotechPro165)aero), z)));
        });
    }

    private void publishGantryStatus() {
        this.runQueryCommand(aero -> {
            double lc = this.loadCellAxes.get(0).getLoadCell().readValue((AerotechPro165)aero);
            double pressure = this.analogs.size() > 1 ? this.analogs.get(1).readValue((AerotechPro165)aero) : 0.0;
            this.resultQueue.put(new KeyValueData("GantryStatus", (Serializable)new GantryStatus(lc, this.raftWeight, pressure, pressure >= this.minAirPressure && pressure <= this.maxAirPressure, this.currentOrientation, this.loadCellAxes.get(0).isIgnored())));
        });
    }

    private void publishControllerStatus() {
        this.runQueryCommand(aero -> {
            boolean motionEnabled = false;
            try {
                motionEnabled = !this.checkEstop((AerotechPro165)aero);
            }
            catch (Exception exc) {
                this.queryLinkIsUp = false;
            }
            String commStatus = "DOWN";
            if (this.mainLinkIsUp && this.queryLinkIsUp) {
                commStatus = "UP";
            }
            ControllerStatus status = new ControllerStatus(commStatus, motionEnabled, this.actionStatus);
            this.resultQueue.put(new KeyValueData("ControllerStatus", (Serializable)status));
        });
    }

    private void publishAllAxisStatus() {
        this.axisMap.values().forEach(axis -> this.publishAxisStatus(axis.getName()));
    }

    private void publishAxisStatus(String axisName) {
        this.runQueryCommand(acr -> {
            Axis axis = this.getAxis(axisName);
            this.resultQueue.put(new KeyValueData("AxisStatus", (Serializable)this.transform(axis.getStatus((AerotechPro165)acr))));
        });
    }

    private void runMotionControl(MyConsumer<AerotechPro165> action, String actionName) {
        if (!this.mainExec.isShutdown()) {
            String[] actstat = new String[]{"FAILED"};
            this.mainExec.submit(() -> {
                Ensemble ensemble = this;
                // MONITORENTER : ensemble
                try {
                    action.accept(this.mainLink);
                    actstat[0] = "OK";
                    return;
                }
                catch (InterruptedException exc) {
                    LOG.log(Level.SEVERE, "{0} was interrupted. {1}", new Object[]{actionName, exc});
                    return;
                }
                catch (Exception exc) {
                    AlertState astate = this.decErrorCounter(this.mainDriverErrorCount);
                    Level llevel = astate == AlertState.WARNING ? Level.WARNING : Level.SEVERE;
                    DriverErrorType errType = DriverErrorType.classifyError(exc);
                    switch (errType) {
                        case COMMAND_ERROR: {
                            LOG.log(llevel, "Controller command was illegal or failed.", (Throwable)exc);
                            this.cleanupAfterProgramFailure(this.mainLink);
                            this.alerts.raiseAlert(commandAlert, astate, exc.toString());
                            return;
                        }
                        case COMMUNICATION_ERROR: {
                            LOG.log(llevel, "Command failed to run due to I/O error.", (Throwable)exc);
                            this.alerts.raiseAlert(commAlert, astate, exc.toString());
                            this.mainLinkIsUp = false;
                            this.mainLink = this.reopenLink(this.queryLink, false);
                            if (this.mainLink == null) {
                                this.mainLink = new AerotechPro165();
                                return;
                            }
                            this.mainLinkIsUp = true;
                            return;
                        }
                        case USAGE_ERROR: {
                            LOG.log(llevel, "Wrong driver call may have been used for a command.", (Throwable)exc);
                            this.alerts.raiseAlert(usageAlert, astate, exc.toString());
                            return;
                        }
                    }
                    LOG.log(llevel, "Error during an attempted command execution.", (Throwable)exc);
                    this.cleanupAfterProgramFailure(this.mainLink);
                    this.alerts.raiseAlert(otherAlert, astate, exc.toString());
                    return;
                }
                finally {
                    this.actionStatus = actstat[0];
                }
            });
        }
    }

    private void resetErrorCounter(AtomicInteger counter) {
        counter.set(10);
    }

    private AlertState decErrorCounter(AtomicInteger counter) {
        if (counter.decrementAndGet() <= 0) {
            return AlertState.ALARM;
        }
        return AlertState.WARNING;
    }

    private AerotechPro165 reopenLink(AerotechPro165 aero, boolean isMain) {
        int port = isMain ? 8000 : 8001;
        try {
            aero.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        AerotechPro165 newLink = new AerotechPro165();
        try {
            newLink.openNet(this.IPv4Address, port);
        }
        catch (Exception exc) {
            LOG.log(Level.SEVERE, String.format("Failed to reopen link to controller port %d.", port), (Throwable)exc);
            newLink = null;
        }
        return newLink;
    }

    private void runQueryCommand(MyConsumer<AerotechPro165> action) {
        if (!this.queryExec.isShutdown()) {
            this.queryExec.submit(() -> {
                try {
                    action.accept(this.queryLink);
                    this.resetErrorCounter(this.queryDriverErrorCount);
                }
                catch (InterruptedException exc) {
                    LOG.warning((Object)"Query executor has been shut down.");
                }
                catch (Exception exc) {
                    AlertState astate = this.decErrorCounter(this.queryDriverErrorCount);
                    Level llevel = astate == AlertState.WARNING ? Level.WARNING : Level.SEVERE;
                    DriverErrorType errType = DriverErrorType.classifyError(exc);
                    switch (errType) {
                        case COMMAND_ERROR: {
                            LOG.log(llevel, "Query command was illegal or failed.", (Throwable)exc);
                            this.alerts.raiseAlert(commandAlert, astate, exc.toString());
                            break;
                        }
                        case COMMUNICATION_ERROR: {
                            LOG.log(llevel, "Query failed to run due to I/O error.", (Throwable)exc);
                            this.alerts.raiseAlert(commAlert, astate, exc.toString());
                            this.queryLinkIsUp = false;
                            this.queryLink = this.reopenLink(this.queryLink, false);
                            if (this.queryLink == null) {
                                this.queryLink = new AerotechPro165();
                                break;
                            }
                            this.queryLinkIsUp = true;
                            break;
                        }
                        case USAGE_ERROR: {
                            LOG.log(llevel, "Wrong driver call may have been used for a query.", (Throwable)exc);
                            this.alerts.raiseAlert(usageAlert, astate, exc.toString());
                            break;
                        }
                        default: {
                            LOG.log(llevel, "Error during an attempted query.", (Throwable)exc);
                            this.alerts.raiseAlert(otherAlert, astate, exc.toString());
                        }
                    }
                }
            });
        }
    }

    private boolean motionInProgress(AerotechPro165 aero) throws DriverException {
        TaskState state = TaskState.values()[(int)aero.readDoubleAP("TASKSTATE(1)")];
        return state == TaskState.RUNNING || state == TaskState.PAUSED;
    }

    private void cleanupAfterProgramFailure(AerotechPro165 aero) {
        LOG.log(Level.WARNING, "{0}", (Object)"Motion control command failed. Commencing cleanup.");
        try {
            this.stopEverything(aero);
        }
        catch (Exception exc) {
            LOG.log(Level.WARNING, "Unable to stop motion after a motion control command failed.", (Throwable)exc);
        }
    }

    private Axis getAxis(String name) throws IllegalArgumentException {
        Axis axis = this.axisMap.get(name);
        if (axis == null) {
            throw new IllegalArgumentException(String.format("%s is a bad axis name.", name));
        }
        return axis;
    }

    private void stopEverything(AerotechPro165 aero) {
        String abort = this.axisMap.values().stream().map(Axis::getName).collect(Collectors.joining(" ", "ABORT ", ""));
        try {
            aero.writeAP("PROGRAM STOP 1");
            aero.writeAP(abort);
        }
        catch (DriverException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void createCommLinks() {
        try {
            this.mainLink = new AerotechPro165();
            this.mainLink.openNet(this.IPv4Address, 8000);
            this.queryLink = new AerotechPro165();
            this.queryLink.openNet(this.IPv4Address, 8001);
        }
        catch (DriverException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void acknowledgeAll(AerotechPro165 aero) {
        try {
            aero.writeAP("ACKNOWLEDGEALL");
        }
        catch (DriverException ex) {
            throw new RuntimeException(ex);
        }
    }

    private boolean checkEstop(AerotechPro165 aero) {
        for (Axis ax : this.axisMap.values()) {
            if (!ax.hasESTOP(aero)) continue;
            return true;
        }
        return false;
    }

    private LoadCellAxis getLoadCellAxis() {
        return this.loadCellAxes.get(0);
    }

    private static enum TaskState {
        INACTIVE,
        IDLE,
        READY,
        RUNNING,
        PAUSED,
        COMPLETE,
        ERROR;

    }

    private static interface MyConsumer<T> {
        public void accept(T var1) throws Exception;
    }

    private static class TransformInfo {
        final String axisName;
        final double coord;

        TransformInfo(String axisName, double coord) {
            this.axisName = axisName;
            this.coord = coord;
        }
    }
}

