/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.vacuum.data;

import java.io.Serializable;
import java.util.Arrays;
import org.lsst.ccs.bus.annotations.SkipEncoding;
import org.lsst.ccs.subsystem.vacuum.constants.ConditionState;
import org.lsst.ccs.subsystem.vacuum.constants.CryoVacuumState;
import org.lsst.ccs.subsystem.vacuum.constants.DeviceState;
import org.lsst.ccs.subsystem.vacuum.constants.HxVacuumState;
import org.lsst.ccs.subsystem.vacuum.constants.LatchState;
import org.lsst.ccs.subsystem.vacuum.constants.PLCState;
import org.lsst.ccs.subsystem.vacuum.constants.SwitchEnable;
import org.lsst.ccs.subsystem.vacuum.constants.SwitchState;

@SkipEncoding
public class VacSysState
implements Serializable {
    public static final String KEY = "VacuumState";
    private int tickMillis;
    private CryoVacuumState cryoVacuumState = CryoVacuumState.UNKNOWN;
    private HxVacuumState hxVacuumState = HxVacuumState.UNKNOWN;
    private PLCState plcState = PLCState.ALIVE;
    private final SwitchState[] switchState = new SwitchState[19];
    private final SwitchEnable[] switchEnable = new SwitchEnable[19];
    private final DeviceState[] deviceState = new DeviceState[19];
    private final LatchState[] latchState = new LatchState[8];
    private final ConditionState[] conditionState = new ConditionState[10];
    private static final long serialVersionUID = -2669272698864689859L;

    public VacSysState() {
        Arrays.fill((Object[])this.switchState, (Object)SwitchState.OFFLINE);
        Arrays.fill((Object[])this.switchEnable, (Object)SwitchEnable.OFF);
        Arrays.fill((Object[])this.latchState, (Object)LatchState.CLEAR);
        Arrays.fill((Object[])this.conditionState, (Object)ConditionState.NO);
    }

    public void setTickMillis(int value) {
        this.tickMillis = value;
    }

    public int getTickMillis() {
        return this.tickMillis;
    }

    public void setCryoVacuumState(CryoVacuumState value) {
        this.cryoVacuumState = value;
    }

    public CryoVacuumState getCryoVacuumState() {
        return this.cryoVacuumState;
    }

    public void setHxVacuumState(HxVacuumState value) {
        this.hxVacuumState = value;
    }

    public HxVacuumState getHxVacuumState() {
        return this.hxVacuumState;
    }

    public void setPlcState(PLCState value) {
        this.plcState = value;
    }

    public PLCState getPlcState() {
        return this.plcState;
    }

    public void setSwitchState(int sw, SwitchState state) {
        this.switchState[sw] = state;
    }

    public SwitchState getSwitchState(int sw) {
        return this.switchState[sw];
    }

    public void setSwitchEnable(int sw, SwitchEnable enable) {
        this.switchEnable[sw] = enable;
    }

    public SwitchEnable getSwitchEnable(int sw) {
        return this.switchEnable[sw];
    }

    public void setDeviceState(int sw, DeviceState state) {
        this.deviceState[sw] = state;
    }

    public DeviceState getDeviceState(int sw) {
        return this.deviceState[sw];
    }

    public void setLatch(int latch, LatchState state) {
        this.latchState[latch] = state;
    }

    public LatchState getLatch(int latch) {
        return this.latchState[latch];
    }

    public void setCondition(int cond, ConditionState state) {
        this.conditionState[cond] = state;
    }

    public ConditionState getCondition(int cond) {
        return this.conditionState[cond];
    }
}

