/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.mks.GP390;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.subsystem.common.ErrorUtils;

public class GP390Device
extends Device {
    private static final int BAUD_RATE = 19200;
    private String serial;
    private int address;
    private static final Logger LOG = Logger.getLogger(GP390Device.class.getName());
    private final GP390 gp = new GP390();
    private boolean initError = false;

    public GP390Device(String serialNo, int addr) {
        this.serial = serialNo;
        this.address = addr;
    }

    public GP390Device() {
    }

    protected void initDevice() {
        super.configure(this.mon);
        if (this.serial == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.getName(), (String)"serial", (String)"is missing");
        }
        this.fullName = "GP390 vacuum gauge (" + this.serial + ":" + this.address + ")";
    }

    protected void initialize() {
        try {
            this.gp.open(GP390.ConnType.FTDI, this.serial, 19200, this.address);
            this.gp.setLock(false);
            this.gp.setPressureUnit(0);
            this.gp.setLock(true);
            this.setOnline(true);
            this.initSensors();
            LOG.log(Level.INFO, "Connected to {0}", this.fullName);
            this.initError = false;
        }
        catch (DriverException e) {
            if (!this.initError) {
                LOG.log(Level.SEVERE, "Error connecting to {0}: {1}", new Object[]{this.fullName, e});
                this.initError = true;
            }
            try {
                this.gp.close();
            }
            catch (DriverException driverException) {
                // empty catch block
            }
        }
    }

    protected void close() {
        try {
            this.gp.close();
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error disconnecting from {0}: {1}", new Object[]{this.fullName, e});
        }
    }

    protected double readChannel(int hwChan, int type) {
        double value = super.readChannel(hwChan, type);
        if (this.isOnline()) {
            try {
                value = this.gp.readPressure();
            }
            catch (DriverException e) {
                LOG.log(Level.SEVERE, "Error reading pressure: {0}", e);
                this.setOnline(false);
            }
        }
        return value;
    }
}

