/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.vacuum;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.alert.AlertEvent;
import org.lsst.ccs.services.alert.AlertListener;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.common.MonitorTaskControl;
import org.lsst.ccs.subsystem.vacuum.CryoTurboDevice;
import org.lsst.ccs.subsystem.vacuum.HxTurboDevice;
import org.lsst.ccs.subsystem.vacuum.IonPumpDevice;
import org.lsst.ccs.subsystem.vacuum.MpmPlutoDevice;
import org.lsst.ccs.subsystem.vacuum.SwitchDevice;
import org.lsst.ccs.subsystem.vacuum.SwitchInfo;
import org.lsst.ccs.subsystem.vacuum.VacPlutoDevice;
import org.lsst.ccs.subsystem.vacuum.constants.ConditionState;
import org.lsst.ccs.subsystem.vacuum.constants.CryoVacuumState;
import org.lsst.ccs.subsystem.vacuum.constants.DeviceState;
import org.lsst.ccs.subsystem.vacuum.constants.Devices;
import org.lsst.ccs.subsystem.vacuum.constants.HxVacuumState;
import org.lsst.ccs.subsystem.vacuum.constants.LatchState;
import org.lsst.ccs.subsystem.vacuum.constants.PLCState;
import org.lsst.ccs.subsystem.vacuum.constants.SwitchEnable;
import org.lsst.ccs.subsystem.vacuum.constants.SwitchState;
import org.lsst.ccs.subsystem.vacuum.constants.Switches;
import org.lsst.ccs.subsystem.vacuum.constants.VacuumAlert;
import org.lsst.ccs.subsystem.vacuum.data.VacSysState;
import org.lsst.ccs.subsystem.vacuum.data.VacuumException;

public class VacuumMain
extends Subsystem
implements HasLifecycle,
ClearAlertHandler,
AlertListener {
    private static final double PRESS_ATMOS = 759.0;
    private static final double SPEED_CRYO_TURBO_MAX = 60000.0;
    private static final double SPEED_HX_TURBO_MAX = 81000.0;
    private static final int MAX_PRESS_ERRORS = 2;
    private static final int MAX_SPEED_ERRORS = 0;
    private static final int MAX_AIR_ERRORS = 0;
    private static final int DELAY_ION_OFF = 10000;
    private static final int DELAY_VACUUM_BAD = 10000;
    private static final Map<Integer, VacuumAlert> latchAlertMap = new HashMap<Integer, VacuumAlert>();
    private static final Map<String, Integer> revLatchAlertMap;
    private static final List<Integer> cryoIonPumps;
    private static final List<Integer> hxIonPumps;
    private static final List<Integer> utSwitches;
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService propertiesService;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private final List<SwitchDevice> switchDevcs = new ArrayList<SwitchDevice>();
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private MpmPlutoDevice mpmPlutoDevc;
    private Channel cryoVacPressure;
    private Channel cryoTurboPressure;
    private Channel cryoFlinePressure;
    private Channel cryoTurboSpeed;
    private Channel hxVacPressure;
    private Channel hxTurboPressure;
    private Channel hxFlinePressure;
    private Channel hxTurboSpeed;
    private Channel airPressure;
    @ConfigurationParameter(category="Vacuum", isFinal=true)
    private volatile double pressTurboLow;
    @ConfigurationParameter(category="Vacuum", isFinal=true)
    private volatile double pressForelineLow;
    @ConfigurationParameter(category="Vacuum", isFinal=true)
    private volatile double pressDiffLow;
    @ConfigurationParameter(category="Vacuum", isFinal=true)
    private volatile double pressDiffHigh;
    @ConfigurationParameter(category="Vacuum", isFinal=true)
    private volatile double pressIonOff;
    @ConfigurationParameter(category="Vacuum", isFinal=true)
    private volatile double pressIonEnable;
    @ConfigurationParameter(category="Vacuum", isFinal=true)
    private volatile double pressVacuum;
    @ConfigurationParameter(category="Vacuum", isFinal=true)
    private volatile double pressRefrigOk;
    @ConfigurationParameter(category="Vacuum", isFinal=true)
    private volatile double pressCmpAirLow;
    @ConfigurationParameter(category="Vacuum", isFinal=true)
    private volatile double speedFractTurboLow;
    private static final Logger LOG;
    private double speedCryoTurboLow;
    private double speedHxTurboLow;
    private MonitorTaskControl monitorControl;
    private final SwitchDevice[] switchDevices = new SwitchDevice[5];
    private VacPlutoDevice vacPlutoDevc;
    private IonPumpDevice ionPumpDevc;
    private CryoTurboDevice cryoTurboDevc;
    private HxTurboDevice hxTurboDevc;
    private final VacSysState vacState = new VacSysState();
    private boolean running = false;
    private final Map<String, Boolean> activeAlarmMap = new HashMap<String, Boolean>();
    private long cryoIonOverStartTime = 0L;
    private long hxIonOverStartTime = 0L;
    private long vacBadTime = 0L;
    private SensorData cryoFlinePr;
    private SensorData cryoMainPr;
    private SensorData cryoTurboPr;
    private SensorData cryoTurboSp;
    private SensorData hxFlinePr;
    private SensorData hxMainPr;
    private SensorData hxTurboPr;
    private SensorData hxTurboSp;
    private SensorData cmpAirPr;

    public VacuumMain() {
        super("vacuum", AgentInfo.AgentType.WORKER);
        this.getAgentInfo().getAgentProperties().setProperty("org.lsst.ccs.use.full.paths", "true");
    }

    public void build() {
        this.monitorControl = MonitorTaskControl.createNode((Subsystem)this, (String)"MonitorControl");
        AgentPeriodicTask pt = new AgentPeriodicTask("vacuum-state", () -> this.updateVacuumState()).withPeriod(Duration.ofMillis(1000L));
        this.periodicTaskService.scheduleAgentPeriodicTask(pt);
        this.stateService.registerState(CryoVacuumState.class, "Cryo vacuum state", (Object)this);
        this.stateService.updateAgentState(new Enum[]{CryoVacuumState.UNKNOWN});
        this.stateService.registerState(HxVacuumState.class, "HX vacuum state", (Object)this);
        this.stateService.updateAgentState(new Enum[]{HxVacuumState.UNKNOWN});
        for (VacuumAlert alert : VacuumAlert.values()) {
            this.activeAlarmMap.put(alert.getId(), false);
        }
    }

    public void postInit() {
        this.propertiesService.setAgentProperty("vacuumType", VacuumMain.class.getCanonicalName());
        this.alertService.addListener((AlertListener)this);
        Iterator<SwitchDevice> iterator = this.switchDevcs.iterator();
        while (iterator.hasNext()) {
            SwitchDevice device;
            this.switchDevices[device.getSwitchDevice()] = device = iterator.next();
        }
        for (int id = 0; id < 5; ++id) {
            if (this.switchDevices[id] != null) continue;
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)(Devices.getDescription(id) + " device"), (String)"not defined");
        }
        this.vacPlutoDevc = (VacPlutoDevice)this.switchDevices[0];
        this.ionPumpDevc = (IonPumpDevice)this.switchDevices[1];
        this.cryoTurboDevc = (CryoTurboDevice)this.switchDevices[2];
        this.hxTurboDevc = (HxTurboDevice)this.switchDevices[3];
        if (this.mpmPlutoDevc == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"MpmPlutoDevice", (String)"not defined");
        }
        if (this.cryoFlinePressure == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"Cryo foreline pressure channel", (String)"not specified");
        }
        this.cryoFlinePr = new SensorData(this.cryoFlinePressure, 2);
        if (this.cryoVacPressure == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"Cryo vacuum pressure channel", (String)"not specified");
        }
        this.cryoMainPr = new SensorData(this.cryoVacPressure, 2);
        this.ionPumpDevc.setCryoPressureChannel(this.cryoVacPressure);
        if (this.cryoTurboPressure == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"Cryo turbo pump pressure channel", (String)"not specified");
        }
        this.cryoTurboPr = new SensorData(this.cryoTurboPressure, 2);
        if (this.cryoTurboSpeed == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"Cryo turbo pump speed channel", (String)"not specified");
        }
        this.cryoTurboSp = new SensorData(this.cryoTurboSpeed, 0);
        if (this.hxFlinePressure == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"HX foreline pressure channel", (String)"not specified");
        }
        this.hxFlinePr = new SensorData(this.hxFlinePressure, 2);
        if (this.hxVacPressure == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"HX vacuum pressure channel", (String)"not specified");
        }
        this.hxMainPr = new SensorData(this.hxVacPressure, 2);
        this.ionPumpDevc.setHxPressureChannel(this.hxVacPressure);
        if (this.hxTurboPressure == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"HX turbo pump pressure channel", (String)"not specified");
        }
        this.hxTurboPr = new SensorData(this.hxTurboPressure, 2);
        if (this.hxTurboSpeed == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"HX turbo pump speed channel", (String)"not specified");
        }
        this.hxTurboSp = new SensorData(this.hxTurboSpeed, 0);
        if (this.airPressure == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"Compressed air pressure channel", (String)"not specified");
        }
        this.cmpAirPr = new SensorData(this.airPressure, 0);
        this.speedCryoTurboLow = this.speedFractTurboLow * 60000.0;
        this.speedHxTurboLow = this.speedFractTurboLow * 81000.0;
    }

    public void postStart() {
        LOG.info("Vacuum subsystem started");
        this.running = true;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the vacuum system state", level=0)
    public VacSysState getVacuumState() {
        this.vacState.setTickMillis(this.monitorControl.getPublishPeriod());
        return this.vacState;
    }

    @Command(type=Command.CommandType.QUERY, description="Get switch names", level=0)
    public List<String> getSwitchNames() throws VacuumException {
        return Switches.getNames();
    }

    @Command(type=Command.CommandType.ACTION, description="Turn on/off a named switch")
    public void setSwitchOn(@Argument(description="The switch name") String name, @Argument(description="Whether to turn on") boolean on) throws VacuumException {
        try {
            this.setSwitch(Switches.getId(name), on);
        }
        finally {
            this.publishState();
        }
    }

    private void setSwitch(int sw, boolean on) throws VacuumException {
        SwitchState state = this.vacState.getSwitchState(sw);
        if (state == SwitchState.OFFLINE) {
            return;
        }
        SwitchEnable enable = this.vacState.getSwitchEnable(sw);
        if (on && enable != SwitchEnable.ON) {
            return;
        }
        try {
            this.switchDevices[Switches.getDevice(sw)].setSwitch(SwitchInfo.getSwitch(sw), on);
        }
        catch (DriverException e) {
            throw new VacuumException("Error setting switch for " + Devices.getDescription(Switches.getDevice(sw)) + " device: " + (Object)((Object)e));
        }
    }

    private Boolean isSwitchOn(int sw) {
        return this.switchDevices[Switches.getDevice(sw)].isSwitchOn(SwitchInfo.getSwitch(sw));
    }

    @Command(type=Command.CommandType.ACTION, description="Clear a condition")
    public void clearLatch(@Argument(description="The condition number") int cond) throws VacuumException {
        try {
            this.vacPlutoDevc.clearLatch(cond);
        }
        finally {
            this.publishState();
        }
    }

    private void updateVacuumState() {
        if (!this.running) {
            return;
        }
        boolean changed = this.monitorControl.hasPeriodChanged();
        changed |= this.updatePlcState();
        changed |= this.updateLatchState();
        changed |= this.updateCondState();
        this.readSensors();
        changed |= this.updateSwitchState();
        changed |= this.updateCryoState();
        this.checkRefrigVacuum();
        if (changed |= this.updateHxState()) {
            this.publishState();
        }
    }

    private boolean updatePlcState() {
        boolean changed = false;
        Boolean plcActive = this.vacPlutoDevc.isPLCActive();
        if (plcActive == null) {
            if (this.vacState.getPlcState() != PLCState.OFFLINE) {
                this.raiseAlarm(VacuumAlert.VACUUM_PLC_NOT_ALIVE, "Vacuum PLC is offline");
                this.vacState.setPlcState(PLCState.OFFLINE);
                changed = true;
            }
        } else if (!plcActive.booleanValue()) {
            if (this.vacState.getPlcState() != PLCState.DEAD) {
                this.raiseAlarm(VacuumAlert.VACUUM_PLC_NOT_ALIVE, "Vacuum PLC has died");
                this.vacState.setPlcState(PLCState.DEAD);
                changed = true;
            }
        } else if (this.vacState.getPlcState() != PLCState.ALIVE) {
            this.lowerAlarm(VacuumAlert.VACUUM_PLC_NOT_ALIVE, "Vacuum PLC is alive");
            this.vacState.setPlcState(PLCState.ALIVE);
            changed = true;
        }
        return changed;
    }

    private boolean updateLatchState() {
        boolean changed = false;
        for (int cond = 0; cond < 8; ++cond) {
            LatchState oldState;
            Boolean active = this.vacPlutoDevc.isLatchActive(cond);
            Boolean latched = this.vacPlutoDevc.isLatchLatched(cond);
            LatchState state = active == null || latched == null ? LatchState.OFFLINE : (latched != false ? LatchState.LATCHED : (active != false ? LatchState.ACTIVE : LatchState.CLEAR));
            if (state == (oldState = this.vacState.getLatch(cond))) continue;
            this.vacState.setLatch(cond, state);
            VacuumAlert alert = latchAlertMap.get(cond);
            if (state == LatchState.ACTIVE) {
                this.raiseAlarm(alert, "Vacuum PLC error condition set");
            } else if (state != LatchState.OFFLINE && oldState != LatchState.OFFLINE) {
                if (state == LatchState.LATCHED && oldState == LatchState.CLEAR) {
                    this.raiseAlarm(alert, "Vacuum PLC error condition set");
                }
                if (state == LatchState.LATCHED || oldState == LatchState.ACTIVE) {
                    this.lowerAlarm(alert, "Vacuum PLC error condition cleared");
                }
            }
            changed = true;
        }
        return changed;
    }

    private boolean updateCondState() {
        boolean changed = false;
        for (int cond = 0; cond < 10; ++cond) {
            ConditionState state;
            Boolean active = this.vacPlutoDevc.isConditionActive(cond);
            ConditionState conditionState = active == null ? ConditionState.OFF : (state = active != false ? ConditionState.YES : ConditionState.NO);
            if (state == this.vacState.getCondition(cond)) continue;
            this.vacState.setCondition(cond, state);
            changed = true;
        }
        return changed;
    }

    private void readSensors() {
        this.readSensor(this.cryoFlinePr);
        this.readSensor(this.cryoMainPr);
        this.readSensor(this.cryoTurboPr);
        this.readSensor(this.cryoTurboSp);
        this.readSensor(this.hxFlinePr);
        this.readSensor(this.hxMainPr);
        this.readSensor(this.hxTurboPr);
        this.readSensor(this.hxTurboSp);
        this.readSensor(this.cmpAirPr);
    }

    private void readSensor(SensorData data) {
        data.value = data.channel.getValue();
        if (!Double.isNaN(data.value)) {
            data.goodValue = data.value;
            data.numErrors = 0;
        } else if (data.numErrors++ < data.maxErrors) {
            data.value = data.goodValue;
        }
    }

    private boolean updateSwitchState() {
        boolean changed = false;
        changed |= this.updateCryoGateValve();
        changed |= this.updateCryoTurboPump();
        changed |= this.updateCryoIonPumps();
        changed |= this.updateHxGateValve();
        changed |= this.updateHxTurboPump();
        changed |= this.updateHxIonPumps();
        return changed |= this.updateUtSwitches();
    }

    private boolean updateCryoGateValve() {
        boolean cryoTurbAvail;
        boolean enable = false;
        boolean bl = cryoTurbAvail = !Double.isNaN(this.cryoMainPr.value) && !Double.isNaN(this.cryoTurboPr.value) && !Double.isNaN(this.cryoTurboSp.value);
        if (cryoTurbAvail) {
            double prDiff = Math.abs(this.cryoTurboPr.value - this.cryoMainPr.value);
            enable = prDiff <= this.pressDiffHigh && this.cryoTurboSp.value <= this.speedCryoTurboLow || prDiff <= this.pressDiffLow && this.cryoTurboSp.value > this.speedCryoTurboLow;
        }
        boolean enable2 = cryoTurbAvail && this.cmpAirPr.value > this.pressCmpAirLow && (this.cryoFlinePr.value < this.pressForelineLow || this.cryoTurboSp.value <= this.speedCryoTurboLow);
        return this.updateSwitch(7, enable &= enable2, !enable2, null, VacuumAlert.CRYO_GATE_CLOSED);
    }

    private boolean updateCryoTurboPump() {
        boolean enable = false;
        if (!(Double.isNaN(this.cryoTurboPr.value) || Double.isNaN(this.cryoFlinePr.value) || Double.isNaN(this.cryoTurboSp.value))) {
            enable = this.cryoTurboPr.value < this.pressTurboLow && (this.cryoFlinePr.value < this.pressForelineLow || this.cryoTurboSp.value < this.speedCryoTurboLow);
        }
        return this.updateSwitch(0, enable, !enable, this.cryoTurboDevc.getDeviceState(), VacuumAlert.CRYO_TURBO_PUMP_STOPPED);
    }

    private boolean updateCryoIonPumps() {
        boolean changed = false;
        boolean enable = false;
        boolean turnOff = false;
        if (!Double.isNaN(this.cryoMainPr.value)) {
            boolean bl = enable = this.cryoMainPr.value < this.pressIonEnable;
            if (this.cryoMainPr.value >= this.pressIonOff) {
                if (this.cryoIonOverStartTime == 0L) {
                    this.cryoIonOverStartTime = System.currentTimeMillis();
                } else {
                    turnOff = System.currentTimeMillis() - this.cryoIonOverStartTime >= 10000L;
                }
            } else {
                this.cryoIonOverStartTime = 0L;
            }
        } else {
            turnOff = true;
        }
        for (int sw : cryoIonPumps) {
            changed |= this.updateSwitch(sw, enable, turnOff, null, VacuumAlert.CRYO_ION_PUMPS_STOPPED);
        }
        return changed;
    }

    private boolean updateHxGateValve() {
        boolean hxTurbAvail;
        boolean enable = false;
        boolean bl = hxTurbAvail = !Double.isNaN(this.hxMainPr.value) && !Double.isNaN(this.hxTurboPr.value) && !Double.isNaN(this.hxTurboSp.value);
        if (hxTurbAvail) {
            double prDiff = Math.abs(this.hxTurboPr.value - this.hxMainPr.value);
            enable = prDiff <= this.pressDiffHigh && this.hxTurboSp.value <= this.speedHxTurboLow || prDiff <= this.pressDiffLow && this.hxTurboSp.value > this.speedHxTurboLow;
        }
        boolean enable2 = hxTurbAvail && this.cmpAirPr.value > this.pressCmpAirLow && (this.hxFlinePr.value < this.pressForelineLow || this.hxTurboSp.value <= this.speedHxTurboLow);
        return this.updateSwitch(12, enable &= enable2, !enable2, null, VacuumAlert.HX_GATE_CLOSED);
    }

    private boolean updateHxTurboPump() {
        boolean enable = false;
        if (!(Double.isNaN(this.hxTurboPr.value) || Double.isNaN(this.hxFlinePr.value) || Double.isNaN(this.hxTurboSp.value))) {
            enable = this.hxTurboPr.value < this.pressTurboLow && (this.hxFlinePr.value < this.pressForelineLow || this.hxTurboSp.value < this.speedHxTurboLow);
        }
        return this.updateSwitch(9, enable, !enable, this.hxTurboDevc.getDeviceState(), VacuumAlert.HX_TURBO_PUMP_STOPPED);
    }

    private boolean updateHxIonPumps() {
        boolean changed = false;
        boolean enable = false;
        boolean turnOff = false;
        if (!Double.isNaN(this.hxMainPr.value)) {
            boolean bl = enable = this.hxMainPr.value < this.pressIonEnable;
            if (this.hxMainPr.value >= this.pressIonOff) {
                if (this.hxIonOverStartTime == 0L) {
                    this.hxIonOverStartTime = System.currentTimeMillis();
                } else {
                    turnOff = System.currentTimeMillis() - this.hxIonOverStartTime >= 10000L;
                }
            } else {
                this.hxIonOverStartTime = 0L;
            }
        } else {
            turnOff = true;
        }
        for (int sw : hxIonPumps) {
            changed |= this.updateSwitch(sw, enable, turnOff, null, VacuumAlert.HX_ION_PUMPS_STOPPED);
        }
        return changed;
    }

    private boolean updateUtSwitches() {
        boolean changed = false;
        for (int sw : utSwitches) {
            changed |= this.updateSwitch(sw, true, false, null, null);
        }
        return changed;
    }

    private boolean updateSwitch(int sw, boolean enable, boolean turnOff, DeviceState devState, VacuumAlert alert) {
        SwitchEnable enabled;
        Boolean isOn;
        boolean changed = false;
        SwitchState oldState = this.vacState.getSwitchState(sw);
        if (turnOff && oldState == SwitchState.ON) {
            try {
                this.setSwitch(sw, false);
                this.raiseAlarm(alert, "Switch was forced to open");
            }
            catch (VacuumException e) {
                LOG.log(Level.SEVERE, "Error setting switch: {0}", e);
            }
        }
        SwitchState state = (isOn = this.isSwitchOn(sw)) != null ? (isOn.booleanValue() ? SwitchState.ON : SwitchState.OFF) : SwitchState.OFFLINE;
        SwitchEnable switchEnable = enabled = enable ? SwitchEnable.ON : SwitchEnable.OFF;
        if (state != oldState || enabled != this.vacState.getSwitchEnable(sw)) {
            this.vacState.setSwitchState(sw, state);
            this.vacState.setSwitchEnable(sw, enabled);
            changed = true;
            if (enable && alert != null && this.isAlarmRaised(alert)) {
                this.lowerAlarm(alert, "Switch has become re-enabled");
            }
        }
        if (devState != this.vacState.getDeviceState(sw)) {
            this.vacState.setDeviceState(sw, devState);
            changed = true;
        }
        return changed;
    }

    private void checkRefrigVacuum() {
        boolean haveAlarm = this.isAlarmRaised(VacuumAlert.REFRIG_NOT_PERMITTED);
        if (this.cryoMainPr.value < this.pressRefrigOk && this.hxMainPr.value < this.pressRefrigOk) {
            if (haveAlarm) {
                this.lowerAlarm(VacuumAlert.REFRIG_NOT_PERMITTED, "Cryo & HX vacuums are good (< " + this.pressRefrigOk + ")");
                this.mpmPlutoDevc.setSwitch(0, false);
                this.mpmPlutoDevc.setSwitch(1, false);
            }
            this.vacBadTime = 0L;
        } else {
            long time = System.currentTimeMillis();
            if (this.vacBadTime == 0L) {
                this.vacBadTime = time;
            } else if (time - this.vacBadTime >= 10000L) {
                if (!haveAlarm) {
                    this.raiseAlarm(VacuumAlert.REFRIG_NOT_PERMITTED, "Cryo or HX vacuum is bad (>= " + this.pressRefrigOk + ")");
                }
                this.mpmPlutoDevc.setSwitch(0, true);
                this.mpmPlutoDevc.setSwitch(1, true);
            }
        }
    }

    private boolean updateCryoState() {
        boolean changed = false;
        CryoVacuumState cvState = Double.isNaN(this.cryoMainPr.value) ? CryoVacuumState.UNKNOWN : (this.cryoMainPr.value <= this.pressVacuum ? CryoVacuumState.VACUUM : (this.vacState.getSwitchState(1) == SwitchState.ON ? CryoVacuumState.ION_ON : (this.vacState.getSwitchEnable(1) == SwitchEnable.ON ? CryoVacuumState.ION_OFF : (this.vacState.getSwitchState(0) == SwitchState.ON ? CryoVacuumState.TURBO_ON : (this.vacState.getSwitchEnable(0) == SwitchEnable.ON ? CryoVacuumState.TURBO_OFF : (this.cryoMainPr.value < 759.0 ? CryoVacuumState.FORELINE : CryoVacuumState.OFF))))));
        if (cvState != this.vacState.getCryoVacuumState()) {
            this.vacState.setCryoVacuumState(cvState);
            this.stateService.updateAgentState(new Enum[]{cvState});
            changed = true;
        }
        return changed;
    }

    private boolean updateHxState() {
        boolean changed = false;
        HxVacuumState hvState = Double.isNaN(this.hxMainPr.value) ? HxVacuumState.UNKNOWN : (this.hxMainPr.value <= this.pressVacuum ? HxVacuumState.VACUUM : (this.vacState.getSwitchState(10) == SwitchState.ON ? HxVacuumState.ION_ON : (this.vacState.getSwitchEnable(10) == SwitchEnable.ON ? HxVacuumState.ION_OFF : (this.vacState.getSwitchState(9) == SwitchState.ON ? HxVacuumState.TURBO_ON : (this.vacState.getSwitchEnable(9) == SwitchEnable.ON ? HxVacuumState.TURBO_OFF : (this.hxMainPr.value < 759.0 ? HxVacuumState.FORELINE : HxVacuumState.OFF))))));
        if (hvState != this.vacState.getHxVacuumState()) {
            this.vacState.setHxVacuumState(hvState);
            this.stateService.updateAgentState(new Enum[]{hvState});
            changed = true;
        }
        return changed;
    }

    private void raiseAlarm(VacuumAlert alert, String cond) {
        this.alertService.raiseAlert(alert.getAlert(), AlertState.ALARM, cond);
        this.activeAlarmMap.put(alert.getId(), true);
    }

    private void lowerAlarm(VacuumAlert alert, String cond) {
        this.alertService.raiseAlert(alert.getAlert(), AlertState.NOMINAL, cond);
        this.activeAlarmMap.put(alert.getId(), false);
    }

    private boolean isAlarmRaised(VacuumAlert alert) {
        return this.activeAlarmMap.get(alert.getId()) == Boolean.TRUE;
    }

    public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
        Boolean active = this.activeAlarmMap.get(alert.getAlertId());
        return active == null ? ClearAlertHandler.ClearAlertCode.UNKNOWN_ALERT : (active != false ? ClearAlertHandler.ClearAlertCode.DONT_CLEAR_ALERT : ClearAlertHandler.ClearAlertCode.CLEAR_ALERT);
    }

    public void onAlert(AlertEvent event) {
        if (event.getType() != AlertEvent.AlertEventType.ALERT_CLEARED) {
            return;
        }
        for (String id : event.getClearedIds()) {
            Integer cond = revLatchAlertMap.get(id);
            if (cond == null) continue;
            try {
                this.clearLatch(cond);
            }
            catch (VacuumException e) {
                LOG.log(Level.SEVERE, "Error clearing latched PLC condition ({0}): {1}", new Object[]{cond, e});
            }
        }
    }

    private void publishState() {
        this.publishSubsystemDataOnStatusBus(new KeyValueData("VacuumState", (Serializable)this.getVacuumState()));
    }

    static {
        latchAlertMap.put(0, VacuumAlert.CRYO_VACUUM_BAD);
        latchAlertMap.put(1, VacuumAlert.CRYO_GATE_FORCED_SHUT);
        latchAlertMap.put(2, VacuumAlert.CRYO_GATE_CANNOT_OPEN);
        latchAlertMap.put(3, VacuumAlert.CRYO_TURBO_PUMP_BAD);
        latchAlertMap.put(4, VacuumAlert.HX_VACUUM_BAD);
        latchAlertMap.put(5, VacuumAlert.HX_GATE_FORCED_SHUT);
        latchAlertMap.put(6, VacuumAlert.HX_GATE_CANNOT_OPEN);
        latchAlertMap.put(7, VacuumAlert.HX_TURBO_PUMP_BAD);
        revLatchAlertMap = new HashMap<String, Integer>();
        for (int cond : latchAlertMap.keySet()) {
            revLatchAlertMap.put(latchAlertMap.get(cond).getId(), cond);
        }
        cryoIonPumps = new ArrayList<Integer>();
        cryoIonPumps.add(1);
        cryoIonPumps.add(2);
        cryoIonPumps.add(3);
        cryoIonPumps.add(4);
        cryoIonPumps.add(5);
        cryoIonPumps.add(6);
        hxIonPumps = new ArrayList<Integer>();
        hxIonPumps.add(10);
        hxIonPumps.add(11);
        utSwitches = new ArrayList<Integer>();
        utSwitches.add(15);
        utSwitches.add(14);
        utSwitches.add(16);
        utSwitches.add(17);
        utSwitches.add(18);
        utSwitches.add(8);
        utSwitches.add(13);
        LOG = Logger.getLogger(VacuumMain.class.getName());
    }

    static class SensorData {
        Channel channel;
        int maxErrors;
        int numErrors = 0;
        double value = 0.0;
        double goodValue = Double.NaN;

        private SensorData(Channel channel, int maxErrors) {
            this.channel = channel;
            this.maxErrors = maxErrors;
        }
    }
}

