/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.subsystems.fcs.AutochangerOnlineClamp;
import org.lsst.ccs.subsystems.fcs.common.EPOSControllerForOnlineClamp;
import org.lsst.ccs.subsystems.fcs.simulation.SimuAutochangerPlutoGateway;
import org.lsst.ccs.subsystems.fcs.simulation.SimuEPOSController;

public class SimuAutochangerOnlineClampController
extends SimuEPOSController
implements EPOSControllerForOnlineClamp {
    @ConfigurationParameter(isFinal=true, category="controller")
    private volatile String onlineClampName;
    @LookupField(strategy=LookupField.Strategy.SIBLINGS)
    private SimuAutochangerPlutoGateway plutoGateway;
    @LookupPath
    private String nodePath;
    private AutochangerOnlineClamp onlineClamp;
    private boolean brakeActivatedPub;
    private boolean homingDone = true;

    @Override
    public boolean isBrakeActivatedPub() {
        return this.brakeActivatedPub;
    }

    @Override
    public void setBrakeActivatedPub(boolean brakeActivatedToPublish) {
        this.brakeActivatedPub = brakeActivatedToPublish;
    }

    public void init() {
        if (this.plutoGateway == null) {
            throw new RuntimeException("Invalid initialization. An instance of SimuAutochangerPlutoGateway should have been picked up from the Lookup tree from the siblinds of this node: " + this.nodePath);
        }
        ComponentLookup lookup = this.subs.getComponentLookup();
        this.onlineClamp = (AutochangerOnlineClamp)lookup.getComponentByPath(this.onlineClampName);
    }

    @Override
    public void writeCurrent(int current) {
        this.targetCurrent = current;
        this.actualCurrent = current;
        if (this.targetCurrent == this.onlineClamp.getFinalCurrentToClose()) {
            this.plutoGateway.simulateAutochangerOnlineClampIsClosed(this.onlineClamp);
        } else if (this.targetCurrent == this.onlineClamp.getCurrentToOpen()) {
            this.plutoGateway.simulateAutochangerOnlineClampIsOpened(this.onlineClamp);
        } else if (this.targetCurrent == this.onlineClamp.getCurrentToClamp()) {
            this.plutoGateway.simulateAutochangerOnlineClampIsLocked(this.onlineClamp);
        }
    }

    @Override
    public void writeTargetPosition(int positionToReach) {
        this.targetPosition = positionToReach;
        this.position = positionToReach;
        this.onlineClamp.updatePosition();
        if (this.targetPosition == this.onlineClamp.getTargetPositionToOpen()) {
            this.plutoGateway.simulateAutochangerOnlineClampIsOpened(this.onlineClamp);
        } else if (this.targetPosition == this.onlineClamp.getTargetPositionToClose()) {
            this.plutoGateway.simulateAutochangerOnlineClampIsClosed(this.onlineClamp);
        }
    }

    @Override
    public void activateBrakeAndDisable() {
        this.brakeActivatedPub = true;
    }

    @Override
    public void enableAndReleaseBrake() {
        this.brakeActivatedPub = false;
    }

    @Override
    public void doReleaseBrake() {
        this.brakeActivatedPub = false;
    }

    @Override
    public boolean isBrakeActivated() {
        return this.brakeActivatedPub;
    }

    @Override
    public void activateBrake() {
        this.brakeActivatedPub = true;
    }

    @Override
    public void homing() {
    }

    @Override
    public boolean isHomingDone() {
        return this.homingDone;
    }
}

