import org.lsst.ccs.description.groovy.CCSBuilder;
import org.lsst.ccs.subsystem.motorplatform.bot.BOTMain;
import org.lsst.ccs.subsystem.motorplatform.bot.Ensemble;
import org.lsst.ccs.subsystem.motorplatform.bot.Axis;

CCSBuilder builder = ["bot-motorplatform"]

builder.
    main(BOTMain) {
        // Subsystem main. Takes commands from the CCS bus and
        // delegates operations to the Controller.
        
        Controller(Ensemble) {
            // The Controller sends commands to the motor controller,
            // if any, and publishes status reports.
            
            // Axis names, indexes and units must match those configured in the
            // motor controller.
            XAxis(Axis, axisName:"X", index:0, units:"mm")
            YAxis(Axis, axisName:"Y", index:1, units: "mm")
            // The THETA axis is used during metrology to move a large optical
            // flat into one of four positions. Metrology scripts don't
            // use the subsystem directly to move THETA but use controller ASCII
            // commands issued via the subsystem's hardware chat facility.
            //ThetaAxis(Axis, axisName:"THETA", index:2, units:"deg")
        }
    
    }
