/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.plc;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.lsst.ccs.subsystem.shutter.common.PLCError;
import org.lsst.ccs.subsystem.shutter.plc.MsgToCCS;

public class Error
extends MsgToCCS {
    private final Set<PLCError> errors;

    public Error(int sequence, Set<PLCError> errors) {
        super(sequence);
        this.errors = PLCError.copyOf(errors);
    }

    public Error(ByteBuffer data) {
        super(data);
        this.errors = PLCError.decodeMask(data.getInt());
    }

    @Override
    public void encode(ByteBuffer data) {
        super.encode(data);
        data.putInt(PLCError.encodeMask(this.errors));
    }

    public Set<PLCError> getErrors() {
        return Collections.unmodifiableSet(this.errors);
    }

    @Override
    public String toString() {
        StringBuilder bld = new StringBuilder("Error{");
        bld.append(super.toString());
        bld.append(" errors={");
        ArrayList<String> lerr = new ArrayList<String>(PLCError.values().length);
        for (PLCError err : PLCError.values()) {
            if (!this.errors.contains((Object)err)) continue;
            lerr.add(err.toString());
        }
        bld.append(String.join((CharSequence)", ", lerr));
        bld.append("}");
        bld.append("}");
        return bld.toString();
    }
}

