/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.testbench;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenThermometer;
import org.lsst.ccs.subsystems.fcs.testbench.CanOpenLED;

public class APCTestBenchMain {
    private final BridgeToHardware bridge;
    private final CanOpenThermometer thermometer;
    private final CanOpenLED led;
    private final CanOpenLED fakeLed;
    private final CanOpenThermometer fakeSensor;
    public double temperature;

    public APCTestBenchMain(BridgeToHardware bridge, CanOpenThermometer thermometer, CanOpenLED led, CanOpenLED fakeLed, CanOpenThermometer fakeSensor) {
        this.bridge = bridge;
        this.thermometer = thermometer;
        this.led = led;
        this.fakeLed = fakeLed;
        this.fakeSensor = fakeSensor;
    }

    public int getReturnValue(String responseLine, int inputNB) {
        if (inputNB < 1 || inputNB > 8) {
            throw new IllegalArgumentException();
        }
        String[] words = responseLine.split(",");
        int value = Integer.parseInt(words[inputNB], 16);
        FCSCst.FCSLOG.debug((Object)("Value in decimal:" + words[inputNB]));
        return value;
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Read temperature with readSDO commands.")
    public double readTemperature() {
        return this.thermometer.readTemperature();
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Read temperature from PDO.")
    public double readTemperatureFromPDO() {
        this.bridge.updatePDOData();
        return this.thermometer.readTemperatureFromPDO();
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Turn ON the Led.")
    public String turnOnLED() {
        return this.led.turnON();
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Turn OFF the Led.")
    public String turnOffLED() {
        return this.led.turnOFF();
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Turn ON the fake Led.")
    public String turnOnFakeLED() {
        return this.fakeLed.turnON();
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Turn OFF the fake Led.")
    public String turnOffFakeLED() {
        return this.fakeLed.turnOFF();
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Read fake Sensor.")
    public double readFakeSensor() {
        return this.fakeSensor.readTemperatureFromPDO();
    }
}

