/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByPlutoGateway;
import org.lsst.ccs.subsystems.fcs.common.PlutoGatewayInterface;
import org.lsst.ccs.subsystems.fcs.common.SensorPluggedOnDevice;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDevice;

public abstract class PlutoGateway
extends CanOpenDevice
implements PlutoGatewayInterface {
    protected int[] readValues;
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected Map<String, SensorPluggedOnDevice> sensorsMap = new HashMap<String, SensorPluggedOnDevice>();

    public PlutoGateway(int nodeID, String serialNB) {
        super(nodeID, serialNB);
        this.readValues = new int[16];
    }

    @Override
    public void build() {
        this.dataProviderDictionaryService.registerClass(StatusDataPublishedByPlutoGateway.class, this.name);
    }

    public void init() {
        FCSCst.FCSLOG.fine((Object)(this.name + " =====> initialization of my sensors map"));
        StringBuilder sb = new StringBuilder();
        Iterator<SensorPluggedOnDevice> it = this.sensorsMap.values().iterator();
        while (it.hasNext()) {
            SensorPluggedOnDevice sensor = it.next();
            if (sensor.getDeviceName().equals(this.name)) {
                sb.append(sensor.getName());
                sb.append(" ====> IS MY SENSOR ");
                sb.append(sensor.toString());
                sb.append("#\n");
                continue;
            }
            it.remove();
        }
        FCSCst.FCSLOG.fine((Object)sb.toString());
    }

    @Override
    public void updateValues() {
        this.readValues = this.readNewValues();
        FCSCst.FCSLOG.info((Object)(this.name + " updating my sensors values."));
        this.sensorsMap.values().stream().forEach(sensor -> sensor.updateValue(this.readValues[sensor.getByteNumero()]));
        this.publishData();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Return the string representation of PlutoGateway")
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        for (int i = 0; i < this.readValues.length; ++i) {
            sb.append("/byte");
            sb.append(i);
            sb.append('=');
            sb.append(String.valueOf(this.readValues[i]));
        }
        return sb.toString();
    }

    public StatusDataPublishedByPlutoGateway createStatusDataPublishedByPlutoGatewayModule() {
        return new StatusDataPublishedByPlutoGateway(this.isBooted(), this.isInitialized(), this.readValues);
    }

    @Override
    public void publishData() {
        this.subs.publishSubsystemDataOnStatusBus(new KeyValueData(this.getName(), (Serializable)this.createStatusDataPublishedByPlutoGatewayModule()));
    }
}

