/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bootstrap;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

class ResourceDirectory {
    private File resourceDirectoryFile = null;
    private final String fileSeparator = System.getProperty("file.separator");
    private boolean isDistributionDir = false;

    ResourceDirectory(String resourceDirectoryPath, boolean isDistributionDir) {
        this.resourceDirectoryFile = new File(resourceDirectoryPath);
        this.isDistributionDir = isDistributionDir;
    }

    boolean isDistributionDir() {
        return this.isDistributionDir;
    }

    String getResouceDirectoryPath() {
        String resourceDirPath = this.resourceDirectoryFile.getAbsolutePath();
        if (!resourceDirPath.endsWith(this.fileSeparator)) {
            resourceDirPath = resourceDirPath + this.fileSeparator;
        }
        return resourceDirPath;
    }

    Set<String> findMatchingResources(Pattern pattern) {
        HashSet<String> result = new HashSet<String>();
        for (File f : this.resourceDirectoryFile.listFiles((dir, name) -> pattern.matcher(name).matches())) {
            result.add(f.getName());
        }
        return result;
    }
}

