/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.integrationgantrygui.icon;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public class ArrowUp
implements Icon {
    private static final int SIZE = 24;
    private int width;
    private int height;
    private BufferedImage image;

    public ArrowUp() {
        this(24, 24);
    }

    public ArrowUp(int width, int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.image == null) {
            this.image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
            double coef = Math.min((double)this.width / 24.0, (double)this.height / 24.0);
            Graphics2D g2d = this.image.createGraphics();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.scale(coef, coef);
            ArrowUp.paint(g2d);
            g2d.dispose();
        }
        g.drawImage(this.image, x, y, null);
    }

    private static void paint(Graphics2D g) {
        Shape shape = new Line2D.Float(12.0f, 19.0f, 12.0f, 5.0f);
        g.setPaint(Color.BLACK);
        g.setStroke(new BasicStroke(2.0f, 1, 1, 4.0f));
        g.draw(shape);
        shape = new GeneralPath();
        ((GeneralPath)shape).moveTo(5.0, 12.0);
        ((GeneralPath)shape).lineTo(12.0, 5.0);
        ((GeneralPath)shape).lineTo(19.0, 12.0);
        g.draw(shape);
    }
}

