/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.integrationgantrygui;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.LookupOp;
import java.awt.image.ShortLookupTable;
import java.awt.image.WritableRaster;
import org.lsst.ccs.integrationgantrygui.ScalableImageProvider;
import org.lsst.ccs.integrationgantrygui.ScalingUtils;
import org.lsst.ccs.integrationgantrygui.Timed;

class LookupScalableImageProvider
extends ScalableImageProvider<short[]> {
    private final BufferedImage rawImage;

    LookupScalableImageProvider(int bitpix, int bZero, int bScale, int[] counts, WritableRaster rawRaster) {
        super(bitpix, bZero, bScale, new ScalingUtils.ShortScalingUtils(counts), rawRaster);
        ComponentColorModel cm = new ComponentColorModel(ColorSpace.getInstance(1003), false, false, 1, rawRaster.getTransferType());
        this.rawImage = new BufferedImage(cm, rawRaster, false, null);
    }

    @Override
    BufferedImage createScaledImage(ScalableImageProvider.Scaling scaling) {
        return Timed.execute(() -> {
            LookupOp op = new LookupOp(this.createLookupTable(scaling), null);
            return op.filter(this.rawImage, null);
        }, "Scaling took %dms", new Object[0]);
    }

    private ShortLookupTable createLookupTable(ScalableImageProvider.Scaling scaling) {
        ScalingUtils scalingUtils = this.getScalingUtils();
        int min = scalingUtils.getMin();
        short[] data = (short[])scalingUtils.buildArray(min, scaling);
        return new ShortLookupTable(min, data);
    }
}

