/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.integrationgantrygui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.lsst.ccs.integrationgantrygui.ImageComponent;

public class CameraPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JPanel InfoPanel;
    private JTextField h1TextField;
    private JTextField h2TextField;
    private JTextField hGapTextField;
    private JLabel horizLabel;
    private ImageComponent imageComponent;
    private JTextField v1TextField;
    private JTextField v2TextField;
    private JTextField vGapTextField;
    private JLabel vertLabel;

    public CameraPanel() {
        this.initComponents();
        this.imageComponent.setHorizontalColor(this.horizLabel.getForeground());
        this.imageComponent.setVerticalColor(this.vertLabel.getForeground());
    }

    private void initComponents() {
        this.InfoPanel = new JPanel();
        this.horizLabel = new JLabel();
        this.h1TextField = new JTextField();
        this.h2TextField = new JTextField();
        this.hGapTextField = new JTextField();
        this.vertLabel = new JLabel();
        this.v1TextField = new JTextField();
        this.v2TextField = new JTextField();
        this.vGapTextField = new JTextField();
        this.imageComponent = new ImageComponent();
        this.setLayout(new BorderLayout());
        this.horizLabel.setForeground(new Color(0, 51, 255));
        this.horizLabel.setText("Horiz:");
        this.InfoPanel.add(this.horizLabel);
        this.h1TextField.setEditable(false);
        this.h1TextField.setColumns(4);
        this.InfoPanel.add(this.h1TextField);
        this.h2TextField.setEditable(false);
        this.h2TextField.setColumns(4);
        this.InfoPanel.add(this.h2TextField);
        this.hGapTextField.setEditable(false);
        this.hGapTextField.setColumns(6);
        this.InfoPanel.add(this.hGapTextField);
        this.vertLabel.setForeground(new Color(0, 204, 0));
        this.vertLabel.setText("Vert:");
        this.InfoPanel.add(this.vertLabel);
        this.v1TextField.setEditable(false);
        this.v1TextField.setColumns(4);
        this.InfoPanel.add(this.v1TextField);
        this.v2TextField.setEditable(false);
        this.v2TextField.setColumns(4);
        this.InfoPanel.add(this.v2TextField);
        this.vGapTextField.setEditable(false);
        this.vGapTextField.setColumns(6);
        this.InfoPanel.add(this.vGapTextField);
        this.add((Component)this.InfoPanel, "North");
        this.add((Component)this.imageComponent, "Center");
    }

    void setImage(BufferedImage scaledImage) {
        this.imageComponent.setImage(scaledImage);
    }

    void setLabels(double h1, double h2, double v1, double v2) {
        this.h1TextField.setText(CameraPanel.formatNumber(h1));
        this.h2TextField.setText(CameraPanel.formatNumber(h2));
        this.v1TextField.setText(CameraPanel.formatNumber(v1));
        this.v2TextField.setText(CameraPanel.formatNumber(v2));
        this.hGapTextField.setText(CameraPanel.formatNumber((h2 - h1) * 25.0, "\u03bcm"));
        this.vGapTextField.setText(CameraPanel.formatNumber((v2 - v1) * 25.0, "\u03bcm"));
        this.imageComponent.setEdges(h1, h2, v1, v2);
    }

    private static String formatNumber(double d, String units) {
        return Double.isNaN(d) ? "" : String.format("%4.4g%s", d, units);
    }

    private static String formatNumber(double d) {
        return CameraPanel.formatNumber(d, "");
    }

    void setROI(boolean horizontal, List<Number> roi) {
        this.imageComponent.setROI(horizontal, roi);
    }

    void setShowROI(boolean showROI) {
        this.imageComponent.setShowROI(showROI);
    }

    void setZoomToROI(boolean zoom) {
        this.imageComponent.setZoomToROI(zoom);
    }

    void setShowEdges(boolean show) {
        this.imageComponent.setShowEdges(show);
    }

    void setShowGrid(boolean show) {
        this.imageComponent.setShowGrid(show);
    }

    void setPreserveAspectRatio(boolean selected) {
        this.imageComponent.setPreserveAspectRatio(selected);
    }

    void setGridSize(int size) {
        this.imageComponent.setGridSize(size);
    }
}

