import org.lsst.ccs.description.groovy.CCSBuilder
import org.lsst.ccs.bootstrap.BootstrapResourceUtils
import org.lsst.ccs.subsystem.vacuum.VacuumMain
import org.lsst.ccs.subsystem.vacuum.VacPlutoDevice
import org.lsst.ccs.subsystem.vacuum.VacSimPlutoDevice
import org.lsst.ccs.subsystem.vacuum.IonPumpDevice
import org.lsst.ccs.subsystem.vacuum.IonPumpControl
import org.lsst.ccs.subsystem.vacuum.Mks9xxDevice
import org.lsst.ccs.subsystem.vacuum.CryoTurboDevice
import org.lsst.ccs.subsystem.vacuum.data.VacSysState
import org.lsst.ccs.monitor.Channel
import org.lsst.ccs.monitor.Alarm

Properties props = BootstrapResourceUtils.getBootstrapSystemProperties()
runMode = props.getProperty("org.lsst.ccs.run.mode", "normal")
if (runMode.equals("simulation")) {
    vacPlutoDevc = VacSimPlutoDevice
}
else {
    vacPlutoDevc = VacPlutoDevice
} 

CCSBuilder builder = ["vacuum"]

builder.main (VacuumMain, cryoPressChan:"Cryo/CryoVac", turboPressChan:"Cryo/TurboVac",
              turboSpeedChan:"Cryo/TurboSpeed", forelinePressChan:"Cryo/ForelineVac",
              switches:[VacSysState.SW_CRYO_TURBO_PUMP, VacSysState.SW_CRYO_ION_PUMP1,
                        VacSysState.SW_CRYO_ION_PUMP2, VacSysState.SW_CRYO_ION_PUMP3,
                        VacSysState.SW_CRYO_ION_PUMP4, VacSysState.SW_CRYO_ION_PUMP5,
                        VacSysState.SW_CRYO_ION_PUMP6, VacSysState.SW_CRYO_GATE_VALVE]) {

    AlarmGeneric (Alarm, description:"Vacuum System Alarm - Generic", eventParm:23)

    VacPluto (vacPlutoDevc,
              latchesUsed:[VacSysState.LATCH_CR_GATE_AO, VacSysState.LATCH_CR_GATE_NFC,
                           VacSysState.LATCH_CR_PUMP, VacSysState.LATCH_CR_VACUUM,
			   VacSysState.LATCH_HX_VACUUM],
              condsUsed:[VacSysState.COND_CR_FORELINE_VAC, VacSysState.COND_CR_TRB_PRESS_10,
                         VacSysState.COND_CR_TRB_PUMP_OFF, VacSysState.COND_CR_VACUUM_001,
                         VacSysState.COND_CR_VACUUM_01, VacSysState.COND_HX_VACUUM_001,
			 VacSysState.COND_HX_VACUUM_01, VacSysState.COND_HX_FORELINE_VAC])

    int cip1 = IonPumpDevice.CHAN_CIP1
    int cip2 = IonPumpDevice.CHAN_CIP2
    int cip3 = IonPumpDevice.CHAN_CIP3
    int cip4 = IonPumpDevice.CHAN_CIP4
    int cip5 = IonPumpDevice.CHAN_CIP5
    int cip6 = IonPumpDevice.CHAN_CIP6
    int hip1 = IonPumpDevice.CHAN_HIP1
    int hip2 = IonPumpDevice.CHAN_HIP2
    int oip  = IonPumpDevice.CHAN_OIP

    IonPumps (IonPumpDevice) {

        CIP1C (IonPumpControl, hwChan:cip1)

        CIP2C (IonPumpControl, hwChan:cip2)

        CIP3C (IonPumpControl, hwChan:cip3)

        CIP4C (IonPumpControl, hwChan:cip4)

        CIP5C (IonPumpControl, hwChan:cip5)

        CIP6C (IonPumpControl, hwChan:cip6)

    }

    TurboPump (CryoTurboDevice)

    CryoVacGauge (Mks9xxDevice)

    TurboVacGauge (Mks9xxDevice)

    ForelineVacGauge (Mks9xxDevice)

    Hex1VacGauge (Mks9xxDevice)

    Hex2VacGauge (Mks9xxDevice)

    "Cryo/CIP1_V"     (Channel, description:"Cryo ion pump 1 voltage", units:"Volts", format:".1f",
                       devcName:"IonPumps", hwChan:cip1, type:"VOLTAGE")

    "Cryo/CIP1_I"     (Channel, description:"Cryo ion pump 1 current", units:"mA",
                       devcName:"IonPumps", hwChan:cip1, type:"CURRENT", scale:1000.0, limitHi:3.2, dbandHi:1.6)

    "Cryo/CIP1_Usage" (Channel, description:"Cryo ion pump 1 usage", units:"Torr-hrs", format:".3g",
                       devcName:"IonPumps", hwChan:cip1, type:"USAGE")

    "Cryo/CIP1_Life"  (Channel, description:"Cryo ion pump 1 lifetime", units:"Hours", format:".0f",
                       devcName:"IonPumps", hwChan:cip1, type:"LIFETIME")

    "Cryo/CIP2_V"     (Channel, description:"Cryo ion pump 2 voltage", units:"Volts", format:".1f",
                       devcName:"IonPumps", hwChan:cip2, type:"VOLTAGE")

    "Cryo/CIP2_I"     (Channel, description:"Cryo ion pump 2 current", units:"mA",
                       devcName:"IonPumps", hwChan:cip2, type:"CURRENT", scale:1000.0, limitHi:3.2, dbandHi:1.6)

    "Cryo/CIP2_Usage" (Channel, description:"Cryo ion pump 2 usage", units:"Torr-hrs", format:".3g",
                       devcName:"IonPumps", hwChan:cip2, type:"USAGE")

    "Cryo/CIP2_Life"  (Channel, description:"Cryo ion pump 2 lifetime", units:"Hours", format:".0f",
                       devcName:"IonPumps", hwChan:cip2, type:"LIFETIME")

    "Cryo/CIP3_V"     (Channel, description:"Cryo ion pump 3 voltage", units:"Volts", format:".1f",
                       devcName:"IonPumps", hwChan:cip3, type:"VOLTAGE")

    "Cryo/CIP3_I"     (Channel, description:"Cryo ion pump 3 current", units:"mA",
                       devcName:"IonPumps", hwChan:cip3, type:"CURRENT", scale:1000.0, limitHi:3.2, dbandHi:1.6)

    "Cryo/CIP3_Usage" (Channel, description:"Cryo ion pump 3 usage", units:"Torr-hrs", format:".3g",
                       devcName:"IonPumps", hwChan:cip3, type:"USAGE")

    "Cryo/CIP3_Life"  (Channel, description:"Cryo ion pump 3 lifetime", units:"Hours", format:".0f",
                       devcName:"IonPumps", hwChan:cip3, type:"LIFETIME")

    "Cryo/CIP4_V"     (Channel, description:"Cryo ion pump 4 voltage", units:"Volts", format:".1f",
                       devcName:"IonPumps", hwChan:cip4, type:"VOLTAGE")

    "Cryo/CIP4_I"     (Channel, description:"Cryo ion pump 4 current", units:"mA",
                       devcName:"IonPumps", hwChan:cip4, type:"CURRENT", scale:1000.0, limitHi:3.2, dbandHi:1.6)

    "Cryo/CIP4_Usage" (Channel, description:"Cryo ion pump 4 usage", units:"Torr-hrs", format:".3g",
                       devcName:"IonPumps", hwChan:cip4, type:"USAGE")

    "Cryo/CIP4_Life"  (Channel, description:"Cryo ion pump 4 lifetime", units:"Hours", format:".0f",
                       devcName:"IonPumps", hwChan:cip4, type:"LIFETIME")

    "Cryo/CIP5_V"     (Channel, description:"Cryo ion pump 5 voltage", units:"Volts", format:".1f",
                       devcName:"IonPumps", hwChan:cip5, type:"VOLTAGE")

    "Cryo/CIP5_I"     (Channel, description:"Cryo ion pump 5 current", units:"mA",
                       devcName:"IonPumps", hwChan:cip5, type:"CURRENT", scale:1000.0, limitHi:3.2, dbandHi:1.6)

    "Cryo/CIP5_Usage" (Channel, description:"Cryo ion pump 5 usage", units:"Torr-hrs", format:".3g",
                       devcName:"IonPumps", hwChan:cip5, type:"USAGE")

    "Cryo/CIP5_Life"  (Channel, description:"Cryo ion pump 5 lifetime", units:"Hours", format:".0f",
                       devcName:"IonPumps", hwChan:cip5, type:"LIFETIME")

    "Cryo/CIP6_V"     (Channel, description:"Cryo ion pump 6 voltage", units:"Volts", format:".1f",
                       devcName:"IonPumps", hwChan:cip6, type:"VOLTAGE")

    "Cryo/CIP6_I"     (Channel, description:"Cryo ion pump 6 current", units:"mA",
                       devcName:"IonPumps", hwChan:cip6, type:"CURRENT", scale:1000.0, limitHi:3.2, dbandHi:1.6)

    "Cryo/CIP6_Usage" (Channel, description:"Cryo ion pump 6 usage", units:"Torr-hrs", format:".3g",
                       devcName:"IonPumps", hwChan:cip6, type:"USAGE")

    "Cryo/CIP6_Life"  (Channel, description:"Cryo ion pump 6 lifetime", units:"Hours", format:".0f",
                       devcName:"IonPumps", hwChan:cip6, type:"LIFETIME")

    "Cryo/TurboSpeed"    (Channel, description:"Turbo pump speed", units:"rpm", format:".0f",
                          devcName:"TurboPump", type:"Numeric", subtype:"DRIVEFREQ", scale:60, limitHi:100000)

    "Cryo/TurboCurrent"  (Channel, description:"TurboPump current", units:"mA dc",
                          devcName:"TurboPump", type:"Numeric", subtype:"CURRENT",
                          checkLo:"none", checkHi:"none", format:"%.0f")

    "Cryo/TurboVoltage"  (Channel, description:"TurboPump voltage", units:"V dc",
                          devcName:"TurboPump", type:"Numeric", subtype:"VOLTAGE",
                          checkLo:"none", checkHi:"none", format:"%.0f")

    "Cryo/TurboPower"    (Channel, description:"TurboPump power", units:"W",
                          devcName:"TurboPump", type:"Numeric", subtype:"POWER",
                          checkLo:"none", checkHi:"alarm", alarmHi:"AlarmGeneric", format:"%.0f",
                          limitHi:150.0, dbandHi:100.0)

    "Cryo/TurboPumpTemp" (Channel, description:"TurboPump pump temperature", units:"deg C",
                          devcName:"TurboPump", type:"Numeric", subtype:"PUMP_TEMP", format:"%.0f",
                          limitLo:0.0, checkLo:"flag", dbandLo:5.0,
                          limitHi:40.0, checkHi:"alarm", alarmHi:"AlarmGeneric", dbandHi:10.0)

    "Cryo/CryoVac" (Channel, description:"Cryostat vacuum", units:"Torr", format:".3g", devcName:"CryoVacGauge", limitHi:1000)

    "Cryo/TurboVac" (Channel, description:"Turbo pump vacuum", units:"Torr", format:".3g", devcName:"TurboVacGauge", limitHi:1000)

    "Cryo/ForelineVac" (Channel, description:"Foreline pump vacuum", units:"Torr", format:".3g", devcName:"ForelineVacGauge", limitHi:1000)

    "HX/Hex1Vac" (Channel, description:"Heat exchanger 1 vacuum", units:"Torr", format:".3g", devcName:"Hex1VacGauge", limitHi:1000)

    "HX/Hex2Vac" (Channel, description:"Heat exchanger 2 vacuum", units:"Torr", format:".3g", devcName:"Hex2VacGauge", limitHi:1000)

}
