/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.motorplatform.bot;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PushbackReader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lsst.ccs.subsystem.motorplatform.bot.PlanToken;

public class PlanTokenizer {
    public PlanToken id;
    public Double value;
    public String text;
    public int line;
    private PushbackReader rdr;
    private static Pattern intPattern = Pattern.compile("\\d+");
    private static Pattern sensorPattern = Pattern.compile("B[0-4][0-4]-S[0-2][0-2]", 2);
    private static Pattern fidPattern = Pattern.compile("FID\\d", 2);
    private static Pattern refPattern = Pattern.compile(".*REF.*", 2);
    private static final Map<String, PlanToken> reserved = new HashMap<String, PlanToken>();

    public PlanTokenizer(PushbackReader rdr) {
        this.rdr = rdr;
        this.id = null;
        this.value = null;
        this.text = null;
        this.line = 0;
    }

    public void get() throws IOException {
        this.value = null;
        this.text = null;
        this.skipSpace();
        int ich = this.rdr.read();
        if (ich == -1) {
            this.id = PlanToken.EOF;
        } else {
            char ch = (char)ich;
            if (ch == '\n') {
                this.id = PlanToken.NEWLINE;
                ++this.line;
            } else if (ch == '!') {
                this.id = PlanToken.BANG;
            } else if (ch == '=') {
                this.id = PlanToken.EQUALS;
            } else {
                this.getWord(ch);
            }
        }
    }

    private void getWord(char first) throws IOException {
        Matcher m;
        StringBuilder bld = new StringBuilder();
        bld.append(first);
        int ich = this.rdr.read();
        while (ich >= 0 && !Character.isWhitespace(ich) && ich != 61) {
            bld.append((char)ich);
            ich = this.rdr.read();
        }
        if (ich >= 0) {
            this.rdr.unread(ich);
        }
        this.text = bld.toString();
        String upperText = this.text.toUpperCase();
        this.value = null;
        try {
            this.value = Double.valueOf(this.text);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.id = this.value != null ? ((m = intPattern.matcher(this.text)).matches() ? PlanToken.INTEGER : PlanToken.REAL) : (sensorPattern.matcher(this.text).matches() ? PlanToken.SENSOR : (fidPattern.matcher(this.text).matches() ? PlanToken.FID : (refPattern.matcher(this.text).matches() ? PlanToken.REF : (reserved.containsKey(upperText) ? reserved.get(upperText) : PlanToken.ILLEGAL))));
    }

    private void skipSpace() throws IOException {
        int ich = this.rdr.read();
        while (ich >= 0 && Character.isWhitespace(ich) && ich != 10) {
            ich = this.rdr.read();
        }
        if (ich >= 0) {
            this.rdr.unread(ich);
        }
    }

    public static void main(String[] args) throws IOException, FileNotFoundException {
        PushbackReader rdr = new PushbackReader(new BufferedReader(new FileReader(args[0])));
        PlanTokenizer scn = new PlanTokenizer(rdr);
        scn.get();
        while (scn.id != PlanToken.EOF) {
            System.out.printf("Line %d    token %s    text %s%n", new Object[]{scn.line, scn.id, scn.text});
            scn.get();
        }
    }

    static {
        reserved.put("TF", PlanToken.TF);
        reserved.put("X0", PlanToken.X0);
        reserved.put("Y0", PlanToken.Y0);
        reserved.put("THETA", PlanToken.THETA);
        reserved.put("PART", PlanToken.PART);
        reserved.put("OF", PlanToken.OF);
        reserved.put("LABEL", PlanToken.LABEL);
        reserved.put("SCAN", PlanToken.SCAN);
        reserved.put("N", PlanToken.N);
        reserved.put("DC", PlanToken.DC);
        reserved.put("WAIT", PlanToken.WAIT);
    }
}

