/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.imagehandling;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentCategory;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.daq.utilities.FitsHeaderKeywordData;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.imagehandling.ImageHandlingClient;

class FocalPlaneBusMessageHandler
implements HasLifecycle {
    private volatile String[] metaDataRegisters;
    private FocalPlaneConfigurationAndDataListener configListener;
    private static final Logger LOG = Logger.getLogger(FocalPlaneBusMessageHandler.class.getName());
    private final Predicate<BusMessage<? extends Serializable, ?>> focalPlanePredicate = bm -> FocalPlaneBusMessageHandler.isFocalPlaneAgent(bm.getOriginAgentInfo());
    private final Predicate<BusMessage<? extends Serializable, ?>> fitsHeaderDataPredicate = BusMessageFilterFactory.messageClass(StatusSubsystemData.class).and(bm -> "fitsHeaderKeywordData".equals(((StatusSubsystemData)bm).getDataKey()));
    private final Predicate<BusMessage<? extends Serializable, ?>> configurationDataPredicate = BusMessageFilterFactory.messageClass(StatusConfigurationInfo.class);
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private ImageHandlingClient imageHandlingClient;

    FocalPlaneBusMessageHandler() {
    }

    public void postStart() {
        this.configListener = new FocalPlaneConfigurationAndDataListener();
        this.agent.getMessagingAccess().addStatusMessageListener((StatusMessageListener)this.configListener, this.focalPlanePredicate.and(this.configurationDataPredicate.or(this.fitsHeaderDataPredicate)));
    }

    public void shutdown() {
        this.agent.getMessagingAccess().removeStatusMessageListener((StatusMessageListener)this.configListener);
    }

    public String[] getMetaDataRegisters() {
        return this.metaDataRegisters;
    }

    private static boolean isFocalPlaneAgent(AgentInfo agentInfo) {
        return AgentCategory.FOCAL_PLANE.name().equals(agentInfo.getAgentProperty("agentCategory"));
    }

    static /* synthetic */ String[] access$102(FocalPlaneBusMessageHandler x0, String[] x1) {
        x0.metaDataRegisters = x1;
        return x1;
    }

    private class FocalPlaneConfigurationAndDataListener
    implements StatusMessageListener {
        private String previousRunNumber;

        private FocalPlaneConfigurationAndDataListener() {
        }

        public void onStatusMessage(StatusMessage msg) {
            if (msg instanceof StatusConfigurationInfo) {
                ConfigurationInfo ci = ((StatusConfigurationInfo)msg).getConfigurationInfo();
                for (ConfigurationParameterInfo cpi : ci.getAllParameterInfo()) {
                    if (!cpi.getComponentName().equals("focalPlaneConfig") || !cpi.getParameterName().equals("metaDataRegisters")) continue;
                    FocalPlaneBusMessageHandler.access$102(FocalPlaneBusMessageHandler.this, (String[])cpi.getCurrentValueObject());
                    LOG.log(Level.FINEST, "Updating metaDataRegister to {0}", new Object[]{Arrays.asList(FocalPlaneBusMessageHandler.this.metaDataRegisters)});
                }
            }
            if (msg instanceof StatusSubsystemData && ((StatusSubsystemData)msg).getDataKey().equals("fitsHeaderKeywordData")) {
                StatusSubsystemData ssd = (StatusSubsystemData)msg;
                FitsHeaderKeywordData data = (FitsHeaderKeywordData)((KeyValueData)ssd.getObject()).getValue();
                List headerKeywordValues = data.getHeaderKeywordValues();
                Map<String, Serializable> headerMap = headerKeywordValues.stream().collect(Collectors.toMap(FitsHeaderKeywordData.HeaderKeywordValue::getHeaderKeywordName, FitsHeaderKeywordData.HeaderKeywordValue::getHeaderKeywordValue));
                LOG.log(Level.INFO, () -> String.format("Received headers %s", headerMap));
                if (headerMap.containsKey("darkTime")) {
                    FocalPlaneBusMessageHandler.this.imageHandlingClient.darkTimeArrived();
                } else if (headerMap.containsKey("RunNumber")) {
                    Serializable runNumber = headerMap.get("RunNumber");
                    FocalPlaneBusMessageHandler.this.imageHandlingClient.runNumberArrived(runNumber == null ? null : runNumber.toString());
                }
            }
        }
    }
}

