/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.mmm.filtersim;

import java.io.Serializable;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import org.lsst.ccs.subsystem.mmm.data.InvalidStateException;
import org.lsst.ccs.subsystem.mmm.filtersim.FilterSim;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;

public abstract class FilterInternalState
implements Serializable {
    private static final long serialVersionUID = -2206710139488554822L;
    private static final Duration loadingTime = Duration.ofMillis(15000L);
    private static final Duration rotatingTimePerDegree = Duration.ofMillis(100L);
    private static FilterSim.Filter[] carrouselConfig = new FilterSim.Filter[5];
    private static int carrouselPosition;
    private static double carrouselPositionAccuracy;
    private static double carrouselAngle;
    private static double carrouselVelocity;
    private static double carrouselTarget;
    private static double degreesPerSlot;
    private static FilterSim.Filter filterTarget;
    private String value;
    private static Map<String, FilterInternalState> fromValues;
    public static final FilterInternalState MOVING_TRUCKS_TO_STANDBY;
    public static final FilterInternalState MOVING_TRUCKS_TO_ONLINE;
    public static final LoadedState ONLINE_U;
    public static final LoadedState ONLINE_G;
    public static final LoadedState ONLINE_R;
    public static final LoadedState ONLINE_I;
    public static final LoadedState ONLINE_Z;
    public static final LoadedState ONLINE_Y;
    public static final FilterInternalState ONLINE_NONE;
    public static final FilterInternalState CARROUSEL_STOPPED;
    public static final FilterInternalState TRUCK_STOPPED;
    public static final FilterInternalState ROTATING;

    public static synchronized void setCarrouselTarget(double carrouselTarget) {
        FilterInternalState.carrouselTarget = carrouselTarget;
    }

    public static double getCarrouselTarget() {
        return carrouselTarget;
    }

    public static synchronized void setFilterTarget(FilterSim.Filter filterTarget) {
        FilterInternalState.filterTarget = filterTarget;
    }

    public static FilterSim.Filter getFilterTarget() {
        return filterTarget;
    }

    public static synchronized void setCarrouselVelocity(double carrouselVelocity) {
        FilterInternalState.carrouselVelocity = carrouselVelocity;
    }

    public static double getCarrouselVelocity() {
        return carrouselVelocity;
    }

    public static synchronized void setCarrouselAngle(double carrouselAngle) {
        FilterInternalState.carrouselAngle = carrouselAngle;
    }

    public static double getCarrouselAngle() {
        return carrouselAngle;
    }

    public static synchronized void setCarrouselPosition(int carrouselPosition) {
        FilterInternalState.carrouselPosition = carrouselPosition;
    }

    static int filterSlot(FilterSim.Filter f) {
        for (int i = 0; i < 5; ++i) {
            if (carrouselConfig[i] != f) continue;
            return i;
        }
        return -1;
    }

    public static FilterInternalState valueOf(String n) {
        return fromValues.get(n);
    }

    public String toString() {
        return this.value;
    }

    public FcsEnumerations.FilterState getPublicState() {
        return FcsEnumerations.FilterState.valueOf((String)this.toString());
    }

    public FcsEnumerations.FilterReadinessState getPublicReadinessState() {
        return FcsEnumerations.FilterReadinessState.READY;
    }

    protected FilterInternalState(String value) {
        this.value = value;
        fromValues.put(value, this);
    }

    public static synchronized FilterInternalState scheduled(FilterSim s, FilterInternalState from, FilterInternalState to) {
        if (s.state != from) {
            s.getLogger().info((Object)("  scheduled, NOP, in " + s.state + " transition expecting " + from));
            return s.state;
        }
        s.getLogger().debug((Object)(" scheduled: " + to));
        s.setState(to);
        return to;
    }

    public ScheduledFuture<FilterInternalState> scheduleTransition(FilterSim s, Duration delay, FilterInternalState to) {
        return s.scheduleTransition(delay, to);
    }

    public FilterInternalState setFilter(FilterSim s, String filter) {
        s.getLogger().error((Object)("invalid setFilter command, from state " + this));
        throw new InvalidStateException("FILTER:" + this.toString(), "setFilter");
    }

    public FilterInternalState stop(FilterSim s) {
        return this;
    }

    public FilterInternalState rotateToSlot(FilterSim s, int slot) {
        s.getLogger().error((Object)("invalid rotateToSlot command, from state " + this));
        throw new InvalidStateException("FILTER:" + this.toString(), "rotateToSlot");
    }

    public FilterInternalState truckToOnline(FilterSim s) {
        s.getLogger().error((Object)("invalid truckToOnline command, from state " + this));
        throw new InvalidStateException("FILTER:" + this.toString(), "truckToOnline");
    }

    public FilterInternalState truckToStandby(FilterSim s) {
        s.getLogger().error((Object)("invalid truckToStandby command, from state " + this));
        throw new InvalidStateException("FILTER:" + this.toString(), "truckToStandby");
    }

    public void enter(FilterSim s) {
    }

    public void exit(FilterSim s) {
    }

    public void tick(FilterSim s, Duration delay) {
    }

    static {
        FilterInternalState.carrouselConfig[0] = FilterSim.Filter.U;
        FilterInternalState.carrouselConfig[1] = FilterSim.Filter.G;
        FilterInternalState.carrouselConfig[2] = FilterSim.Filter.R;
        FilterInternalState.carrouselConfig[3] = FilterSim.Filter.I;
        FilterInternalState.carrouselConfig[4] = FilterSim.Filter.Z;
        carrouselPosition = 0;
        carrouselPositionAccuracy = 0.3;
        carrouselAngle = 0.0;
        carrouselVelocity = 0.0;
        carrouselTarget = 0.0;
        degreesPerSlot = 72.0;
        filterTarget = FilterSim.Filter.NONE;
        fromValues = new HashMap<String, FilterInternalState>();
        MOVING_TRUCKS_TO_STANDBY = new FilterInternalState("MOVING_TRUCKS_TO_STANDBY"){
            private static final long serialVersionUID = 3547930219242275351L;

            @Override
            public FcsEnumerations.FilterReadinessState getPublicReadinessState() {
                return FcsEnumerations.FilterReadinessState.NOT_READY;
            }

            @Override
            public void enter(FilterSim s) {
                if (filterTarget != FilterSim.Filter.NONE) {
                    if (filterTarget == carrouselConfig[carrouselPosition]) {
                        this.scheduleTransition(s, loadingTime, MOVING_TRUCKS_TO_ONLINE);
                    } else {
                        this.scheduleTransition(s, loadingTime, ROTATING);
                    }
                } else {
                    this.scheduleTransition(s, loadingTime, ONLINE_NONE);
                }
            }

            @Override
            public FilterInternalState stop(FilterSim s) {
                return TRUCK_STOPPED;
            }
        };
        MOVING_TRUCKS_TO_ONLINE = new FilterInternalState("MOVING_TRUCKS_TO_ONLINE"){
            private static final long serialVersionUID = 3164550830033395946L;

            @Override
            public FcsEnumerations.FilterReadinessState getPublicReadinessState() {
                return FcsEnumerations.FilterReadinessState.NOT_READY;
            }

            @Override
            public void enter(FilterSim s) {
                if (carrouselPosition < 0) {
                    s.getLogger().error((Object)("trying to enter MOVING_TRUCKS_TO_ONLINE state with wrong position " + carrouselAngle));
                    throw new RuntimeException("trying to enter MOVING_TRUCKS_TO_ONLINE state with wrong position " + carrouselAngle);
                }
                if (carrouselConfig[carrouselPosition] == FilterSim.Filter.NONE) {
                    s.getLogger().error((Object)("trying to enter MOVING_TRUCKS_TO_ONLINE state from empty slot " + carrouselPosition));
                    throw new RuntimeException("trying to enter MOVING_TRUCKS_TO_ONLINE state from empty slot " + carrouselPosition);
                }
                FilterInternalState ldState = FilterInternalState.valueOf("ONLINE_" + carrouselConfig[carrouselPosition].toString());
                this.scheduleTransition(s, loadingTime, ldState);
            }

            @Override
            public FilterInternalState stop(FilterSim s) {
                return TRUCK_STOPPED;
            }
        };
        ONLINE_U = new LoadedState("ONLINE_U"){
            private static final long serialVersionUID = -4579270362567461653L;
        };
        ONLINE_G = new LoadedState("ONLINE_G"){
            private static final long serialVersionUID = -4579270362567461654L;
        };
        ONLINE_R = new LoadedState("ONLINE_R"){
            private static final long serialVersionUID = -4579270362567461655L;
        };
        ONLINE_I = new LoadedState("ONLINE_I"){
            private static final long serialVersionUID = -4579270362567461656L;
        };
        ONLINE_Z = new LoadedState("ONLINE_Z"){
            private static final long serialVersionUID = -4579270362567461657L;
        };
        ONLINE_Y = new LoadedState("ONLINE_Y"){
            private static final long serialVersionUID = -4579270362567461658L;
        };
        ONLINE_NONE = new FilterInternalState("ONLINE_NONE"){
            private static final long serialVersionUID = 4169622670711024661L;

            @Override
            public FilterInternalState setFilter(FilterSim s, String filter) {
                FilterSim.Filter target = FilterSim.Filter.valueOf(filter);
                if (target == FilterSim.Filter.NONE) {
                    return this;
                }
                int slot = 9.filterSlot(target);
                if (slot < 0) {
                    throw new RuntimeException("filter " + filter + " not available");
                }
                9.setCarrouselTarget((double)slot * degreesPerSlot);
                9.setFilterTarget(target);
                if (carrouselPosition == slot) {
                    return MOVING_TRUCKS_TO_ONLINE;
                }
                return ROTATING;
            }

            @Override
            public FilterInternalState rotateToSlot(FilterSim s, int slot) {
                9.setCarrouselTarget((double)slot * degreesPerSlot);
                9.setFilterTarget(FilterSim.Filter.NONE);
                return ROTATING;
            }

            @Override
            public FilterInternalState truckToOnline(FilterSim s) {
                9.setFilterTarget(carrouselConfig[carrouselPosition]);
                return MOVING_TRUCKS_TO_ONLINE;
            }

            @Override
            public void enter(FilterSim s) {
                if (filterTarget != FilterSim.Filter.NONE) {
                    if (filterTarget == carrouselConfig[carrouselPosition]) {
                        this.scheduleTransition(s, Duration.ofMillis(10L), MOVING_TRUCKS_TO_ONLINE);
                    } else {
                        this.scheduleTransition(s, Duration.ofMillis(10L), ROTATING);
                    }
                }
            }
        };
        CARROUSEL_STOPPED = new FilterInternalState("CARROUSEL_STOPPED"){
            private static final long serialVersionUID = 4210261367736980724L;

            @Override
            public void enter(FilterSim s) {
            }

            @Override
            public FcsEnumerations.FilterReadinessState getPublicReadinessState() {
                return FcsEnumerations.FilterReadinessState.NOT_READY;
            }

            @Override
            public FilterInternalState rotateToSlot(FilterSim s, int slot) {
                10.setCarrouselTarget((double)slot * degreesPerSlot);
                10.setFilterTarget(FilterSim.Filter.NONE);
                return ROTATING;
            }
        };
        TRUCK_STOPPED = new FilterInternalState("TRUCK_STOPPED"){
            private static final long serialVersionUID = -3856447430182740780L;

            @Override
            public void enter(FilterSim s) {
            }

            @Override
            public FcsEnumerations.FilterReadinessState getPublicReadinessState() {
                return FcsEnumerations.FilterReadinessState.NOT_READY;
            }

            @Override
            public FilterInternalState truckToOnline(FilterSim s) {
                11.setFilterTarget(carrouselConfig[carrouselPosition]);
                return MOVING_TRUCKS_TO_ONLINE;
            }

            @Override
            public FilterInternalState truckToStandby(FilterSim s) {
                11.setFilterTarget(FilterSim.Filter.NONE);
                return MOVING_TRUCKS_TO_STANDBY;
            }
        };
        ROTATING = new FilterInternalState("ROTATING"){
            private static final long serialVersionUID = 3045706708877965366L;

            @Override
            public FcsEnumerations.FilterReadinessState getPublicReadinessState() {
                return FcsEnumerations.FilterReadinessState.NOT_READY;
            }

            @Override
            public void enter(FilterSim s) {
                double angle = carrouselTarget - carrouselAngle;
                if (angle > 180.0) {
                    angle -= 360.0;
                }
                if (angle <= -180.0) {
                    angle += 360.0;
                }
                12.setCarrouselVelocity(1000.0 / (double)rotatingTimePerDegree.toMillis());
                long mills = (long)((double)rotatingTimePerDegree.toMillis() / carrouselPositionAccuracy / 5.0);
                if (angle < 0.0) {
                    12.setCarrouselVelocity(-carrouselVelocity);
                }
                s.getLogger().info((Object)(" start rotating, goal " + carrouselTarget + " current " + carrouselAngle + " move " + angle));
                s.getLogger().info((Object)("rotating at " + carrouselVelocity + " step " + mills + " millis."));
                s.scheduleTick(Duration.ofMillis(mills));
            }

            @Override
            public void exit(FilterSim s) {
                12.setCarrouselVelocity(0.0);
            }

            @Override
            public FilterInternalState stop(FilterSim s) {
                if (carrouselPosition < 0) {
                    return CARROUSEL_STOPPED;
                }
                return ONLINE_NONE;
            }

            @Override
            public void tick(FilterSim s, Duration delay) {
                int closestSlot;
                double ca = carrouselAngle;
                if ((ca += carrouselVelocity * (double)delay.toMillis() / 1000.0) < 0.0) {
                    ca += 360.0;
                }
                if (ca >= 360.0) {
                    ca -= 360.0;
                }
                12.setCarrouselAngle(ca);
                double angle = carrouselTarget - carrouselAngle;
                if (angle > 180.0) {
                    angle -= 360.0;
                }
                if (angle <= -180.0) {
                    angle += 360.0;
                }
                if ((closestSlot = (int)Math.round(carrouselAngle / degreesPerSlot)) < 0) {
                    closestSlot += 5;
                }
                if (Math.abs((double)closestSlot * degreesPerSlot - carrouselAngle) < carrouselPositionAccuracy) {
                    if (carrouselPosition != closestSlot) {
                        12.setCarrouselPosition(closestSlot);
                        s.getLogger().info((Object)(" -> slot " + carrouselPosition));
                    }
                } else {
                    12.setCarrouselPosition(-1);
                }
                s.getLogger().debug((Object)(carrouselAngle + " " + closestSlot + " " + carrouselPosition));
                if (Math.abs(angle) < carrouselPositionAccuracy) {
                    if (filterTarget == FilterSim.Filter.NONE) {
                        this.scheduleTransition(s, Duration.ofMillis(10L), ONLINE_NONE);
                    } else {
                        this.scheduleTransition(s, Duration.ofMillis(10L), MOVING_TRUCKS_TO_ONLINE);
                    }
                }
                if (angle * carrouselVelocity < 0.0) {
                    s.getLogger().warn((Object)"overshoot!");
                    12.setCarrouselVelocity(-carrouselVelocity / 2.0);
                }
                s.scheduleTick(delay);
            }
        };
    }

    public static abstract class LoadedState
    extends FilterInternalState {
        private static final long serialVersionUID = 1490768556406972031L;
        protected FilterSim.Filter loaded;

        protected LoadedState(String value) {
            super(value);
            this.loaded = FilterSim.Filter.valueOf(value.substring(7, 8));
        }

        @Override
        public FilterInternalState setFilter(FilterSim s, String filter) {
            FilterSim.Filter target = FilterSim.Filter.valueOf(filter);
            if (target == this.loaded) {
                return this;
            }
            if (target != FilterSim.Filter.NONE) {
                int slot = LoadedState.filterSlot(target);
                if (slot < 0) {
                    throw new RuntimeException("filter " + filter + " not available");
                }
                LoadedState.setCarrouselTarget((double)slot * degreesPerSlot);
            }
            LoadedState.setFilterTarget(target);
            return MOVING_TRUCKS_TO_STANDBY;
        }

        @Override
        public FilterInternalState truckToStandby(FilterSim s) {
            LoadedState.setFilterTarget(FilterSim.Filter.NONE);
            return MOVING_TRUCKS_TO_STANDBY;
        }
    }
}

