/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.common;

import org.lsst.ccs.subsystem.shutter.common.Axis;

public enum ShutterSide {
    MINUSX(750.0, 0.0),
    PLUSX(0.0, 750.0);

    private final double range;

    private ShutterSide(double home, double extended) {
        this.range = extended - home;
    }

    public ShutterSide opposite() {
        return this == PLUSX ? MINUSX : PLUSX;
    }

    public static ShutterSide fromAxis(Axis ax) {
        return ax.isPlusXSide() ? PLUSX : MINUSX;
    }

    public double normalizePosition(double absolute) {
        double scaled = absolute / this.range;
        return this.range < 0.0 ? 1.0 + scaled : scaled;
    }
}

