import org.lsst.ccs.description.groovy.CCSBuilder
import org.lsst.ccs.subsystem.utility.UTTestMain
import org.lsst.ccs.subsystem.utility.FanPIControl
import org.lsst.ccs.subsystem.utility.UTMaq20Device
import org.lsst.ccs.subsystem.utility.BfrDevice
import org.lsst.ccs.subsystem.utility.Pdu24VDevice
import org.lsst.ccs.subsystem.utility.Pdu48VDevice
import org.lsst.ccs.subsystem.utility.VpcControl
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20PWMControl
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20PulseControl
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20AnalogControl
import org.lsst.ccs.monitor.Channel

CCSBuilder builder = ["uttest"]

builder.main (UTTestMain, utFan: "UTFan") {

    UTFan   (FanPIControl, fans: ["UTPwm"], refTempChans: ["UT/AmbAirtemp"], ctrlTempChans: ["UT/AvgAirtempOut"])

    Maq20 (UTMaq20Device, modules: ["DIOL:pwm:pulse", "TTC", "IO"]) {

       UTPwm (Maq20PWMControl, modIndex: 0, funcIndex: 0, frequency: 200.0)

       UTPulse (Maq20PulseControl, modIndex: 0, funcIndex: 1, pulsesPerRevn: 2)

       AnalogOut (Maq20AnalogControl, modIndex: 2, ranges: ["MA4_20", "MA4_20"])
    }

    BFR (BfrDevice)

    PDU_24V (Pdu24VDevice)

    PDU_48V (Pdu48VDevice)

    /*
    Chanxxx    (Channel, description: "",
                format: ".2f", units: "", devcName: "xxx, hwChan: 0,
                type: "", subtype: "", offset: 0, scale: 1, pageId: 0, 
                checkLo: "flag", limitLo: 0.0, dbandLo: 0.0, alarmLo: null,
                checkHi: "flag", limitHi: 0.0, dbandHi: 0.0, alarmHi: null)
*/

    "Power/BFR_I" (Channel, description: "BFR total current", units: "mA", format: ".1f",
                   devcName: "BFR", hwChan: 0, scale: 1000.0)

    "Power/24V_Main_V" (Channel, description: "24V PDU main voltage", units: "Volts", format: ".2f",
                        devcName: "PDU_24V", type: "MAINVOLT")

    "Power/24V_Main_I" (Channel, description: "24V PDU main current", units: "mA", format: ".1f",
                        devcName: "PDU_24V", type: "MAINCURR", scale: 1000.0)

    "Power/24V_Main_T" (Channel, description: "24V PDU main temperature", units: "\u00b0C", format: ".1f",
                        devcName: "PDU_24V", type: "MAINTEMP")

    //"Power/24V_Board_T" (Channel, description: "24V PDU board temperature", units: "\u00b0C", format: ".1f",
    //                     devcName: "PDU_24V", type: "BOARDTEMP")

    //"Power/24V_FPGA_T" (Channel, description: "24V PDU FPGA temperature", units: "\u00b0C", format: ".1f",
    //                    devcName: "PDU_24V", type: "FPGATEMP")

    "Power/48V_Main_V" (Channel, description: "48V PDU main voltage", units: "Volts", format: ".2f",
                        devcName: "PDU_48V", type: "MAINVOLT")

    "Power/48V_Main_I" (Channel, description: "48V PDU main current", units: "mA", format: ".1f",
                        devcName: "PDU_48V", type: "MAINCURR", scale: 1000.0)

    "Power/48V_Main_T" (Channel, description: "48V PDU main temperature", units: "\u00b0C", format: ".1f",
                        devcName: "PDU_48V", type: "MAINTEMP")

    //"Power/48V_Board_T" (Channel, description: "48V PDU board temperature", units: "\u00b0C", format: ".1f",
    //                     devcName: "PDU_48V", type: "BOARDTEMP")

    //"Power/48V_FPGA_T" (Channel, description: "48V PDU FPGA temperature", units: "\u00b0C", format: ".1f",
    //                    devcName: "PDU_48V", type: "FPGATEMP")

    "Power/Electronics_V" (Channel, description: "Electronics voltage", units: "Volts", format: ".2f",
                           devcName: "PDU_24V", hwChan: Pdu24VDevice.CHAN_ELECTRONICS, type: "VOLTAGE")

    "Power/Electronics_I" (Channel, description: "Electronics current", units: "mA", format: ".1f",
                           devcName: "PDU_24V", hwChan: Pdu24VDevice.CHAN_ELECTRONICS, type: "CURRENT", scale: 1000.0)

    "Power/CoolingFan_V" (Channel, description: "UT cooling fan voltage", units: "Volts", format: ".2f",
                          devcName: "PDU_48V", hwChan: Pdu48VDevice.CHAN_UT_FAN, type: "VOLTAGE")

    "Power/CoolingFan_I" (Channel, description: "UT cooling fan current", units: "mA", format: ".1f",
                          devcName: "PDU_48V", hwChan: Pdu48VDevice.CHAN_UT_FAN, type: "CURRENT", scale: 1000.0)

    "UT/ValvePosn" (Channel, description: "UT coolant valve position",
                    devcName: "Maq20", hwChan: UTMaq20Device.CHAN_UT_VALVE, type: "2", subtype: "")

    "UT/AvgAirtempOut" (Channel, description: "UT average air temperature", units: "\u00b0C",
                        devcName: "Maq20", hwChan: 0, type: "1", subtype: "T220")

    "UT/AmbAirtemp" (Channel, description: "UT ambient air temperature", units: "\u00b0C",
                     devcName: "Maq20", hwChan: 1, type: "1", subtype: "T220")

    "UT/FanTach" (Channel, description: "UT fan tachometer", units: "rpm", format: ".0f",
                  devcName: "Maq20", hwChan: UTMaq20Device.CHAN_PULSE_RPM, type: "0", subtype: "1")

}
