// The Groovy file for the BOT stage configured for light-source tests.
import org.lsst.ccs.description.groovy.CCSBuilder;
import org.lsst.ccs.subsystem.motorplatform.bot.LampMain;
import org.lsst.ccs.subsystem.motorplatform.bot.LampController;
import org.lsst.ccs.subsystem.motorplatform.bot.Axis;

CCSBuilder builder = ["bot-motorplatform"]

builder.
    main(LampMain) {
        // Subsystem main. Takes commands from the CCS bus and
        // delegates operations to the Controller.
        
        Controller(LampController) {
            // The Controller sends commands to the motor controller,
            // if any, and publishes status reports.
            
            // Axis names, indexes and units must match those configured in the
            // motor controller.
            XAxis(Axis, axisName:"X", index:0, units:"mm")
            YAxis(Axis, axisName:"Y", index:1, units: "mm")
        }
    
    }
