import org.lsst.ccs.description.groovy.CCSBuilder;
import org.lsst.ccs.subsystem.refrig.RefrigMain;
import org.lsst.ccs.subsystem.refrig.ColdCompressor;
import org.lsst.ccs.subsystem.refrig.CompMaq20Device;
import org.lsst.ccs.subsystem.refrig.CompPlutoDevice;
import org.lsst.ccs.subsystem.refrig.CryoCompressor;
import org.lsst.ccs.subsystem.refrig.TempControl;
import org.lsst.ccs.subsystem.common.devices.Maq20Control;
import org.lsst.ccs.subsystem.common.devices.Maq20Device;
import org.lsst.ccs.subsystem.common.devices.Maq20PWMControl;
import org.lsst.ccs.subsystem.common.devices.Maq20PulseControl;
import org.lsst.ccs.monitor.Channel;

taskConfig = ["monitor-update/taskPeriodMillis":1000, "monitor-publish/taskPeriodMillis":10000]
numCold = 2
coldNames = ["Cold1", "Cold2"]
coldPlcNodes = ["192.168.1.150", "192.168.1.152"]
coldMaqNodes = ["192.168.1.151", "192.168.1.153"]
coldMaqMods = [["TTC:0098488-10", "DIOL:0123765-07:pwm:pulse", "DIOL:0106270-02:pulse:pulse"], // CO01
               ["TTC:0131744-15", "DIOL:0123765-08:pwm:pulse", "DIOL:0124048-03:pulse:pulse"]] // CO02
numCryo = 6
cryoNames = ["Cryo5", "Cryo6", "Cryo4", "Cryo3", "Cryo2", "Cryo1"]
cryoPlcNodes = ["192.168.1.170", "192.168.1.178", "192.168.1.174", "192.168.1.176", "192.168.1.172", "192.168.1.180"]
cryoMaqNodes = ["192.168.1.171", "192.168.1.179", "192.168.1.175", "192.168.1.177", "192.168.1.173", "192.168.1.181"]
cryoMaqMods = [
               ["TTC:0122853-01", "TTC:0098488-09", "DIOL:0123971-07:pwm:pulse"], // CY01
               ["TTC:0131744-22", "TTC:0131744-21", "DIOL:0129490-07:pwm:pulse"], // CY05
               ["TTC:0129489-03", "TTC:0131744-23", "DIOL:0123971-06:pwm:pulse"], // CY04
               ["TTC:0131744-14", "TTC:0131744-19", "DIOL:0124048-08:pwm:pulse"], // CY02
               ["TTC:0129489-01", "TTC:0131744-01", "DIOL:0129490-01:pwm:pulse"], // CY03
               ["TTC:0129489-06", "TTC:0131744-08", "DIOL:0132177-01:pwm:pulse"]  // CY06
              ]

CCSBuilder builder = ["refrig"]

builder.main (RefrigMain, nodeTags: taskConfig) {

    for (j = 0; j < numCold; j++) {

        "${coldNames[j]}" (ColdCompressor, discTempChan: "Plc/DiscTemp", discPressChan: "Plc/DiscPress",
                           suctTempChan: "Plc/SuctTemp", cmprPowerChan: "Plc/Power", liquidTempChan: "Plc/LiqdTemp") {

            Plc (CompPlutoDevice, node: coldPlcNodes[j]) {

                DiscTemp (Channel, description: "Discharge Temperature", units: "\u00b0C",
                          hwChan: 1, type: "ADDREG:0", scale: 0.01)

                DiscPress (Channel, description: "Discharge Pressure", units: "Psia",
                          hwChan: 1, type: "ADDREG:3", scale: 0.1)

                SuctTemp (Channel, description: "Suction Temperature", units: "\u00b0C",
                          hwChan: 1, type: "ADDREG:1", scale: 0.01)

                SuctPress (Channel, description: "Suction Pressure", units: "Psia",
                          hwChan: 1, type: "ADDREG:4", scale: 0.1)

                LiqdTemp (Channel, description: "Liquid Temperature", units: "\u00b0C",
                          hwChan: 1, type: "ADDREG:2", scale: 0.01)

                Current  (Channel, description: "Compressor Current", units: "Amps",
                          hwChan: 1, type: "ADDREG:5", scale: 0.01)

                Voltage (Channel, description: "Compressor Voltage", units: "Volts",
                         hwChan: 1, type: "ADDREG:6", scale: 0.1)

                Power   (Channel, description: "Compressor Power", units: "VA",
                         hwChan: 0, type: "ADDINT:9", scale: 0.001)

            }

            Maq20 (CompMaq20Device, node: coldMaqNodes[j], modules: coldMaqMods[j] as String[]) {

                FanControl (Maq20PWMControl, type:"1:0", frequency:200.0)

                PulseControl0 (Maq20PulseControl, type:"1:1", pulsesPerRevn:6)

                PulseControl1 (Maq20PulseControl, type:"2:0", pulsesPerRevn:6)

                PulseControl2 (Maq20PulseControl, type:"2:1", pulsesPerRevn:6)

                CompDisTemp (Channel, description: "Compressor Discharge Temperature", units: "\u00b0C",
                             hwChan: 3, type: "0", subtype: "T220")

                CompSucTemp (Channel, description: "Compressor Suction Temperature", units: "\u00b0C",
                             hwChan: 2, type: "0", subtype: "T220")

                CompLiqTemp (Channel, description: "Compressor Liquid Temperature", units: "\u00b0C",
                             hwChan: 1, type: "0", subtype: "T220")

                WaterInTemp (Channel, description: "Water Inlet Temperature", units: "\u00b0C",
                             hwChan: 0, type: "0", subtype: "T220")

                WaterOutTemp (Channel, description: "Water Outlet Temperature", units: "\u00b0C",
                             hwChan: 4, type: "0", subtype: "T220")

                CabinetTemp (Channel, description: "Cabinet Temperature", units: "\u00b0C",
                             hwChan: 6, type: "0", subtype: "T220")

                AmbientTemp (Channel, description: "Ambient Temperature", units: "\u00b0C",
                             hwChan: 5, type: "0", subtype: "T220")

                Fan1Speed  (Channel, description:"Fan 1 Speed", units:"rpm", format:".0f",
                            hwChan:Maq20Device.CHAN_PULSE_RPM, type:"1", subtype:"1")

                Fan2Speed  (Channel, description:"Fan 2 Speed", units:"rpm", format:".0f",
                            hwChan:Maq20Device.CHAN_PULSE_RPM, type:"2", subtype:"0")

                Fan3Speed  (Channel, description:"Fan 3 Speed", units:"rpm", format:".0f",
                            hwChan:Maq20Device.CHAN_PULSE_RPM, type:"2", subtype:"1")

            }
        }
    }

    for (j = 0; j < numCryo; j++) {

        "${cryoNames[j]}" (CryoCompressor, discTempChan: "Plc/DiscTemp", discPressChan: "Plc/DiscPress",
                           suctTempChan: "Plc/SuctTemp", cmprPowerChan: "Plc/Power", phaseSepTempChan: "Maq20/PhaseSepTemp") {

            Plc (CompPlutoDevice, node: cryoPlcNodes[j]) {

                DiscTemp (Channel, description: "Discharge Temperature", units: "\u00b0C",
                          hwChan: 1, type: "ADDREG:0", scale: 0.01)

                DiscPress (Channel, description: "Discharge Pressure", units: "Psia",
                          hwChan: 1, type: "ADDREG:3", scale: 0.1)

                SuctTemp (Channel, description: "Suction Temperature", units: "\u00b0C",
                          hwChan: 1, type: "ADDREG:1", scale: 0.01)

                SuctPress (Channel, description: "Suction Pressure", units: "Psia",
                          hwChan: 1, type: "ADDREG:4", scale: 0.1)

                OilLevel (Channel, description: "Oil Level", units: "mm",
                          hwChan: 1, type: "ADDREG:2", scale: 0.01818, offset: -36.36)

                Current (Channel, description: "Compressor Current", units: "Amps",
                         hwChan: 1, type: "ADDREG:5", scale: 0.01)

                Voltage (Channel, description: "Compressor Voltage", units: "Volts",
                         hwChan: 1, type: "ADDREG:6", scale: 0.1)

                Power   (Channel, description: "Compressor Power", units: "VA",
                         hwChan: 0, type: "ADDINT:9", scale: 0.001)

            }

            Maq20 (CompMaq20Device, node: cryoMaqNodes[j], modules: cryoMaqMods[j] as String[]) {

                FanControl (Maq20PWMControl, type:"2:0", frequency:200.0)

                PulseControl (Maq20PulseControl, type:"2:1", pulsesPerRevn:6)

                LineControl  (Maq20Control, type:"2")

                CompDisTemp (Channel, description: "Compressor Discharge Temperature", units: "\u00b0C",
                             hwChan: 3, type: "0", subtype: "T220")

                CompSucTemp (Channel, description: "Compressor Suction Temperature", units: "\u00b0C",
                             hwChan: 2, type: "0", subtype: "T220")

                WaterInTemp (Channel, description: "Water Inlet Temperature", units: "\u00b0C",
                             hwChan: 0, type: "0", subtype: "T220")

                WaterOutTemp (Channel, description: "Water Outlet Temperature", units: "\u00b0C",
                              hwChan: 4, type: "0", subtype: "T220")

                AfterCoolTemp (Channel, description: "After Cooler Temperature", units: "\u00b0C",
                               hwChan: 1, type: "0", subtype: "T220")

                PhaseSepTemp (Channel, description: "Phase Separator Temperature", units: "\u00b0C",
                              hwChan: 5, type: "0", subtype: "T220")

                OilSepTemp  (Channel, description: "Oil Separator Temperature", units: "\u00b0C",
                             hwChan: 6, type: "0", subtype: "T220")

                SurgeTankTemp (Channel, description: "Surge Tank Temperature", units: "\u00b0C",
                               hwChan: 7, type: "0", subtype: "T220")

                if (j % 3 == 0) {
                    CabinetTemp (Channel, description: "Cabinet Temperature", units: "\u00b0C",
                                 hwChan: 1, type: "1", subtype: "T220")

                    AmbientTemp (Channel, description: "Ambient Temperature", units: "\u00b0C",
                                 hwChan: 0, type: "1", subtype: "T220")
                }

                FanSpeed   (Channel, description:"Fan Speed", units:"rpm", format:".0f",
                            hwChan:Maq20Device.CHAN_PULSE_RPM, type:"2", subtype:"1")

            }
        }

    }

}
