/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.motorplatform.bot;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.SynchronousQueue;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.framework.HardwareController;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.subsystem.motorplatform.bot.Aerotech;
import org.lsst.ccs.subsystem.motorplatform.bot.Controller;
import org.lsst.ccs.subsystem.motorplatform.bot.Keyence;
import org.lsst.ccs.subsystem.motorplatform.bot.QCommand;
import org.lsst.ccs.subsystem.motorplatform.bus.AxisStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.ControllerStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.IOStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.MotorCommandListener;
import org.lsst.ccs.utilities.logging.Logger;

public class MetroController
extends Controller
implements MotorCommandListener,
HardwareController {
    private static final Logger LOG = Logger.getLogger((String)MetroController.class.getName());
    @ConfigurationParameter(description="The serial port device name for the Keyence comm link.")
    private volatile String keyenceCommPort = "/dev/ttyS0";
    @ConfigurationParameter(description="The baud rate for the Keyence comm link.")
    private volatile int keyenceBaud = 115200;
    private volatile QCommand currentCommand;
    private volatile Keyence keyenceLink;
    private static final String KEYENCE_DEVICE = "Keyence";

    private MetroController() {
    }

    @Override
    public void commandTaskBody() {
        try {
            this.commandTaskCore();
        }
        catch (DriverException exc) {
            this.flagDevicesOffline((Exception)((Object)exc));
            this.cancelQueuedCommands();
        }
        catch (InterruptedException exc) {
            LOG.warning((Object)"Command task was interrupted.");
        }
        catch (Exception exc) {
            LOG.error((Object)"Unexpected exception in command task.", (Throwable)exc);
        }
    }

    private void commandTaskCore() throws Exception {
        QCommand newCmd;
        QCommand.Disposition disp;
        if (this.currentCommand != null && (disp = this.currentCommand.update()) != QCommand.Disposition.RUNNING) {
            this.currentCommand = null;
            if (disp != QCommand.Disposition.FINISHED) {
                this.cancelQueuedCommands();
            }
        }
        if (this.currentCommand == null && (newCmd = (QCommand)this.commandDeque.poll()) != null) {
            try {
                disp = newCmd.run();
            }
            catch (Exception exc) {
                newCmd.cancel();
                throw exc;
            }
            if (disp == QCommand.Disposition.RUNNING) {
                this.currentCommand = newCmd;
            } else if (disp == QCommand.Disposition.FINISHED) {
                this.currentCommand = null;
            } else {
                newCmd.cancel();
                this.cancelQueuedCommands();
            }
        }
    }

    @Override
    protected void statusTaskBody() {
        try {
            this.publishAll();
        }
        catch (Aerotech.CommandFailureException exc) {
            this.aeroLogFailure(exc);
        }
        catch (DriverException exc) {
            this.flagDevicesOffline((Exception)((Object)exc));
            this.cancelQueuedCommands();
        }
        catch (InterruptedException exc) {
            LOG.warning((Object)"Status task was interrupted.");
        }
        catch (Exception exc) {
            LOG.error((Object)"Unexpected exception in status task.", (Throwable)exc);
        }
    }

    @Override
    protected void publishOtherStatus(Aerotech aero, ControllerStatus ctrlStat, IOStatus ioStat, Map<String, AxisStatus> axisStat) throws Exception {
    }

    @Override
    protected void commTaskBody() {
        if (!this.onlineFlag) {
            this.aeroLink.close();
            this.keyenceLink.close();
            try {
                this.aeroInit();
                this.keyenceInit();
                this.flagDevicesOnline();
            }
            catch (Aerotech.CommandFailureException exc) {
                this.aeroLogFailure(exc);
            }
            catch (Keyence.CommandFailureException exc) {
                this.keyenceLogFailure(exc);
            }
            catch (DriverException exc) {
                LOG.error((Object)exc);
            }
            catch (Exception exc) {
                LOG.error((Object)"Unexpected exception in comm task.", (Throwable)exc);
            }
        }
    }

    private void keyenceLogFailure(Keyence.CommandFailureException exc) {
        LOG.warning((Object)exc.getMessage());
        LOG.warning((Object)String.format("Status code %d: %s. Command = %s.", exc.reply.statusCode, exc.reply.statusString, exc.reply.command));
    }

    public TreeWalkerDiag checkHardware() throws HardwareException {
        try {
            this.keyenceInit();
            this.aeroInit();
        }
        catch (DriverException exc) {
            throw new HardwareException(true, (Throwable)exc);
        }
        return TreeWalkerDiag.GO;
    }

    private void keyenceInit() throws DriverException {
        this.keyenceLink = new Keyence(new Ascii());
        this.keyenceLink.open(this.keyenceCommPort, this.keyenceBaud);
        this.keyenceLink.setReplyTimeout((int)this.chatTimeout.toMillis());
    }

    public void checkStopped() throws HardwareException {
        HardwareException hwexc = null;
        this.stopTasks();
        try {
            if (this.onlineFlag) {
                this.aeroStop();
            }
        }
        catch (DriverException exc) {
            hwexc = new HardwareException((Throwable)exc, hwexc);
        }
        if (this.onlineFlag) {
            this.keyenceLink.close();
        }
        if (hwexc != null) {
            throw hwexc;
        }
    }

    @Command(description="Executes a Keyence command and returns the result string.", level=1, timeout=3600, autoAck=false)
    public String keyenceChat(final @Argument(name="command", description="The Keyence command.") String cmdText) {
        if (!this.onlineFlag) {
            this.subsys.sendNack((Serializable)((Object)"One or more devices offline"));
        }
        final SynchronousQueue response = new SynchronousQueue();
        QCommand cmd = new QCommand(){

            @Override
            public String device() {
                return MetroController.KEYENCE_DEVICE;
            }

            @Override
            public QCommand.Disposition run() {
                return MetroController.this.chatBody(MetroController.this.keyenceLink, cmdText, response);
            }

            @Override
            public QCommand.Disposition update() {
                return QCommand.Disposition.FINISHED;
            }
        };
        this.commandDeque.add(cmd);
        this.subsys.sendAck(null);
        try {
            return (String)response.take();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return "ERROR: INTERRUPTED";
        }
    }
}

