/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.motorplatform.bot;

import java.io.Serializable;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.motorplatform.bot.Controller;
import org.lsst.ccs.subsystem.motorplatform.bus.AxisStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.ChangeAxisEnable;
import org.lsst.ccs.subsystem.motorplatform.bus.ChangeOutputLine;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAllFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAxisFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearCapture;
import org.lsst.ccs.subsystem.motorplatform.bus.ControllerStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.EnableAllAxes;
import org.lsst.ccs.subsystem.motorplatform.bus.HomeAxis;
import org.lsst.ccs.subsystem.motorplatform.bus.MotorCommandListener;
import org.lsst.ccs.subsystem.motorplatform.bus.MotorplatformType;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisAbsolute;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisRelative;
import org.lsst.ccs.subsystem.motorplatform.bus.PlatformConfig;
import org.lsst.ccs.subsystem.motorplatform.bus.SendAxisStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.SendConfiguration;
import org.lsst.ccs.subsystem.motorplatform.bus.SendControllerStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.SetupCapture;
import org.lsst.ccs.subsystem.motorplatform.bus.ShellCommandListener;
import org.lsst.ccs.subsystem.motorplatform.bus.StopAllMotion;
import org.lsst.ccs.utilities.logging.Logger;

public abstract class Main<T extends Controller>
implements MotorCommandListener,
ShellCommandListener {
    private static final Logger LOG = Logger.getLogger((String)Main.class.getName());
    private ExecutorService publisher;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    protected T controller;
    @LookupField(strategy=LookupField.Strategy.TOP)
    protected Subsystem subsystem;
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected AlertService alertService;
    protected final Map<String, Serializable> statusCache = new ConcurrentHashMap<String, Serializable>();
    private final AtomicReference<PlatformConfig> platformConfiguration = new AtomicReference();

    Main() {
    }

    private void publishOrPerish(Controller ctrl, Subsystem subsys, ExecutorService exec) {
        try {
            KeyValueData result = ctrl.getNextResult();
            this.statusCache.put(result.getKey(), result.getValue());
            subsys.publishSubsystemDataOnStatusBus(result);
            exec.submit(() -> this.publishOrPerish(ctrl, subsys, exec));
        }
        catch (InterruptedException ex) {
            return;
        }
    }

    protected void setAgentProperty(MotorplatformType type) {
        ((AgentPropertiesService)this.subsystem.getAgentService(AgentPropertiesService.class)).setAgentProperty("motorplatform.type", type.name());
    }

    protected void startPublicationThread() {
        this.platformConfiguration.set(((Controller)this.controller).getConfiguration());
        this.publisher = Executors.newSingleThreadExecutor();
        T ctrl = this.controller;
        Subsystem subsys = this.subsystem;
        ExecutorService exec = this.publisher;
        exec.submit(() -> this.publishOrPerish((Controller)ctrl, subsys, exec));
    }

    protected void shutdownPublicationThread() {
        this.publisher.shutdownNow();
    }

    @Command(autoAck=false, description="For Java/Jython code only. Enables or disables an axis.")
    public void changeAxisEnable(@Argument(name="cmd", description="An instance of ChangeAxisEnable.") ChangeAxisEnable cmd) {
        if (!this.checkOnlineFlag()) {
            return;
        }
        ((Controller)this.controller).changeAxisEnable(cmd);
        this.subsystem.sendAck(null);
    }

    @Command(autoAck=false, description="For Java/Jython code only. Change a motor controller output line state.")
    public void changeOutputLine(@Argument(name="cmd", description=")An instance of ChangeOutputLine.") ChangeOutputLine cmd) {
        if (!this.checkOnlineFlag()) {
            return;
        }
        ((Controller)this.controller).changeOutputLine(cmd);
        this.subsystem.sendAck(null);
    }

    @Command(autoAck=false, description="For Java/Jython code only. Attempt to clear all extant faults, general and axis.")
    public void clearAllFaults(@Argument(name="cmd", description="An instance of ClearAllFaults.") ClearAllFaults cmd) {
        if (!this.checkOnlineFlag()) {
            return;
        }
        ((Controller)this.controller).clearAllFaults(cmd);
        this.subsystem.sendAck(null);
    }

    @Command(autoAck=false, description="For Java/Jython code only. Attempt to clear the faults on a specific axis.")
    public void clearAxisFaults(@Argument(name="cmd", description="An instance of ClearAxisFaults.") ClearAxisFaults cmd) {
        if (!this.checkOnlineFlag()) {
            return;
        }
        ((Controller)this.controller).clearAxisFaults(cmd);
        this.subsystem.sendAck(null);
    }

    @Command(autoAck=false, description="For Java/Jython code only. Turn off data capture for subsequent motions.")
    public void clearCapture(@Argument(name="cmd", description="An instance of ClearCapture.") ClearCapture cmd) {
        if (!this.checkOnlineFlag()) {
            return;
        }
        ((Controller)this.controller).clearCapture(cmd);
        this.subsystem.sendAck(null);
    }

    @Command(autoAck=false, description="For Java/Jython code only. Enable the X and Y axes.")
    public void enableAllAxes(@Argument(name="cmd", description="An instance of EnableAllExes.") EnableAllAxes cmd) {
        if (!this.checkOnlineFlag()) {
            return;
        }
        ((Controller)this.controller).enableAllAxes(cmd);
    }

    @Command(autoAck=false, description="For Java/Jython code only. Move the axis to its low-end limit switch and set the axis position to zero.")
    public void homeAxis(@Argument(name="cmd", description="An instance of HomeAxis.") HomeAxis cmd) {
        if (!this.checkOnlineFlag()) {
            return;
        }
        ((Controller)this.controller).homeAxis(cmd);
        this.subsystem.sendAck(null);
    }

    @Command(autoAck=false, description="For Java/Jython code only. Change the axis position by the given amount in the given time.")
    public void moveAxisRelative(@Argument(name="cmd", description="An instance of MoveAxisRelative.") MoveAxisRelative cmd) {
        if (!this.checkOnlineFlag()) {
            return;
        }
        ((Controller)this.controller).moveAxisRelative(cmd);
        this.subsystem.sendAck(null);
    }

    @Command(autoAck=false, description="For Java/Jython code only. Move the axis to an absolute position at a given speed.")
    public void moveAxisAbsolute(@Argument(name="cmd", description="An instance of MoveAxisAbsolute.") MoveAxisAbsolute cmd) {
        if (!this.checkOnlineFlag()) {
            return;
        }
        ((Controller)this.controller).moveAxisAbsolute(cmd);
        this.subsystem.sendAck(null);
    }

    @Command(autoAck=false, level=0, description="For Java/Jython code only. Send an axis report on the status bus.")
    public void sendAxisStatus(@Argument(name="cmd", description="An instance of SendAxisStatus.") SendAxisStatus cmd) {
        if (!this.checkOnlineFlag()) {
            return;
        }
        ((Controller)this.controller).sendAxisStatus(cmd);
        this.subsystem.sendAck(null);
    }

    @Command(autoAck=false, level=0, description="For Java/Jython code only. Send the platform configuration on the status bus.")
    public void sendConfiguration(@Argument(name="cmd", description="An instance of SendConfiguration.") SendConfiguration cmd) {
        if (!this.checkOnlineFlag()) {
            return;
        }
        ((Controller)this.controller).sendConfiguration(cmd);
        this.subsystem.sendAck(null);
    }

    @Command(autoAck=false, level=0, description="For Java/Jython code only. Send a controller report on the status bus.")
    public void sendControllerStatus(@Argument(name="cmd", description="An instance of SendControllerStatus.") SendControllerStatus cmd) {
        if (!this.checkOnlineFlag()) {
            return;
        }
        ((Controller)this.controller).sendControllerStatus(cmd);
        this.subsystem.sendAck(null);
    }

    @Command(autoAck=false, description="For Java/Jython code only. Set up data capture for subsequent moves.")
    public void setupCapture(@Argument(name="cmd", description="An instance of SetupCapture.") SetupCapture cmd) {
        if (!this.checkOnlineFlag()) {
            return;
        }
        ((Controller)this.controller).setupCapture(cmd);
        this.subsystem.sendAck(null);
    }

    @Command(autoAck=false, description="For Java/Jython code only. Kill all motion on the platform.")
    public void stopAllMotion(@Argument(name="cmd", description="An instance of StopAllMotion.") StopAllMotion cmd) {
        if (!this.checkOnlineFlag()) {
            return;
        }
        ((Controller)this.controller).stopAllMotion(cmd);
        this.subsystem.sendAck(null);
    }

    protected boolean checkOnlineFlag() {
        if (!((Controller)this.controller).isOnline()) {
            this.subsystem.sendNack((Serializable)((Object)"Out of contact with device(s), see alert and log."));
            return false;
        }
        return true;
    }

    @Command(autoAck=false, description="Clear all axis and global controller faults.")
    public void clearFaults() {
        if (!this.checkOnlineFlag()) {
            return;
        }
        ((Controller)this.controller).clearAllFaults(new ClearAllFaults());
        this.subsystem.sendAck(null);
    }

    @Command(autoAck=false, description="Stop motion on all axes and discard queued commands.")
    public void stopAll() {
        if (!this.checkOnlineFlag()) {
            return;
        }
        ((Controller)this.controller).stopAllMotion(new StopAllMotion());
        this.subsystem.sendAck(null);
    }

    @Command(autoAck=false, description="Enable an axis.")
    public void enable(@Argument(name="axisName", description="The name of the axis.") String axisName) {
        if (!this.checkOnlineFlag()) {
            return;
        }
        ((Controller)this.controller).changeAxisEnable(new ChangeAxisEnable(this.checkAxis(axisName), true));
        this.subsystem.sendAck(null);
    }

    @Command(autoAck=false, description="Disable an axis.")
    public void disable(@Argument(name="axisName", description="The name of the axis.") String axisName) {
        if (!this.checkOnlineFlag()) {
            return;
        }
        ((Controller)this.controller).changeAxisEnable(new ChangeAxisEnable(this.checkAxis(axisName), false));
        this.subsystem.sendAck(null);
    }

    @Command(autoAck=false, description="Send an axis to its home position.")
    public void home(@Argument(name="axisName", description="The name of the axis.") String axisName) {
        if (!this.checkOnlineFlag()) {
            return;
        }
        ((Controller)this.controller).homeAxis(new HomeAxis(this.checkAxis(axisName)));
        this.subsystem.sendAck(null);
    }

    @Command(autoAck=false, description="Move an axis to a new absolute position.")
    public void moveTo(@Argument(name="axisName", description="The name of the axis.") String axisName, @Argument(name="newPosition", description="The target position in mm.") double newPosition, @Argument(name="speed", description="The top speed of the move in mm/sec. Default is 20.", defaultValue="20.0") double speed) {
        if (!this.checkOnlineFlag()) {
            return;
        }
        ((Controller)this.controller).moveAxisAbsolute(new MoveAxisAbsolute(this.checkAxis(axisName), newPosition, speed));
        this.subsystem.sendAck(null);
    }

    @Command(autoAck=false, description="Move an axis by a given amount from the position at the start of command execution.")
    public void moveBy(@Argument(name="axisName", description="The name of the axis.") String axisName, @Argument(name="positionChange", description="The desired coordinate change in mm.") double positionChange, @Argument(name="speed", description="The top speed of the move in mm/sec. Default is 20.", defaultValue="20.0") double speed) {
        if (!this.checkOnlineFlag()) {
            return;
        }
        double time = Math.abs(positionChange) / speed;
        ((Controller)this.controller).moveAxisRelative(new MoveAxisRelative(this.checkAxis(axisName), positionChange, Duration.ofMillis((long)(1000.0 * time))));
        this.subsystem.sendAck(null);
    }

    @Command(autoAck=false, type=Command.CommandType.QUERY, description="Get a short status report for an axis.")
    public String status(@Argument(name="axisName", description="The name of the axis.") String axisName) {
        if (!this.checkOnlineFlag()) {
            return "";
        }
        StringBuilder buff = new StringBuilder(1024);
        buff.append("Controller motion enable: %s%n");
        buff.append("Controller comm link: %s%n");
        buff.append("Axis %s%n");
        buff.append("Enabled %s, Moving %s, Homed %s, At Low %s, At High %s%n");
        buff.append("Position %9.3f%n");
        ControllerStatus ctlstat = (ControllerStatus)this.statusCache.get("ControllerStatus");
        AxisStatus axstat = (AxisStatus)this.statusCache.get("AxisStatus/" + this.checkAxis(axisName));
        if (ctlstat == null || axstat == null) {
            return "Not yet available.";
        }
        for (String fault : axstat.getFaults()) {
            buff.append(fault);
            buff.append("%n");
        }
        this.subsystem.sendAck(null);
        return String.format(buff.toString(), ctlstat.isMotionEnabled(), ctlstat.getCommLinkStatus(), axstat.getAxisName(), axstat.isEnabled(), axstat.isMoving(), axstat.isAtHome(), axstat.isAtLowLimit(), axstat.isAtHighLimit(), axstat.getPosition());
    }

    private String checkAxis(String axisName) {
        List legalNames = this.platformConfiguration.get().getAxisNames();
        Optional<String> match = legalNames.stream().filter(x -> x.equalsIgnoreCase(axisName)).findAny();
        if (match.isPresent()) {
            return match.get();
        }
        throw new IllegalArgumentException(String.format("Invalid axis name %s. The legal set is {%s}.", axisName, legalNames.stream().collect(Collectors.joining(", "))));
    }
}

