/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.motorplatform.bot;

import java.io.Serializable;
import java.util.Map;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystem.motorplatform.bot.LampController;
import org.lsst.ccs.subsystem.motorplatform.bot.Main;
import org.lsst.ccs.subsystem.motorplatform.bus.AxisStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.MotorplatformType;
import org.lsst.ccs.subsystem.motorplatform.bus.bot.LampStatus;
import org.lsst.ccs.utilities.logging.Logger;

public class LampMain
extends Main<LampController>
implements HasLifecycle {
    private static final Logger LOG = Logger.getLogger((String)LampMain.class.getName());
    private boolean haveLampOffsets = false;

    LampMain() {
    }

    public void postInit() {
        this.setAgentProperty(MotorplatformType.BOT_LAMP);
    }

    public void postStart() {
        this.startPublicationThread();
    }

    public void shutdown() {
        this.shutdownPublicationThread();
    }

    @Command(autoAck=false, description="Move the light source to the given position.")
    public void setLampPosition(@Argument(description="The position X in camera coords (mm).") double xcam, @Argument(description="The position Y in camera coords (mm).") double ycam) {
        if (!this.checkOnlineFlag()) {
            return;
        }
        if (!this.haveLampOffsets) {
            LOG.warning((Object)"Must set light source offsets before moving the source.");
            this.subsystem.sendNack((Serializable)((Object)"Haven't received lamp offset"));
            return;
        }
        LampStatus stat = (LampStatus)this.statusCache.get("LampStatus");
        AxisStatus xstat = (AxisStatus)this.statusCache.get("AxisStatus/X");
        AxisStatus ystat = (AxisStatus)this.statusCache.get("AxisStatus/Y");
        if (stat == null || xstat == null || ystat == null) {
            this.subsystem.sendNack((Serializable)((Object)"Full lamp & axis status info not yet available, motion canceled."));
            return;
        }
        if (stat.isMoving()) {
            this.subsystem.sendNack((Serializable)((Object)"Motion already in progress."));
            return;
        }
        if (!xstat.isEnabled() || !ystat.isEnabled()) {
            this.subsystem.sendNack((Serializable)((Object)"The axes must be enabled."));
            return;
        }
        boolean isRunning = ((LampController)this.controller).setLampPosition(xcam, ycam);
        if (isRunning) {
            this.subsystem.sendAck(null);
        } else {
            this.subsystem.sendNack((Serializable)((Object)"Command failed to start, see log."));
        }
    }

    @Command(description="Set offset of lamp center from stage position (BOT coordinates).")
    public void setLampOffset(@Argument(description="The X offset (mm).") double xoff_ls, @Argument(description="The Y offset (mm).") double yoff_ls) {
        this.haveLampOffsets = true;
        LOG.info((Object)String.format("Received lamp offsets (%s, %s).", xoff_ls, yoff_ls));
        ((LampController)this.controller).setLampOffset(xoff_ls, yoff_ls);
    }

    @Command(type=Command.CommandType.QUERY, description="Get lamp config. as a Map.")
    public Map<String, Double> getLampParameters() {
        return ((LampController)this.controller).getLampParameters();
    }

    @Command(autoAck=false, type=Command.CommandType.QUERY, description="Print the latest LampStatus.")
    public String lampStatus() {
        if (!this.checkOnlineFlag()) {
            return "";
        }
        Map<String, Double> parms = ((LampController)this.controller).getLampParameters();
        StringBuilder buf = new StringBuilder();
        for (String key : parms.keySet()) {
            buf.append(key);
            buf.append(": ");
            buf.append(parms.get(key));
            buf.append("\n");
        }
        LampStatus status = (LampStatus)this.statusCache.get("LampStatus");
        if (status == null) {
            buf.append("Lamp status not yet available.\n");
        } else {
            buf.append("xcam: ");
            buf.append(status.getXcam());
            buf.append("\nycam: ");
            buf.append(status.getYcam());
            buf.append("\nxbot: ");
            buf.append(status.getXbot());
            buf.append("\nybot: ");
            buf.append(status.getYbot());
            buf.append("\nisMoving: ");
            buf.append(status.isMoving());
            buf.append("\nhasFault: ");
            buf.append(status.hasFault());
            buf.append("\n");
        }
        this.subsystem.sendAck(null);
        return buf.toString();
    }
}

