/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.motorplatform.bot;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.SynchronousQueue;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.framework.HardwareController;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.subsystem.motorplatform.bot.Aerotech;
import org.lsst.ccs.subsystem.motorplatform.bot.Axis;
import org.lsst.ccs.subsystem.motorplatform.bot.Controller;
import org.lsst.ccs.subsystem.motorplatform.bot.QCommand;
import org.lsst.ccs.subsystem.motorplatform.bus.AxisStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.ControllerStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.IOStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.MotorCommandListener;
import org.lsst.ccs.subsystem.motorplatform.bus.bot.LampStatus;

public class LampController
extends Controller
implements MotorCommandListener,
HardwareController {
    @ConfigurationParameter(description="Camera coordinate of BOT X=0 (mm).")
    private volatile double xcam0 = 0.0;
    @ConfigurationParameter(description="Camera coordinate of BOT Y=0 (mm).")
    private volatile double ycam0 = 0.0;
    @ConfigurationParameter(description="The rotation angle from camera to BOT axes (rad).")
    private volatile double phi = Math.PI;
    private volatile double xoff_ls = 0.0;
    private volatile double yoff_ls = 0.0;
    private volatile QCommand currentCommand;

    private LampController() {
    }

    @Override
    public void commandTaskBody() {
        try {
            this.commandTaskCore();
        }
        catch (DriverException exc) {
            this.flagDevicesOffline((Exception)((Object)exc));
            this.cancelQueuedCommands();
        }
        catch (InterruptedException exc) {
            LOG.warning((Object)"Command task was interrupted.");
        }
        catch (Exception exc) {
            LOG.error((Object)"Unexpected exception in command task.", (Throwable)exc);
        }
    }

    private void commandTaskCore() throws Exception {
        QCommand newCmd;
        QCommand.Disposition disp;
        if (this.currentCommand != null && (disp = this.currentCommand.update()) != QCommand.Disposition.RUNNING) {
            this.currentCommand = null;
            if (disp != QCommand.Disposition.FINISHED) {
                this.cancelQueuedCommands();
            }
        }
        if (this.currentCommand == null && (newCmd = (QCommand)this.commandDeque.poll()) != null) {
            try {
                disp = newCmd.run();
            }
            catch (Exception exc) {
                newCmd.cancel();
                throw exc;
            }
            if (disp == QCommand.Disposition.RUNNING) {
                this.currentCommand = newCmd;
            } else if (disp == QCommand.Disposition.FINISHED) {
                this.currentCommand = null;
            } else {
                newCmd.cancel();
                this.cancelQueuedCommands();
            }
        }
    }

    @Override
    protected void statusTaskBody() {
        try {
            this.publishAll();
        }
        catch (Aerotech.CommandFailureException exc) {
            this.aeroLogFailure(exc);
        }
        catch (DriverException exc) {
            this.flagDevicesOffline((Exception)((Object)exc));
            this.cancelQueuedCommands();
        }
        catch (InterruptedException exc) {
            LOG.warning((Object)"Status task was interrupted.");
        }
        catch (Exception exc) {
            LOG.error((Object)"Unexpected exception in status task.", (Throwable)exc);
        }
    }

    @Override
    protected void publishOtherStatus(Aerotech aero, ControllerStatus ctrlStat, IOStatus ioStat, Map<String, AxisStatus> axisStat) throws Exception {
        AxisStatus xstat = axisStat.get("X");
        AxisStatus ystat = axisStat.get("Y");
        if (xstat == null || ystat == null) {
            LOG.warning((Object)"Unable to determine lamp status - missing axis status.");
        } else {
            boolean isMoving = !this.controllerIsIdle(aero);
            boolean hasFaults = !xstat.getFaults().isEmpty() || !ystat.getFaults().isEmpty();
            double xbot = xstat.getPosition();
            double ybot = ystat.getPosition();
            List<Double> xycam = this.botToCamera(xbot, ybot);
            LampStatus lstat = new LampStatus(xycam.get(0).doubleValue(), xycam.get(1).doubleValue(), xbot, ybot, isMoving, hasFaults);
            this.resultQueue.add(new KeyValueData("LampStatus", (Serializable)lstat));
        }
    }

    @Override
    protected void commTaskBody() {
        if (!this.onlineFlag) {
            this.aeroLink.close();
            try {
                this.aeroInit();
                this.flagDevicesOnline();
            }
            catch (Aerotech.CommandFailureException exc) {
                this.aeroLogFailure(exc);
            }
            catch (DriverException exc) {
                LOG.error((Object)exc);
            }
            catch (Exception exc) {
                LOG.error((Object)"Unexpected exception in comm task.", (Throwable)exc);
            }
        }
    }

    public TreeWalkerDiag checkHardware() throws HardwareException {
        this.initComponentStructure();
        try {
            this.aeroInit();
        }
        catch (DriverException exc) {
            throw new HardwareException(true, (Throwable)exc);
        }
        this.onlineFlag = true;
        this.startTasks();
        return TreeWalkerDiag.GO;
    }

    public void checkStopped() throws HardwareException {
        this.stopTasks();
        try {
            if (this.onlineFlag) {
                this.aeroStop();
            }
        }
        catch (DriverException exc) {
            throw new HardwareException(false, (Throwable)exc);
        }
    }

    public Map<String, Double> getLampParameters() {
        HashMap<String, Double> parms = new HashMap<String, Double>(5);
        parms.put("xcam0", this.xcam0);
        parms.put("ycam0", this.ycam0);
        parms.put("phi", this.phi);
        parms.put("xoff_ls", this.xoff_ls);
        parms.put("yoff_ls", this.yoff_ls);
        return Collections.unmodifiableMap(parms);
    }

    public boolean setLampPosition(double xcam, double ycam) {
        List<Double> xybot = this.cameraToBot(xcam, ycam);
        Axis xaxis = this.getAxis("X");
        Axis yaxis = this.getAxis("Y");
        double diag = Math.hypot(xaxis.getMaxTravel(), yaxis.getMaxTravel());
        double vdiag = 0.95 * Math.hypot(xaxis.getMaxSpeed(), yaxis.getMaxSpeed());
        final Duration timeout = Duration.ofMillis(Math.round(1000.0 * (2.0 + diag / vdiag)));
        Aerotech.Target[] targets = new Aerotech.Target[]{new Aerotech.Target("X", xybot.get(0)), new Aerotech.Target("Y", xybot.get(1))};
        final SynchronousQueue startFlag = new SynchronousQueue();
        this.commandDeque.add(new AeroLinearCommand(vdiag, targets){

            @Override
            public Duration timeLimit() {
                return timeout;
            }

            @Override
            public void cancel() {
                startFlag.add(false);
            }

            @Override
            public void action() throws Exception {
                LampController.this.aeroLink.setWaitMode(Aerotech.WaitMode.NOWAIT);
                LampController.this.aeroLink.setPlane(0);
                LampController.this.aeroLink.setRampMode(Aerotech.RampMode.RATE);
                LampController.this.aeroLink.setRampRate(this.speed * 10.0);
                LampController.this.aeroLink.setPositioningMode(Aerotech.PositioningMode.ABS);
                LampController.this.aeroLink.moveLinear(this.speed, this.targets);
                startFlag.add(true);
            }
        });
        try {
            return (Boolean)startFlag.take();
        }
        catch (InterruptedException exc) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public void setLampOffset(double xoff_ls, double yoff_ls) {
        this.xoff_ls = xoff_ls;
        this.yoff_ls = yoff_ls;
    }

    private List<Double> cameraToBot(double xcam, double ycam) {
        double xbot = (xcam - this.xcam0) * Math.cos(this.phi) + (ycam - this.ycam0) * Math.sin(this.phi) - this.xoff_ls;
        double ybot = -(xcam - this.xcam0) * Math.sin(this.phi) + (ycam - this.ycam0) * Math.cos(this.phi) - this.yoff_ls;
        return Collections.unmodifiableList(Arrays.asList(xbot, ybot));
    }

    private List<Double> botToCamera(double xbot, double ybot) {
        double xcam = (xbot + this.xoff_ls) * Math.cos(this.phi) - (ybot + this.yoff_ls) * Math.sin(this.phi) + this.xcam0;
        double ycam = (xbot + this.xoff_ls) * Math.sin(this.phi) + (ybot + this.yoff_ls) * Math.cos(this.phi) + this.ycam0;
        return Collections.unmodifiableList(Arrays.asList(xcam, ycam));
    }

    private abstract class AeroLinearCommand
    implements QCommand {
        protected Instant deadline;
        protected final Aerotech.Target[] targets;
        protected final double speed;

        public abstract void action() throws Exception;

        public abstract Duration timeLimit() throws Exception;

        public AeroLinearCommand(double speed, Aerotech.Target ... targets) {
            this.speed = speed;
            this.targets = targets;
        }

        @Override
        public String device() {
            return "Aerotech";
        }

        @Override
        public QCommand.Disposition run() throws Exception {
            this.deadline = Instant.now().plus(this.timeLimit());
            LampController.this.aeroActionStatus = "RUNNING";
            try {
                this.action();
                return QCommand.Disposition.RUNNING;
            }
            catch (Aerotech.CommandFailureException exc) {
                LampController.this.aeroLogFailure(exc);
                LampController.this.aeroActionStatus = "FAILED";
                this.cancel();
                return QCommand.Disposition.FAILED;
            }
        }

        @Override
        public QCommand.Disposition update() throws Exception {
            try {
                return this.updateAction();
            }
            catch (Aerotech.CommandFailureException exc) {
                LampController.this.aeroLogFailure(exc);
                LampController.this.aeroActionStatus = "FAILED";
                return QCommand.Disposition.FAILED;
            }
        }

        public QCommand.Disposition updateAction() throws Exception {
            boolean idle = LampController.this.controllerIsIdle(LampController.this.aeroLink);
            if (idle) {
                boolean faults = false;
                for (Aerotech.Target t : this.targets) {
                    faults = faults || LampController.this.getAxis(t.axisName).hasFaults(LampController.this.aeroLink);
                }
                if (faults) {
                    LampController.this.aeroActionStatus = "FAILED";
                    Controller.LOG.warning((Object)"Axis faults seen after Aerotech LINEAR command finished.");
                    return QCommand.Disposition.FAILED;
                }
                LampController.this.aeroActionStatus = "OK";
                return QCommand.Disposition.FINISHED;
            }
            if (Instant.now().isAfter(this.deadline)) {
                LampController.this.aeroActionStatus = "TIMEOUT";
                Controller.LOG.warning((Object)"Aerotech LINEAR command took too long to finish.");
                LampController.this.aeroStopMotion();
                return QCommand.Disposition.TIMED_OUT;
            }
            return QCommand.Disposition.RUNNING;
        }
    }
}

