/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.motorplatform.bot;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystem.motorplatform.bot.ChatDriver;
import org.lsst.ccs.utilities.logging.Logger;

public class Keyence
implements ChatDriver {
    private static final Logger LOG = Logger.getLogger((String)Keyence.class.getName());
    private static final int timeout = 1000;
    public static final int DEFAULT_BAUD = 38400;
    public static final String DEFAULT_DEV = "/dev/ttyS1";
    private static final Map<Integer, String> errors;
    private final Ascii driver;

    public Keyence(Ascii driver) {
        this.driver = driver;
    }

    public synchronized void open(String ident, int baud) throws DriverException {
        this.driver.openSerial(ident, baud == 0 ? 38400 : baud);
        this.driver.setTimeout(1000);
        this.driver.setTerminator(Ascii.Terminator.CR);
    }

    public synchronized void close() {
        this.driver.closeSilent();
    }

    public synchronized Reply sendCommand(String command) throws DriverException {
        String[] text;
        String cmdName;
        int statusCode = 0;
        String[] splitCommand = command.split(",");
        String[] splitReply = this.driver.read(command).split(",");
        if (splitReply[0].equals(cmdName = splitCommand[0].toUpperCase())) {
            text = Arrays.copyOfRange(splitReply, splitCommand.length, splitReply.length);
        } else if (splitReply[0].equals("ER")) {
            statusCode = Integer.parseInt(splitReply[splitReply.length - 1]);
            text = splitReply;
        } else {
            statusCode = 99;
            text = splitReply;
        }
        Reply result = new Reply(statusCode, text, command);
        if (statusCode != 0) {
            throw new CommandFailureException(result);
        }
        return result;
    }

    private Reply sendCommand(String command, int ikey, String arg) throws DriverException {
        return this.sendCommand(String.format("%s,%02d,%s", command, ikey, arg));
    }

    @Override
    public String sendCommandRaw(String command) throws DriverException {
        return this.driver.read(command);
    }

    public Reply laser(boolean laserstate) throws DriverException {
        if (laserstate) {
            return this.genmode();
        }
        return this.commmode();
    }

    public Reply commmode() throws DriverException {
        try {
            return this.sendCommand("Q0");
        }
        catch (CommandFailureException exc) {
            if (exc.reply.statusCode != 51) {
                throw exc;
            }
            return exc.reply;
        }
    }

    public Reply genmode() throws DriverException {
        try {
            return this.sendCommand("R0");
        }
        catch (CommandFailureException exc) {
            if (exc.reply.statusCode == 51) {
                throw exc;
            }
            return exc.reply;
        }
    }

    public Reply setnsamps(int cycle) throws DriverException {
        return this.sendCommand("SW,CA," + cycle);
    }

    public Reply getnsamps() throws DriverException {
        return this.sendCommand("SR,CA");
    }

    public Reply setmeasmode(int ikey, int mode) throws DriverException {
        return this.sendCommand("SW,HB,M", ikey, String.valueOf(mode));
    }

    public Reply getmeasmode(int ikey) throws DriverException {
        return this.sendCommand("SR,HB,M," + ikey);
    }

    public Reply setmindispunit(int ikey, int dspu) throws DriverException {
        return this.sendCommand("SW,OG", ikey, String.valueOf(dspu));
    }

    public Reply getmindispunit(int ikey) throws DriverException {
        return this.sendCommand("SR,OG," + ikey);
    }

    public Reply readDistance(int ikey) throws DriverException {
        return this.sendCommand("MS," + ikey);
    }

    public Reply readDistance() throws DriverException {
        return this.sendCommand("MA");
    }

    @Override
    public void setReplyTimeout(int millis) throws DriverException {
        this.driver.setTimeout(millis);
    }

    static {
        HashMap<Integer, String> tmp = new HashMap<Integer, String>();
        tmp.put(0, "OK");
        tmp.put(50, "Command error");
        tmp.put(51, "Status error");
        tmp.put(60, "Command length error");
        tmp.put(61, "Parameter count error");
        tmp.put(62, "Parameter range error");
        tmp.put(63, "Parameter range error (OUT calculation count)");
        tmp.put(64, "Parameter range error (OUT or head number)");
        tmp.put(65, "Parameter range error (OUT for veloc/accn)");
        tmp.put(66, "Parameter range error (OUT recursive)");
        tmp.put(67, "Parameter range error (cycle too fast)");
        tmp.put(68, "Parameter range error (scaling)");
        tmp.put(69, "Parameter range error (analog output scaling)");
        tmp.put(70, "Parameter range error (number of data points)");
        tmp.put(71, "Parameter range error (OUT too large)");
        tmp.put(88, "Timeout error");
        tmp.put(99, "Other error");
        errors = Collections.unmodifiableMap(tmp);
    }

    public static class Reply {
        public final int statusCode;
        public final String statusString;
        public final String[] text;
        public final String command;
        private static final Set<String> normalBad = new HashSet<String>(Arrays.asList("-FFFFFFF", "+FFFFFFF", "XXXXXXXX"));

        public double[] asDoubles() {
            double[] result = new double[this.text.length];
            for (int i = 0; i < this.text.length; ++i) {
                try {
                    result[i] = Double.parseDouble(this.text[i]);
                    continue;
                }
                catch (NumberFormatException exc) {
                    result[i] = Double.NaN;
                    if (normalBad.contains(this.text[i])) continue;
                    LOG.warning((Object)String.format("Keyence error: Can't convert the reply text '%s' to double.", this.text[i]));
                }
            }
            return result;
        }

        public int[] asInts() {
            int nskip = this.command.split(",").length;
            int[] result = new int[this.text.length];
            for (int i = 0; i < this.text.length; ++i) {
                try {
                    result[i] = Integer.parseInt(this.text[i]);
                    continue;
                }
                catch (NumberFormatException exc) {
                    result[i] = Integer.MAX_VALUE;
                    LOG.warning((Object)String.format("Keyence error. Can't convert the reply text '%s' to int.", this.text[i]));
                }
            }
            return result;
        }

        Reply(int statusCode, String[] text, String command) {
            this.statusCode = statusCode;
            this.statusString = errors.getOrDefault(statusCode, "Unknown error");
            this.text = text;
            this.command = command;
        }
    }

    public static class CommandFailureException
    extends DriverException {
        public final Reply reply;

        CommandFailureException(Reply reply) {
            super("Keyence error: " + reply.statusString);
            this.reply = reply;
        }
    }
}

