/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.motorplatform.bot;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.motorplatform.bot.Aerotech;
import org.lsst.ccs.subsystem.motorplatform.bot.AnalogInput;
import org.lsst.ccs.subsystem.motorplatform.bot.Axis;
import org.lsst.ccs.subsystem.motorplatform.bot.ChatDriver;
import org.lsst.ccs.subsystem.motorplatform.bot.DigitalInput;
import org.lsst.ccs.subsystem.motorplatform.bot.DigitalOutput;
import org.lsst.ccs.subsystem.motorplatform.bot.QCommand;
import org.lsst.ccs.subsystem.motorplatform.bus.AxisStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.ChangeAxisEnable;
import org.lsst.ccs.subsystem.motorplatform.bus.ChangeOutputLine;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAllFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAxisFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearCapture;
import org.lsst.ccs.subsystem.motorplatform.bus.ControllerStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.EnableAllAxes;
import org.lsst.ccs.subsystem.motorplatform.bus.HomeAxis;
import org.lsst.ccs.subsystem.motorplatform.bus.IOStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.MotorCommandListener;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisAbsolute;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisRelative;
import org.lsst.ccs.subsystem.motorplatform.bus.PlatformConfig;
import org.lsst.ccs.subsystem.motorplatform.bus.SendAxisStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.SendConfiguration;
import org.lsst.ccs.subsystem.motorplatform.bus.SendControllerStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.SetupCapture;
import org.lsst.ccs.subsystem.motorplatform.bus.StopAllMotion;
import org.lsst.ccs.utilities.logging.Logger;

public abstract class Controller
implements MotorCommandListener {
    protected static final Logger LOG = Logger.getLogger((String)Controller.class.getName());
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected Subsystem subsys;
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected AlertService alerts;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    protected List<Axis> axisComponents = Collections.synchronizedList(new ArrayList());
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    protected List<DigitalInput> digitalIns = Collections.synchronizedList(new ArrayList());
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    protected List<DigitalOutput> digitalOuts = Collections.synchronizedList(new ArrayList());
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    protected List<AnalogInput> analogs = Collections.synchronizedList(new ArrayList());
    @ConfigurationParameter(description="The name of the configuration used.")
    protected volatile String configurationName = "<safe default>";
    @ConfigurationParameter(description="How often to check for the completion of a long-running operation such as a move.")
    protected volatile Duration completionCheckInterval = Duration.ofMillis(10L);
    @ConfigurationParameter(description="The timeout to use for simple actions that don't cause motion.")
    protected volatile Duration briefActionTimeout = Duration.ofMillis(10L);
    @ConfigurationParameter(description="The IP address of the motor controller.")
    protected volatile String IPv4Address = "192.168.10.40";
    @ConfigurationParameter(description="The interval between periodic status updates.")
    protected volatile Duration statusUpdateInterval = Duration.ofSeconds(1L);
    @ConfigurationParameter(description="How long to wait for a reply to a chat command.")
    protected volatile Duration chatTimeout = Duration.ofSeconds(300L);
    @ConfigurationParameter(description="The interval between device comm checks.")
    protected volatile Duration commCheckInterval = Duration.ofSeconds(10L);
    protected volatile Map<String, Axis> axisMap;
    protected final ScheduledExecutorService taskExec = Executors.newSingleThreadScheduledExecutor();
    protected volatile Aerotech aeroLink;
    protected final BlockingQueue<KeyValueData> resultQueue = new ArrayBlockingQueue<KeyValueData>(1000);
    protected volatile String aeroCommStatus = "DOWN";
    protected volatile String aeroActionStatus = "STOPPED";
    protected final BlockingDeque<QCommand> commandDeque = new LinkedBlockingDeque<QCommand>(1000);
    protected volatile boolean onlineFlag = false;
    protected static final String AEROTECH_DEVICE = "Aerotech";
    protected final int AEROTECH_PORT = 8000;
    protected static final Pattern chatTimeoutPattern = Pattern.compile("^\\s*CHAT\\s+TIMEOUT\\s+(\\d+|DEFAULT)\\s*$", 2);
    protected volatile Alert COMM_ALERT;

    protected abstract void commandTaskBody();

    protected abstract void statusTaskBody();

    protected abstract void commTaskBody();

    protected abstract void publishOtherStatus(Aerotech var1, ControllerStatus var2, IOStatus var3, Map<String, AxisStatus> var4) throws Exception;

    protected void initComponentStructure() {
        this.axisMap = new TreeMap<String, Axis>();
        for (Axis a : this.axisComponents) {
            this.axisMap.put(a.getName(), a);
        }
        this.digitalIns.sort((x, y) -> Integer.compare(x.getOrder(), y.getOrder()));
        this.digitalOuts.sort((x, y) -> Integer.compare(x.getOrder(), y.getOrder()));
        this.analogs.sort((x, y) -> Integer.compare(x.getOrder(), y.getOrder()));
    }

    protected void startTasks() {
        this.taskExec.scheduleAtFixedRate(this::statusTaskBody, 0L, this.statusUpdateInterval.toMillis(), TimeUnit.MILLISECONDS);
        this.taskExec.scheduleAtFixedRate(this::commTaskBody, 0L, this.commCheckInterval.toMillis(), TimeUnit.MILLISECONDS);
        this.taskExec.scheduleAtFixedRate(this::commandTaskBody, 0L, this.completionCheckInterval.toMillis(), TimeUnit.MILLISECONDS);
    }

    protected void stopTasks() {
        this.onlineFlag = false;
        this.cancelQueuedCommands();
        this.taskExec.shutdown();
    }

    protected void aeroInit() throws DriverException {
        Ascii link = new Ascii();
        link.openNet(this.IPv4Address, 8000);
        this.aeroLink = new Aerotech(link, Aerotech.ErrorHandling.THROW_EXCEPTIONS);
        this.aeroCommStatus = "UP";
        this.aeroActionStatus = "NONE";
        this.aeroLink.clearAllFaults();
    }

    protected void aeroStop() throws DriverException {
        this.aeroCommStatus = "DOWN";
        this.aeroActionStatus = "STOPPED";
        this.aeroStopMotion();
    }

    protected void aeroStopMotion() throws DriverException {
        LOG.warning((Object)"Stopping motion on Aerotech device.");
        this.aeroLink.stopProgram(1);
        String[] names = new String[this.axisMap.size()];
        this.aeroLink.abortAxes(this.axisMap.keySet().toArray(names));
    }

    @Command(description="Executes an Aerotech command and returns the result string.", level=1, timeout=3600, autoAck=false)
    public String aerotechChat(final @Argument(name="command", description="The Aerotech command.") String cmdText) {
        if (!this.onlineFlag) {
            this.subsys.sendNack((Serializable)((Object)"One or more devices offline"));
        }
        final SynchronousQueue response = new SynchronousQueue();
        QCommand cmd = new QCommand(){

            @Override
            public String device() {
                return Controller.AEROTECH_DEVICE;
            }

            @Override
            public QCommand.Disposition run() {
                return Controller.this.chatBody(Controller.this.aeroLink, cmdText, response);
            }

            @Override
            public QCommand.Disposition update() {
                return QCommand.Disposition.FINISHED;
            }
        };
        this.commandDeque.add(cmd);
        this.subsys.sendAck(null);
        try {
            return (String)response.take();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return "ERROR: INTERRUPTED";
        }
    }

    protected <T extends ChatDriver> QCommand.Disposition chatBody(T driver, String command, SynchronousQueue<String> result) {
        Matcher m = chatTimeoutPattern.matcher(command);
        try {
            if (m.matches()) {
                if (m.group(1).toUpperCase().equals("DEFAULT")) {
                    driver.setReplyTimeout((int)this.chatTimeout.toMillis());
                } else {
                    driver.setReplyTimeout(1000 * Integer.valueOf(m.group(1)));
                }
                result.put("DONE");
            } else {
                String reply = driver.sendCommandRaw(command);
                result.put(reply);
            }
            return QCommand.Disposition.FINISHED;
        }
        catch (DriverTimeoutException exc) {
            try {
                result.put("ERROR: READ TIMEOUT");
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return QCommand.Disposition.TIMED_OUT;
        }
        catch (DriverException exc) {
            try {
                result.put("ERROR: ASCII DRIVER EXCEPTION " + exc.getMessage());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return QCommand.Disposition.FAILED;
        }
        catch (NumberFormatException exc) {
            try {
                result.put("ERROR: BAD NUMBER");
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return QCommand.Disposition.FAILED;
        }
        catch (InterruptedException exc) {
            result.offer("ERROR: INTERRUPTED");
            return QCommand.Disposition.FAILED;
        }
        catch (Exception exc) {
            try {
                result.put("ERROR: EXCEPTION " + exc.getMessage());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return QCommand.Disposition.FAILED;
        }
    }

    protected void aeroLogFailure(Aerotech.CommandFailureException exc) {
        LOG.warning((Object)exc.getMessage());
        LOG.warning((Object)String.format("%s. Command = %s.", exc.reply.status.message, exc.reply.command));
    }

    public void changeAxisEnable(final ChangeAxisEnable cmd) {
        final Axis axis = this.getAxis(cmd.getAxisName());
        AeroShortCommand qcmd = new AeroShortCommand(){

            @Override
            public void action() throws Exception {
                if (cmd.isEnabled()) {
                    axis.enable(Controller.this.aeroLink);
                } else {
                    axis.disable(Controller.this.aeroLink);
                }
            }
        };
        this.commandDeque.add(qcmd);
    }

    public void changeOutputLine(final ChangeOutputLine cmd) {
        this.commandDeque.add(new AeroShortCommand(){

            @Override
            public void action() throws Exception {
                DigitalOutput out = Controller.this.digitalOuts.get(cmd.getLineIndex());
                out.setState(Controller.this.aeroLink, cmd.getNewState());
            }
        });
    }

    public void clearAllFaults(ClearAllFaults cmd) {
        this.commandDeque.add(new AeroShortCommand(){

            @Override
            public void action() throws Exception {
                Controller.this.aeroLink.clearAllFaults();
            }
        });
    }

    public void clearAxisFaults(ClearAxisFaults cmd) {
        final Axis axis = this.getAxis(cmd.getAxisName());
        this.commandDeque.add(new AeroShortCommand(){

            @Override
            public void action() throws Exception {
                axis.clearFaults(Controller.this.aeroLink);
            }
        });
    }

    public void clearCapture(ClearCapture cmd) {
    }

    public void enableAllAxes(EnableAllAxes cmd) {
        this.commandDeque.add(new AeroShortCommand(){

            @Override
            public void action() throws Exception {
                for (String name : Controller.this.axisMap.keySet()) {
                    Controller.this.axisMap.get(name).enable(Controller.this.aeroLink);
                }
            }
        });
    }

    public void moveAxisRelative(final MoveAxisRelative cmd) {
        this.commandDeque.add(new AeroOneAxisCommand(this.getAxis(cmd.getAxisName())){

            @Override
            public Duration timeLimit() throws Exception {
                return this.axis.getRelativeMoveTimeout(cmd);
            }

            @Override
            public void action() throws Exception {
                this.axis.moveRelative(Controller.this.aeroLink, cmd);
            }
        });
    }

    public void moveAxisAbsolute(final MoveAxisAbsolute cmd) {
        this.commandDeque.add(new AeroOneAxisCommand(this.getAxis(cmd.getAxisName())){

            @Override
            public Duration timeLimit() {
                return this.axis.getAbsoluteMoveTimeout(cmd);
            }

            @Override
            public void action() throws Exception {
                this.axis.moveAbsolute(Controller.this.aeroLink, cmd);
            }
        });
    }

    public void homeAxis(HomeAxis cmd) {
        Axis axis = this.getAxis(cmd.getAxisName());
        this.commandDeque.add(new AeroOneAxisCommand(axis){

            @Override
            public Duration timeLimit() throws Exception {
                return this.axis.getHomingTimeout();
            }

            @Override
            public int completionCode() {
                return 0;
            }

            @Override
            public void action() throws Exception {
                this.axis.home(Controller.this.aeroLink);
            }
        });
    }

    public void sendAxisStatus(SendAxisStatus cmd) {
        this.scheduleAxisStatus(new HashSet<String>(Arrays.asList(cmd.getAxisName())));
    }

    public void sendConfiguration(SendConfiguration cmd) {
        PlatformConfig config = this.getConfiguration();
        this.resultQueue.add(new KeyValueData("PlatformConfig", (Serializable)config));
    }

    public PlatformConfig getConfiguration() {
        ArrayList<Axis> axes = new ArrayList<Axis>(this.axisComponents);
        axes.sort((x, y) -> Integer.compare(x.getIndex(), y.getIndex()));
        ArrayList<DigitalInput> dins = new ArrayList<DigitalInput>(this.digitalIns);
        dins.sort((x, y) -> Integer.compare(x.getOrder(), y.getOrder()));
        ArrayList<DigitalOutput> douts = new ArrayList<DigitalOutput>(this.digitalOuts);
        douts.sort((x, y) -> Integer.compare(x.getOrder(), y.getOrder()));
        ArrayList<AnalogInput> ains = new ArrayList<AnalogInput>(this.analogs);
        ains.sort((x, y) -> Integer.compare(x.getOrder(), y.getOrder()));
        PlatformConfig config = new PlatformConfig(axes.stream().map(Axis::getName).collect(Collectors.toList()), Collections.emptyList(), dins.stream().map(DigitalInput::getName).collect(Collectors.toList()), douts.stream().map(DigitalOutput::getName).collect(Collectors.toList()), ains.stream().map(AnalogInput::getDescription).collect(Collectors.toList()), this.configurationName, axes.stream().map(Axis::getUnits).collect(Collectors.toList()));
        return config;
    }

    public void sendControllerStatus(SendControllerStatus cmd) {
        this.scheduleControllerStatus();
    }

    public void setupCapture(SetupCapture cmd) {
    }

    public void stopAllMotion(StopAllMotion cmd) {
        this.cancelQueuedCommands();
        this.commandDeque.add(new AeroShortCommand(){

            @Override
            public void action() throws Exception {
                Controller.this.aeroStopMotion();
            }
        });
    }

    private IOStatus publishIOStatus(Aerotech aero) throws DriverException {
        String axis;
        int dins = 0;
        int douts = 0;
        ArrayList<Double> anas = new ArrayList<Double>();
        for (DigitalInput digi : this.digitalIns) {
            axis = digi.getAxis().getName();
            dins <<= 1;
            dins |= aero.readDigitalInput(axis, digi.getPort(), digi.getBit()).asInt();
        }
        for (AnalogInput ana : this.analogs) {
            axis = ana.getAxis().getName();
            int chan = ana.getChannel();
            anas.add(aero.readAnalogInput(axis, chan).asDouble());
        }
        IOStatus ioStat = new IOStatus(dins, douts, anas);
        this.resultQueue.add(new KeyValueData("IOStatus", (Serializable)ioStat));
        return ioStat;
    }

    private void scheduleControllerStatus() {
        this.commandDeque.add(new AeroShortCommand(){

            @Override
            public void action() throws Exception {
                Controller.this.publishControllerStatus(Controller.this.aeroLink);
            }
        });
    }

    private ControllerStatus publishControllerStatus(Aerotech aero) throws Exception {
        ControllerStatus status = new ControllerStatus(this.aeroCommStatus, true, this.aeroActionStatus);
        this.resultQueue.add(new KeyValueData("ControllerStatus", (Serializable)status));
        return status;
    }

    protected void publishAll() throws Exception {
        ControllerStatus ctrlStat = null;
        IOStatus ioStat = null;
        Map<String, AxisStatus> axisStat = Collections.emptyMap();
        ctrlStat = this.publishControllerStatus(this.aeroLink);
        ioStat = this.publishIOStatus(this.aeroLink);
        axisStat = this.publishAxisStatus(this.aeroLink, this.axisMap.keySet());
        this.publishOtherStatus(this.aeroLink, ctrlStat, ioStat, axisStat);
    }

    private void scheduleAxisStatus(final Set<String> axisNames) {
        this.commandDeque.add(new AeroShortCommand(){

            @Override
            public void action() throws Exception {
                Controller.this.publishAxisStatus(Controller.this.aeroLink, axisNames);
            }
        });
    }

    private Map<String, AxisStatus> publishAxisStatus(Aerotech aero, Set<String> axisNames) throws DriverException {
        HashMap<String, AxisStatus> statusMap = new HashMap<String, AxisStatus>();
        for (String axisName : axisNames) {
            Axis axis = this.getAxis(axisName);
            String key = String.format("AxisStatus/%s", axisName);
            AxisStatus status = axis.getStatus(this.aeroLink);
            statusMap.put(axisName, status);
            this.resultQueue.add(new KeyValueData(key, (Serializable)status));
        }
        return statusMap;
    }

    protected boolean controllerIsIdle(Aerotech aero) throws DriverException {
        TaskState state = TaskState.values()[aero.readTaskState(1).asInt()];
        int planeStat = aero.readPlaneStatus(0).asInt();
        return state != TaskState.RUNNING && state != TaskState.PAUSED && planeStat == 0;
    }

    protected Axis getAxis(String name) throws IllegalArgumentException {
        Axis axis = this.axisMap.get(name);
        if (axis == null) {
            throw new IllegalArgumentException(String.format("%s is a bad axis name.", name));
        }
        return axis;
    }

    protected boolean checkEstop(Aerotech aero) throws DriverException {
        for (Axis ax : this.axisMap.values()) {
            if (!ax.hasESTOP(aero)) continue;
            return true;
        }
        return false;
    }

    public KeyValueData getNextResult() throws InterruptedException {
        return this.resultQueue.take();
    }

    protected void flagDevicesOffline(Exception exc) {
        LOG.error((Object)"Device(s) are off line.", (Throwable)exc);
        this.onlineFlag = false;
        if (this.COMM_ALERT == null) {
            this.COMM_ALERT = new Alert("COMM_STATUS", "Device(s) offline.");
        }
        this.alerts.raiseAlert(this.COMM_ALERT, AlertState.ALARM, exc.getMessage());
    }

    protected void flagDevicesOnline() {
        LOG.info((Object)"Device(s) back on line.");
        this.onlineFlag = true;
        this.alerts.raiseAlert(this.COMM_ALERT, AlertState.NOMINAL, "Device(s) are back on line.");
    }

    protected void cancelQueuedCommands() {
        LOG.warning((Object)"Canceling all queued commands.");
        LinkedList cmds = new LinkedList();
        this.commandDeque.drainTo(cmds);
        for (QCommand c : cmds) {
            c.cancel();
        }
    }

    protected boolean isOnline() {
        return this.onlineFlag;
    }

    protected static enum TaskState {
        INACTIVE,
        IDLE,
        READY,
        RUNNING,
        PAUSED,
        COMPLETE,
        ERROR;

    }

    protected abstract class AeroOneAxisCommand
    implements QCommand {
        protected Instant deadline;
        protected final Axis axis;

        public abstract void action() throws Exception;

        public abstract Duration timeLimit() throws Exception;

        public int completionCode() throws Exception {
            return this.axis.getMoveCompletionCode(Controller.this.aeroLink);
        }

        public AeroOneAxisCommand(Axis axis) {
            this.axis = axis;
        }

        @Override
        public String device() {
            return Controller.AEROTECH_DEVICE;
        }

        @Override
        public QCommand.Disposition run() throws Exception {
            this.deadline = Instant.now().plus(this.timeLimit());
            String actionStatus = "FAILED";
            String commStatus = "UP";
            try {
                this.action();
                actionStatus = "RUNNING";
                QCommand.Disposition disposition = QCommand.Disposition.RUNNING;
                return disposition;
            }
            catch (Aerotech.CommandFailureException exc) {
                Controller.this.aeroLogFailure(exc);
                QCommand.Disposition disposition = QCommand.Disposition.FAILED;
                return disposition;
            }
            catch (DriverException exc) {
                commStatus = "DOWN";
                throw exc;
            }
            finally {
                Controller.this.aeroCommStatus = commStatus;
                Controller.this.aeroActionStatus = actionStatus;
            }
        }

        @Override
        public QCommand.Disposition update() throws Exception {
            String actionStatus = "FAILED";
            String commStatus = "UP";
            try {
                QCommand.Disposition disp = this.updateAction();
                actionStatus = disp.toString();
                QCommand.Disposition disposition = disp;
                return disposition;
            }
            catch (Aerotech.CommandFailureException exc) {
                Controller.this.aeroLogFailure(exc);
                QCommand.Disposition disposition = QCommand.Disposition.FAILED;
                return disposition;
            }
            catch (DriverException exc) {
                commStatus = "DOWN";
                throw exc;
            }
            finally {
                Controller.this.aeroActionStatus = actionStatus;
                Controller.this.aeroCommStatus = commStatus;
            }
        }

        public QCommand.Disposition updateAction() throws Exception {
            boolean idle = Controller.this.controllerIsIdle(Controller.this.aeroLink);
            if (idle) {
                int code = this.completionCode();
                if (code != 0) {
                    LOG.warning((Object)String.format("Aerotech task 1 failed with return code %d.", code));
                    return QCommand.Disposition.FAILED;
                }
                if (this.axis.hasFaults(Controller.this.aeroLink)) {
                    LOG.warning((Object)"Axis faults seen after Aerotech task 1 finished.");
                    return QCommand.Disposition.FAILED;
                }
                return QCommand.Disposition.FINISHED;
            }
            if (Instant.now().isAfter(this.deadline)) {
                Controller.this.aeroStopMotion();
                return QCommand.Disposition.TIMED_OUT;
            }
            return QCommand.Disposition.RUNNING;
        }
    }

    protected abstract class AeroShortCommand
    implements QCommand {
        AeroShortCommand() {
        }

        @Override
        public QCommand.Disposition update() {
            return QCommand.Disposition.FINISHED;
        }

        @Override
        public String device() {
            return Controller.AEROTECH_DEVICE;
        }

        @Override
        public QCommand.Disposition run() throws Exception {
            String actionStatus = "FAILED";
            String commStatus = "UP";
            try {
                this.action();
                QCommand.Disposition disposition = QCommand.Disposition.FINISHED;
                return disposition;
            }
            catch (Aerotech.CommandFailureException exc) {
                Controller.this.aeroLogFailure(exc);
                QCommand.Disposition disposition = QCommand.Disposition.FAILED;
                return disposition;
            }
            catch (DriverException exc) {
                commStatus = "DOWN";
                throw exc;
            }
            finally {
                Controller.this.aeroActionStatus = actionStatus;
                Controller.this.aeroCommStatus = commStatus;
            }
        }

        public abstract void action() throws Exception;
    }
}

