/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.motorplatform.bot;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystem.motorplatform.bot.ChatDriver;
import org.lsst.ccs.utilities.logging.Logger;

public class Aerotech
implements ChatDriver {
    private static final Logger LOG = Logger.getLogger((String)Aerotech.class.getName());
    private static final String STATUS_PREFIXES = "%!#$";
    private final Ascii driver;
    private final ErrorHandling errorMode;

    public Aerotech(Ascii driver, ErrorHandling errorMode) {
        this.driver = driver;
        this.errorMode = errorMode;
    }

    public void close() {
        this.driver.closeSilent();
    }

    @Override
    public String sendCommandRaw(String cmd) throws DriverException {
        return this.driver.read(cmd);
    }

    @Override
    public void setReplyTimeout(int millis) throws DriverException {
        this.driver.setTimeout(millis);
    }

    public Reply sendCommand(String cmd) throws DriverException {
        String text = this.driver.read(cmd);
        Status stat = Status.SUCCESS;
        if (text == null) {
            stat = Status.MISSING_REPOSNSE;
        } else if (text.length() < 1) {
            stat = Status.INVALID_PREFIX;
        } else {
            String prefix = text.substring(0, 1);
            int pos = STATUS_PREFIXES.indexOf(prefix);
            if (pos < 0) {
                stat = Status.INVALID_PREFIX;
            } else {
                stat = Status.values()[pos];
                text = text.substring(1);
            }
        }
        Reply result = new Reply(stat, text, cmd);
        if (stat != Status.SUCCESS) {
            String msg = String.format("Aerotech error: %s. Reply text = '%s'.", stat.message, text);
            if (this.errorMode == ErrorHandling.LOG_ERRORS) {
                LOG.error((Object)msg);
            } else {
                throw new CommandFailureException(msg, result);
            }
        }
        return result;
    }

    public Reply readAnalogInput(String axisName, int channel) throws DriverException {
        return this.sendCommand(String.format("AIN(%s, %d)", axisName, channel));
    }

    public Reply readDigitalInput(String axisName, int port, int bit) throws DriverException {
        return this.sendCommand(String.format("DIN(%s,%d,%d)", axisName, port, bit));
    }

    public Reply writeDigitalOutput(String axisName, int port, int bit, boolean state) throws DriverException {
        return this.sendCommand(String.format("DOUT %s,%d,%d:%d", axisName, port, bit, state ? 1 : 0));
    }

    public Reply readCalibratedPosition(String axisName) throws DriverException {
        return this.sendCommand("PFBKCAL(" + axisName + ")");
    }

    public Reply readProgramPosition(String axisName) throws DriverException {
        return this.sendCommand("PFBKPROG(" + axisName + ")");
    }

    public Reply readRawPosition(String axisName) throws DriverException {
        return this.sendCommand("PFBK(" + axisName + ")");
    }

    public Reply readAxisStatus(String axisName) throws DriverException {
        return this.sendCommand("AXISSTATUS(" + axisName + ")");
    }

    public Reply readAxisFaults(String axisName) throws DriverException {
        return this.sendCommand("AXISFAULT(" + axisName + ")");
    }

    public Reply writeDglobal(int index, double value) throws DriverException {
        return this.sendCommand(String.format("DGLOBAL(%d)=%g", index, value));
    }

    public Reply readDglobal(int index) throws DriverException {
        return this.sendCommand(String.format("DGLOBAL(%d)", index));
    }

    public Reply writeIglobal(int index, int value) throws DriverException {
        return this.sendCommand(String.format("IGLOBAL(%d)=%d", index, value));
    }

    public Reply readIglobal(int index) throws DriverException {
        return this.sendCommand(String.format("IGLOBAL(%d)", index));
    }

    public Reply startProgram(int taskNum, String progName) throws DriverException {
        return this.sendCommand(String.format("PROGRAM RUN %d,\"%s\"", taskNum, progName));
    }

    public Reply stopProgram(int taskNum) throws DriverException {
        return this.sendCommand(String.format("PROGRAM STOP %d", taskNum));
    }

    public Reply readTaskState(int taskNum) throws DriverException {
        return this.sendCommand(String.format("TASKSTATE(%d)", taskNum));
    }

    public Reply clearAxisFaults(String ... axisNames) throws DriverException {
        return this.sendCommand(Arrays.stream(axisNames).collect(Collectors.joining(" ", "FAULTACK ", "")));
    }

    public Reply homeAxes(String ... axisNames) throws DriverException {
        return this.sendCommand(Arrays.stream(axisNames).collect(Collectors.joining(" ", "HOME ", "")));
    }

    public Reply enableAxes(String ... axisNames) throws DriverException {
        return this.sendCommand(Arrays.stream(axisNames).collect(Collectors.joining(" ", "ENABLE ", "")));
    }

    public Reply disableAxes(String ... axisNames) throws DriverException {
        return this.sendCommand(Arrays.stream(axisNames).collect(Collectors.joining(" ", "DISABLE ", "")));
    }

    public Reply abortAxes(String ... axisNames) throws DriverException {
        return this.sendCommand(Arrays.stream(axisNames).collect(Collectors.joining(" ", "ABORT ", "")));
    }

    public Reply clearAllFaults() throws DriverException {
        return this.sendCommand("ACKNOWLEDGEALL");
    }

    public Reply readPlaneStatus(int planeNum) throws DriverException {
        return this.sendCommand(String.format("PLANESTATUS(%d)", planeNum));
    }

    public Reply setPlane(int planeNum) throws DriverException {
        return this.sendCommand(String.format("PLANE %d", planeNum));
    }

    public Reply setWaitMode(WaitMode mode) throws DriverException {
        return this.sendCommand(String.format("WAIT MODE %s", new Object[]{mode}));
    }

    public Reply setRampMode(RampMode mode) throws DriverException {
        return this.sendCommand(String.format("RAMP MODE %s", new Object[]{mode}));
    }

    public Reply setRampRate(double accel) throws DriverException {
        return this.sendCommand(String.format("RAMP RATE %g", accel));
    }

    public Reply setRampDist(double dist) throws DriverException {
        return this.sendCommand(String.format("RAMP DIST %g", dist));
    }

    public Reply setRampTime(double time) throws DriverException {
        return this.sendCommand(String.format("RAMP TIME %g", time));
    }

    public Reply setPositioningMode(PositioningMode mode) throws DriverException {
        return this.sendCommand(String.format("%s", new Object[]{mode}));
    }

    public Reply moveLinear(double targetSpeed, Target ... targets) throws DriverException {
        String cmd = Arrays.stream(targets).map(Target::toString).collect(Collectors.joining(" ", "LINEAR ", String.format(" F %g", targetSpeed)));
        return this.sendCommand(cmd);
    }

    public static class Target {
        public final String axisName;
        public final double position;

        public Target(String axisName, double position) {
            this.axisName = axisName;
            this.position = position;
        }

        public String toString() {
            return String.format("%s %g", this.axisName, this.position);
        }
    }

    public static enum PositioningMode {
        INC,
        ABS;

    }

    public static enum RampMode {
        RATE,
        DIST,
        TIME;

    }

    public static enum WaitMode {
        NOWAIT,
        MOVEDONE,
        INPOS;

    }

    public static class Reply {
        public Status status;
        public final String text;
        public final String command;

        public double asDouble() {
            double result = Double.NaN;
            try {
                if (!this.text.equals("")) {
                    result = Double.parseDouble(this.text);
                }
            }
            catch (NumberFormatException exc) {
                LOG.warning((Object)String.format("Aerotech error. Can't convert the reply text '%s' to double.", this.text));
            }
            return result;
        }

        public int asInt() {
            int result = Integer.MAX_VALUE;
            try {
                if (!this.text.equals("")) {
                    result = Integer.parseInt(this.text);
                }
            }
            catch (NumberFormatException exc) {
                LOG.warning((Object)String.format("Aerotech error. Can't convert the reply text '%s' to int.", this.text));
            }
            return result;
        }

        Reply(Status status, String text, String command) {
            this.status = status;
            this.text = text;
            this.command = command;
        }
    }

    public static enum ErrorHandling {
        LOG_ERRORS,
        THROW_EXCEPTIONS;

    }

    public static enum Status {
        SUCCESS("Success"),
        INVALID_COMMAND("Invalid command"),
        COMMAND_FAULTED("Command caused a fault"),
        COMMAND_TIMEOUT("Command reception timeout"),
        MISSING_REPOSNSE("Missing reply string"),
        INVALID_PREFIX("Reply prefix character is missing or invalid");

        public final String message;

        private Status(String message) {
            this.message = message;
        }
    }

    public static class CommandFailureException
    extends DriverException {
        public final Reply reply;

        CommandFailureException(String msg, Reply reply) {
            super(msg);
            this.reply = reply;
        }
    }
}

