/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupName;

public class Filter {
    @LookupName
    private String name;
    @ConfigurationParameter(isFinal=true, description="weight of this filter", range="0..100", units="kilos")
    private volatile double weight;
    @ConfigurationParameter(isFinal=true, description="FilterID which is coded on filter frame with 6 hall effect sensors.", range="1..63", units="unitless")
    private volatile int filterID;

    public Filter(int filterID, double weight) {
        this.filterID = filterID;
        this.weight = weight;
    }

    public Filter(int filterID, double weight, String name) {
        this.filterID = filterID;
        this.weight = weight;
        this.name = name;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns filter id.")
    public int getFilterID() {
        return this.filterID;
    }

    public String getName() {
        return this.name;
    }

    public double getWeight() {
        return this.weight;
    }
}

