/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.lighthouse;

import java.time.Duration;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.lighthouse.Transport;

public class FTDITransport
implements Transport {
    private final Ascii port;

    public FTDITransport(String ident) throws DriverException {
        Ascii newPort = null;
        try {
            newPort = new Ascii();
            newPort.open(DriverConstants.ConnType.FTDI, ident, 19200, SERIAL_CHARACTERISTICS);
            newPort.setTerminator(MODBUS_FRAME_TERMINATOR);
            this.port = newPort;
        }
        catch (Exception exc) {
            if (newPort != null) {
                newPort.closeSilent();
            }
            throw exc;
        }
    }

    @Override
    public void send(String command) throws DriverException {
        this.port.write(command);
    }

    @Override
    public String receive(Duration timeout) throws DriverException {
        this.port.setTimeout((double)timeout.getSeconds());
        return this.port.read();
    }

    @Override
    public void close() {
        this.port.closeSilent();
    }
}

