/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.utility;

import java.util.logging.Logger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20AnalogControl;
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20Device;
import org.lsst.ccs.subsystem.utility.PurgeTestMain;
import org.lsst.ccs.subsystem.utility.data.UtilityException;

public class UTMaq20Device
extends Maq20Device {
    public static final int CHAN_UT_VALVE = 0;
    @LookupField(strategy=LookupField.Strategy.ANCESTORS)
    private PurgeTestMain main;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private Maq20AnalogControl maqCtrl;
    private static final Logger LOG = Logger.getLogger(UTMaq20Device.class.getName());
    private int modIndex;

    public void initDevice() {
        super.initDevice();
        if (this.maqCtrl == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"analog control", (String)"not defined");
        }
        this.modIndex = this.maqCtrl.getModIndex();
    }

    protected double readChannel(int hwChan, int type) {
        double value = super.readChannel(hwChan, type);
        if ((type & 0xFF) == this.modIndex && hwChan == 0) {
            value = 62.5 * value - 0.25;
        }
        return value;
    }

    public void setUtValve(double posn) throws UtilityException {
        this.setValve(0, posn);
    }

    public void setValve(int chan, double posn) throws UtilityException {
        double value = 0.016 * Math.min(Math.max(posn, 0.0), 1.0) + 0.004;
        try {
            this.maqCtrl.writeValue(chan, value);
        }
        catch (DriverException e) {
            throw new UtilityException("Error operating valve (channel " + chan + "): " + (Object)((Object)e));
        }
    }
}

