/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.utility;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.common.PIController;
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20PWMControl;
import org.lsst.ccs.subsystem.utility.data.UtilityException;

public class FanPIControl
implements HasLifecycle {
    private static final String PIC = "Pic";
    @LookupField(strategy=LookupField.Strategy.TOP)
    Subsystem subsys;
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskServices;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private final Map<String, Channel> allChannels = new HashMap<String, Channel>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private final Map<String, Maq20PWMControl> allFans = new HashMap<String, Maq20PWMControl>();
    @ConfigurationParameter(category="Pic", isFinal=true)
    private volatile Double gain = Double.NaN;
    @ConfigurationParameter(category="Pic", isFinal=true)
    private volatile Double timeConst = Double.NaN;
    @ConfigurationParameter(category="Pic", isFinal=true)
    private volatile Double smoothTime = Double.NaN;
    @ConfigurationParameter(category="Pic", isFinal=true)
    private volatile Double awGain = Double.NaN;
    @ConfigurationParameter(category="Pic", isFinal=true)
    private volatile Double baseDuty = Double.NaN;
    @ConfigurationParameter(category="Pic", isFinal=true)
    private volatile Double tolerance = Double.NaN;
    @ConfigurationParameter(category="Pic", isFinal=true)
    private volatile double minInput = -10.0;
    @ConfigurationParameter(category="Pic", isFinal=true)
    private volatile double maxInput = 10.0;
    @ConfigurationParameter(category="Pic", isFinal=true)
    private volatile double minOutput = 1.0;
    @ConfigurationParameter(category="Pic", isFinal=true)
    private volatile Double maxOutput = 10.0;
    @ConfigurationParameter(category="Pic", isFinal=true)
    private volatile Integer updateTime = Integer.MAX_VALUE;
    private String[] refTempChans;
    private String[] ctrlTempChans;
    private String[] fans;
    private final List<Channel> refTempChanList = new ArrayList<Channel>();
    private final List<Channel> ctrlTempChanList = new ArrayList<Channel>();
    private final Map<String, Maq20PWMControl> fansMap = new HashMap<String, Maq20PWMControl>();
    private static final Logger LOG = Logger.getLogger(FanPIControl.class.getName());
    private PIController pic;
    private double lastDuty;
    private boolean active = false;
    private double setTemp;
    private boolean loopFailed = false;
    private long lastLoopTime;

    public void build() {
        AgentPeriodicTask apt = new AgentPeriodicTask("fan-loop-" + this.name, () -> this.iterateLoop()).withPeriod(Duration.ofMillis(500L));
        this.periodicTaskServices.scheduleAgentPeriodicTask(apt);
    }

    public void init() {
        Maq20PWMControl cmpt;
        if (this.fans == null || this.fans.length == 0) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"fans", (String)"is missing or empty");
        } else {
            for (String cName : this.fans) {
                cmpt = this.allFans.get(cName);
                if (cmpt != null) {
                    this.fansMap.put(cName, cmpt);
                    continue;
                }
                ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"fans", (String)"contains non-Maq20PWMControl item");
            }
        }
        if (this.refTempChans == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"refTempChans", (String)"is missing");
        } else {
            for (String cName : this.refTempChans) {
                cmpt = this.allChannels.get(cName);
                if (cmpt != null) {
                    this.refTempChanList.add((Channel)cmpt);
                    continue;
                }
                ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"refTempChans", (String)"contains non-Channel item");
            }
        }
        if (this.ctrlTempChans == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"ctrlTempChans", (String)"is missing");
        } else {
            for (String cName : this.ctrlTempChans) {
                cmpt = this.allChannels.get(cName);
                if (cmpt != null) {
                    this.ctrlTempChanList.add((Channel)cmpt);
                    continue;
                }
                ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"ctrlTempChans", (String)"contains non-Channel item");
            }
        }
        if (this.ctrlTempChanList.isEmpty() ^ this.refTempChanList.isEmpty()) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"ctrlTempChans and refTempChans", (String)"are not both non-empty nor both empty");
        }
        if (this.ctrlTempChanList.isEmpty()) {
            return;
        }
        if (this.gain == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"gain", (String)"is missing");
        }
        if (this.timeConst.isNaN()) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"timeConst", (String)"is missing");
        }
        if (this.smoothTime.isNaN()) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"smoothTime", (String)"is missing");
        }
        if (this.awGain.isNaN()) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"awGain", (String)"is missing");
        }
        if (this.baseDuty.isNaN()) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"baseDuty", (String)"is missing");
        }
        if (this.tolerance.isNaN()) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"tolerance", (String)"is missing");
        }
        if (this.updateTime == Integer.MAX_VALUE) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"updateTime", (String)"is missing");
        }
        this.pic = new PIController(this.gain.doubleValue(), this.timeConst.doubleValue());
        this.pic.setSmoothTime(this.smoothTime.doubleValue());
        this.pic.setAwGain(this.awGain.doubleValue());
        this.pic.setBaseOutput(this.baseDuty.doubleValue());
        this.pic.setInputRange(this.minInput, this.maxInput);
        this.pic.setOutputRange(this.minOutput, this.maxOutput.doubleValue());
        this.pic.setTolerance(this.tolerance.doubleValue());
    }

    public void setSpeed(double speed) {
        for (Map.Entry<String, Maq20PWMControl> e : this.fansMap.entrySet()) {
            try {
                e.getValue().setDutyCycle1(speed);
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "Error setting {0} fan speed: {1}", new Object[]{e.getKey(), ex.getMessage()});
            }
        }
    }

    public void setTemperature(double temp) throws UtilityException {
        this.checkPicPresent();
        this.setTemp = temp;
        this.pic.setSetpoint(this.setTemp);
    }

    public double getTemperature() {
        return this.setTemp;
    }

    public void setGain(double gain) throws UtilityException {
        this.checkPicPresent();
        this.gain = gain;
        if (this.pic != null) {
            this.pic.setPID(gain, this.timeConst.doubleValue());
        }
    }

    public double getGain() {
        return this.gain;
    }

    public void setTimeConstant(double time) throws UtilityException {
        this.checkPicPresent();
        this.timeConst = time;
        this.pic.setPID(this.gain.doubleValue(), this.timeConst.doubleValue());
    }

    public double getTimeConstant() {
        return this.timeConst;
    }

    public void startLoop(double duty) throws UtilityException {
        this.checkPicPresent();
        if (this.active) {
            return;
        }
        this.lastDuty = 1.0 / duty;
        this.startLoop();
    }

    public void startLoop() throws UtilityException {
        this.checkPicPresent();
        if (this.active) {
            return;
        }
        this.pic.reset();
        this.pic.setIntegral(this.lastDuty - this.baseDuty);
        this.active = true;
    }

    public void stopLoop() throws UtilityException {
        this.checkPicPresent();
        if (!this.active) {
            return;
        }
        this.active = false;
    }

    public boolean isLoopActive() {
        return this.active;
    }

    public void reset() throws UtilityException {
        this.checkPicPresent();
        this.pic.reset();
    }

    private void iterateLoop() {
        double value;
        if (!this.active) {
            return;
        }
        long time = System.currentTimeMillis();
        if (time < this.lastLoopTime + (long)this.updateTime.intValue()) {
            return;
        }
        this.lastLoopTime = time;
        double refTemp = 0.0;
        double ctrlTemp = 0.0;
        int count = 0;
        for (Channel tempChan : this.refTempChanList) {
            value = tempChan.getValue();
            if (Double.isNaN(value)) continue;
            refTemp += value;
            ++count;
        }
        if (count > 0) {
            refTemp /= (double)count;
        } else {
            if (!this.loopFailed) {
                LOG.severe("Control loop iteration failed: no valid reference temperature values available");
                this.loopFailed = true;
            }
            return;
        }
        count = 0;
        for (Channel tempChan : this.ctrlTempChanList) {
            value = tempChan.getValue();
            if (Double.isNaN(value)) continue;
            ctrlTemp += value;
            ++count;
        }
        if (count <= 0) {
            if (!this.loopFailed) {
                LOG.severe("Control loop iteration failed: no valid control temperature values available");
                this.loopFailed = true;
            }
            return;
        }
        this.lastDuty = this.pic.performPI(new double[]{(ctrlTemp /= (double)count) - refTemp}, (double)time / 1000.0);
        this.setSpeed(1.0 / this.lastDuty);
        this.loopFailed = false;
    }

    private void checkPicPresent() throws UtilityException {
        if (this.pic == null) {
            throw new UtilityException("Control loop not present");
        }
    }
}

