import org.lsst.ccs.description.groovy.CCSBuilder
import org.lsst.ccs.drivers.auxelex.Bfr
import org.lsst.ccs.drivers.auxelex.Pdu24VC
import org.lsst.ccs.drivers.auxelex.ComCamPdu24VD
import org.lsst.ccs.drivers.auxelex.Pdu5V
import org.lsst.ccs.drivers.auxelex.ComCamPdu48V
import org.lsst.ccs.subsystem.power.ComCamQuadBox
import org.lsst.ccs.subsystem.power.BfrComCamDevice
import org.lsst.ccs.subsystem.power.Pdu5vDevice
import org.lsst.ccs.subsystem.power.Pdu24vcDevice
import org.lsst.ccs.subsystem.power.ComCamPdu24vdDevice
import org.lsst.ccs.subsystem.power.ComCamPdu48vDevice
import org.lsst.ccs.subsystem.power.RebBulkPsDevice
import org.lsst.ccs.monitor.Channel
import org.lsst.ccs.monitor.Page

CCSBuilder builder = ["comcam-quadbox"]

builder.main (ComCamQuadBox) {

    BFR (BfrComCamDevice) {

        Protection_I (Channel, description: "Protection system current", units: "mA", format: ".1f",
                      hwChan:Bfr.SENSOR_PROT, scale: 1000.0)

        Clean_5_24V_I (Channel, description: "Clean 5 and 24V current", units: "mA", format: ".1f",
                       hwChan:Bfr.SENSOR_PWS_20_21, scale: 1000.0)

        Dirty_24V_I (Channel, description: "Dirty 24V current", units: "mA", format: ".1f",
                     hwChan:Bfr.SENSOR_PWS_3, scale: 1000.0)

        Dirty_48V_I (Channel, description: "Dirty 48V current", units: "mA", format: ".1f",
                     hwChan:Bfr.SENSOR_PWS_1, scale: 1000.0)

        RebPs_0 (Channel, description: "REB PS 0-2 current", units: "mA", format: ".1f",
                     hwChan:Bfr.SENSOR_PWS_16, scale: 1000.0)


        Dirty_28V_I (Channel, description: "Dirty 28V current", units: "mA", format: ".1f",
                     hwChan:Bfr.SENSOR_PWS_4, scale: 1000.0)

        Heater_I (Channel, description: "Heater current", units: "mA", format: ".1f",
                  hwChan:Bfr.SENSOR_HTRS, scale: 1000.0)

    }

    PDU_5V (Pdu5vDevice) {

        OTM_3_A_V (Channel, description: "OTM 3-A voltage", units: "Volt", format: ".2f",
                   hwChan:Pdu5V.CHAN_OTM_3_A, type:"VOLTAGE")

        OTM_3_A_I (Channel, description: "OTM 3-A current", units: "mA", format: ".1f",
                   hwChan:Pdu5V.CHAN_OTM_3_A, type:"CURRENT", scale: 1000.0)

        OTM_3_B_V (Channel, description: "OTM 3-B voltage", units: "Volt", format: ".2f",
                   hwChan:Pdu5V.CHAN_OTM_3_B, type:"VOLTAGE")

        OTM_3_B_I (Channel, description: "OTM 3-B current", units: "mA", format: ".1f",
                   hwChan:Pdu5V.CHAN_OTM_3_B, type:"CURRENT", scale: 1000.0)

    }

    PDU_24VC (Pdu24vcDevice) {
        
        "Main_V" (Channel, description: "24V Clean PDU main voltage", units: "Volt", format: ".2f",
                       type:"MAINVOLT")

        "Main_I" (Channel, description: "24V Clean PDU main current", units: "mA", format: ".1f",
                       type:"MAINCURR", scale: 1000.0)

        "Main_T" (Channel, description: "24V Clean PDU main temperature", units: "\u00b0C", format: ".1f",
                       type:"MAINTEMP")

        "Board_T" (Channel, description: "24V Clean PDU board temperature", units: "\u00b0C", format: ".1f",
                        type:"BOARDTEMP")

        "FPGA_T" (Channel, description: "24V Clean PDU FPGA temperature", units: "\u00b0C", format: ".1f",
                       type:"FPGATEMP")

        Pwr_Cry_HCU_V (Channel, description: "Power/cryo HCU voltage", units: "Volt", format: ".2f",
                       hwChan:Pdu24VC.CHAN_HCU_PWR_CRY, type:"VOLTAGE")

        Pwr_Cry_HCU_I (Channel, description: "Power/cryo HCU current", units: "mA", format: ".1f",
                       hwChan:Pdu24VC.CHAN_HCU_PWR_CRY, type:"CURRENT", scale: 1000.0)

        Fes_Shu_HCU_V (Channel, description: "FES/shutter HCU voltage", units: "Volt", format: ".2f",
                       hwChan:Pdu24VC.CHAN_HCU_FES_SHU, type:"VOLTAGE")

        Fes_Shu_HCU_I (Channel, description: "FES/shutter HCU current", units: "mA", format: ".1f",
                       hwChan:Pdu24VC.CHAN_HCU_FES_SHU, type:"CURRENT", scale: 1000.0)

        Ion_Pumps_V (Channel, description: "Ion pumps voltage", units: "Volt", format: ".2f",
                     hwChan:Pdu24VC.CHAN_ION_PUMPS, type:"VOLTAGE")

        Ion_Pumps_I (Channel, description: "Ion pumps current", units: "mA", format: ".1f",
                     hwChan:Pdu24VC.CHAN_ION_PUMPS, type:"CURRENT", scale: 1000.0)

        Body_Purge_V (Channel, description: "Body purge voltage", units: "Volt", format: ".2f",
                      hwChan:Pdu24VC.CHAN_BODY_PURGE, type:"VOLTAGE")

        Body_Purge_I (Channel, description: "Body purge current", units: "mA", format: ".1f",
                      hwChan:Pdu24VC.CHAN_BODY_PURGE, type:"CURRENT", scale: 1000.0)

        Bpu_Maq20_V (Channel, description: "Body purge MAQ20 voltage", units: "Volt", format: ".2f",
                     hwChan:Pdu24VC.CHAN_BPU_MAQ20, type:"VOLTAGE")

        Bpu_Maq20_I (Channel, description: "Body purge MAQ20 current", units: "mA", format: ".1f",
                     hwChan:Pdu24VC.CHAN_BPU_MAQ20, type:"CURRENT", scale: 1000.0)

        Gauges_V (Channel, description: "Gauges voltage", units: "Volt", format: ".2f",
                  hwChan:Pdu24VC.CHAN_GAUGES, type:"VOLTAGE")

        Gauges_I (Channel, description: "Gauges current", units: "mA", format: ".1f",
                  hwChan:Pdu24VC.CHAN_GAUGES, type:"CURRENT", scale: 1000.0)

    }

    PDU_24VD (ComCamPdu24vdDevice) {
        
        "Main_V" (Channel, description: "24V Dirty PDU main voltage", units: "Volt", format: ".2f",
                       type:"MAINVOLT")

        "Main_I" (Channel, description: "24V Dirty PDU main current", units: "mA", format: ".1f",
                       type:"MAINCURR", scale: 1000.0)

        "Main_T" (Channel, description: "24V Dirty PDU main temperature", units: "\u00b0C", format: ".1f",
                       type:"MAINTEMP")

        "Board_T" (Channel, description: "24V Dirty PDU board temperature", units: "\u00b0C", format: ".1f",
                        type:"BOARDTEMP")

        "FPGA_T" (Channel, description: "24V Dirty PDU FPGA temperature", units: "\u00b0C", format: ".1f",
                       type:"FPGATEMP")

        Cryo_Turbo_V (Channel, description: "Cryo turbo pump voltage", units: "Volt", format: ".2f",
                      hwChan:ComCamPdu24VD.CHAN_CRYO_TURBO, type:"VOLTAGE")

        Cryo_Turbo_I (Channel, description: "Cryo turbo pump current", units: "mA", format: ".1f",
                      hwChan:ComCamPdu24VD.CHAN_CRYO_TURBO, type:"CURRENT", scale: 1000.0)

    }

    PDU_48V (ComCamPdu48vDevice) {
        
        "Main_V" (Channel, description: "48V PDU main voltage", units: "Volt", format: ".2f",
                      type:"MAINVOLT")

        "Main_I" (Channel, description: "48V PDU main current", units: "mA", format: ".1f",
                      type:"MAINCURR", scale: 1000.0)

        "Main_T" (Channel, description: "48V PDU main temperature", units: "\u00b0C", format: ".1f",
                      type:"MAINTEMP")

        "Board_T" (Channel, description: "48V PDU board temperature", units: "\u00b0C", format: ".1f",
                       type:"BOARDTEMP")

        "FPGA_T" (Channel, description: "48V PDU FPGA temperature", units: "\u00b0C", format: ".1f",
                      type:"FPGATEMP")

//        Purge_Fan_V (Channel, description: "Purge fan voltage", units: "Volt", format: ".2f",
//                     hwChan:ComCamPdu48V.CHAN_PURGE_FAN, type:"VOLTAGE")

//        Purge_Fan_I (Channel, description: "Purge fan current", units: "mA", format: ".1f",
//                     hwChan:ComCamPdu48V.CHAN_PURGE_FAN, type:"CURRENT", scale: 1000.0)

    }

    REB_Bulk_PS (RebBulkPsDevice) {

//        RebBulkPs_Brd_T (Channel, description: "REB Bulk PS board temperature", units: "\u00b0C", format: ".1f",
//                         type:"BOARDTEMP")

//        RebBulkPs_0_V (Channel, description: "REB Bulk PS voltage", units: "Volt", format: ".1f",
//                         hwChan:0, type:"VOLTAGE")

//        RebBulkPs_0_I (Channel, description: "REB Bulk PS current", units: "mA", format: ".1f",
//                         hwChan:0, type:"CURRENT", scale: 1000.0)

//        RebBulkPs_0_T (Channel, description: "REB Bulk PS temperature", units: "\u00b0C", format: ".1f",
//                         hwChan:0, type:"TEMP")

    }

}
