/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.airwatch.main;

import java.time.DateTimeException;
import java.time.Duration;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.PersistencyService;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.Persist;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.airwatch.main.InstrumentChannel;
import org.lsst.ccs.subsystem.airwatch.main.InstrumentConfig;
import org.lsst.ccs.subsystem.airwatch.main.InstrumentStatus;
import org.lsst.ccs.subsystem.airwatch.main.InstrumentType;
import org.lsst.ccs.subsystem.airwatch.main.LocalConfigService;
import org.lsst.ccs.subsystem.airwatch.main.LocationConfig;

public class CCSConfiguration
implements LocalConfigService,
HasLifecycle {
    @LookupField(strategy=LookupField.Strategy.TREE)
    private volatile ConfigurationService ccsConfig;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private volatile PersistencyService ccsPersist;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private volatile AlertService ccsAlert;
    private volatile Duration readoutInterval;
    private volatile List<InstrumentConfig> instConfigs;
    private volatile List<LocationConfig> locConfigs;
    @ConfigurationParameter(name="readoutInterval", description="The time between readouts.")
    private volatile String readoutIntervalString = "PT1H";
    @ConfigurationParameter(description="All valid location names.")
    private volatile String[] knownLocations = new String[0];
    @ConfigurationParameter(description="Alarm thresholds for the 0.3 micron channel.")
    private volatile Map<String, Long> locationThresholds_0_3 = Collections.emptyMap();
    @ConfigurationParameter(description="Alarm thresholds for the 0.5 micron channel.")
    private volatile Map<String, Long> locationThresholds_0_5 = Collections.emptyMap();
    @ConfigurationParameter(description="Alarm thresholds for the 1.0 micron channel.")
    private volatile Map<String, Long> locationThresholds_1_0 = Collections.emptyMap();
    @ConfigurationParameter(description="Alarm thresholds for the 2.5 micron channel.")
    private volatile Map<String, Long> locationThresholds_2_5 = Collections.emptyMap();
    @ConfigurationParameter(description="Alarm thresholds for the 3.0 micron channel.")
    private volatile Map<String, Long> locationThresholds_3_0 = Collections.emptyMap();
    @ConfigurationParameter(description="Alarm thresholds for the 5.0 micron channel.")
    private volatile Map<String, Long> locationThresholds_5_0 = Collections.emptyMap();
    @ConfigurationParameter(description="Alarm thresholds for the 10.0 micron channel.")
    private volatile Map<String, Long> locationThresholds_10_0 = Collections.emptyMap();
    @ConfigurationParameter(description="Instrument make and/or model.")
    private volatile String[] instrumentTypes = new String[0];
    @ConfigurationParameter(description="How to open a connection to the instrument.")
    private volatile String[] instrumentConnections = new String[0];
    @Persist
    private volatile String[] instrumentLocations = new String[0];
    @ConfigurationParameter(name="instrumentLocations", description="Locations of instruments.")
    private volatile String[] configInstrumentLocations = new String[0];
    @Persist
    private volatile String[] instrumentLastDataTimes = new String[0];
    @ConfigurationParameter(name="instrumentLastDataTimes", description="The last time each instrument was read.")
    private volatile String[] configInstrumentLastDataTimes = new String[0];
    @ConfigurationParameter(description="The name or IPv4 address of the SMTP server.")
    private volatile String SMTPServer = "";
    @ConfigurationParameter(description="Email address, possibly fake, used as email sender.")
    private volatile String emailSender = "";
    @ConfigurationParameter(description="Real email address which receives bounced messages.")
    private volatile String emailBounceTo = "";
    @ConfigurationParameter(description="List of recipients of alarm emails.")
    private volatile String[] emailRecipients = new String[0];
    @ConfigurationParameter(description="Connection information for LMS Express OPC servers.")
    private volatile Map<String, List<String>> opcServers = Collections.emptyMap();

    @Override
    public void makeConfigurationObjects() {
        try {
            this.readoutInterval = Duration.parse(this.readoutIntervalString);
        }
        catch (DateTimeException exc) {
            throw new IllegalArgumentException("Bad configuration. Invalid readout interval.");
        }
        this.makeLocationConfigs();
        this.makeInstrumentConfigs();
    }

    private void makeLocationConfigs() {
        Map chanToLoc = Stream.of(InstrumentChannel.values()).filter(InstrumentChannel::isParticleChannel).collect(Collectors.toMap(Function.identity(), chan -> {
            try {
                return (Map)this.getClass().getDeclaredField(this.channelThresholdsConfigVarName((InstrumentChannel)((Object)chan))).get(this);
            }
            catch (NoSuchFieldException exc) {
                throw new IllegalArgumentException("Missing configuration variable?", exc);
            }
            catch (IllegalAccessException exc) {
                throw new Error("Impossible!", exc);
            }
        }));
        List knownLocs = Stream.of(this.knownLocations).map(String::toLowerCase).collect(Collectors.toList());
        chanToLoc.forEach((chan, configVar) -> {
            CCSConfiguration.checkStringSet(configVar.keySet().stream(), knownLocs.stream(), "Bad locations in " + this.channelThresholdsConfigVarName((InstrumentChannel)((Object)chan)));
            CCSConfiguration.checkThresholds(configVar, this.channelThresholdsConfigVarName((InstrumentChannel)((Object)chan)));
        });
        List locToChan = IntStream.range(0, knownLocs.size()).mapToObj(i -> new EnumMap(InstrumentChannel.class)).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
        chanToLoc.forEach((chan, configVar) -> configVar.forEach((locName, threshold) -> {
            int i = knownLocs.indexOf(locName);
            ((Map)locToChan.get(i)).put(chan, threshold);
        }));
        this.locConfigs = Collections.unmodifiableList(IntStream.range(0, knownLocs.size()).mapToObj(i -> new LocationConfig(this.knownLocations[i], i, (Map)locToChan.get(i))).collect(ArrayList::new, ArrayList::add, ArrayList::addAll));
    }

    private void makeInstrumentConfigs() {
        if (this.configInstrumentLocations.length > 0) {
            this.instrumentLocations = this.configInstrumentLocations;
        }
        if (this.configInstrumentLastDataTimes.length > 0) {
            this.instrumentLastDataTimes = this.configInstrumentLastDataTimes;
        }
        List knownLocs = Stream.of(this.knownLocations).map(String::toLowerCase).collect(Collectors.toList());
        String[] types = this.instrumentTypes;
        String[] conns = this.instrumentConnections;
        String[] locs = Stream.of(this.instrumentLocations).map(String::toLowerCase).collect(Collectors.toList()).toArray(new String[this.instrumentLocations.length]);
        String[] times = this.instrumentLastDataTimes;
        if (types.length != conns.length || types.length != locs.length || types.length != times.length) {
            throw new IllegalArgumentException("Bad configuration. Not all the instrumentXxx[] arrays are the same length.");
        }
        if (types.length == 0) {
            throw new IllegalArgumentException("Bad configuration. No instruments defined!");
        }
        CCSConfiguration.checkStringSet(Stream.of(locs), knownLocs.stream(), "Unknown instrument locations");
        CCSConfiguration.checkStringSet(Stream.of(types), Stream.of(InstrumentType.values()).map(InstrumentType::getConfigName), "Unknown instrument types");
        CCSConfiguration.checkStringSet(Stream.of(times), Stream.of(times).filter(t -> {
            try {
                Instant.parse(t);
                return true;
            }
            catch (DateTimeParseException exc) {
                return false;
            }
        }), "Last data-times rejected by Instant.parse()");
        this.instConfigs = Collections.unmodifiableList(IntStream.range(0, types.length).mapToObj(i -> new InstrumentConfig(i, InstrumentType.parse(types[i]).get(), conns[i], locs[i], Instant.parse(times[i]), this, this.ccsAlert)).collect(Collectors.toList()));
    }

    private static void checkStringSet(Stream<String> mentioned, Stream<String> legal, String errorMsg) {
        Set unknown = mentioned.collect(Collectors.toSet());
        unknown.removeAll(legal.collect(Collectors.toSet()));
        if (unknown.size() > 0) {
            throw new IllegalArgumentException("Bad configuration. " + errorMsg + ": " + unknown.stream().collect(Collectors.joining(", ")));
        }
    }

    private static void checkThresholds(Map<String, Long> threshVar, String varName) {
        threshVar.forEach((locName, threshold) -> {
            if (threshold < 0L || threshold > Integer.MAX_VALUE) {
                throw new IllegalArgumentException(String.format("Bad configuration. Bad threshold value %d for location %s in %s.", threshold, locName, varName));
            }
        });
    }

    private String channelThresholdsConfigVarName(InstrumentChannel chan) {
        return "locationThresholds_" + chan.getKey().replaceFirst("\\.", "_");
    }

    @Override
    public List<InstrumentConfig> getInstrumentConfigs() {
        return this.instConfigs;
    }

    @Override
    public void updateInstrument(InstrumentStatus stat) {
        String[] newLocs = Arrays.copyOf(this.instrumentLocations, this.instrumentLocations.length);
        newLocs[stat.index] = stat.location;
        this.instrumentLocations = newLocs;
        String[] newTimes = Arrays.copyOf(this.instrumentLastDataTimes, this.instrumentLastDataTimes.length);
        newTimes[stat.index] = stat.lastDataTime.toString();
        this.instrumentLastDataTimes = newTimes;
        this.ccsPersist.persistNow();
    }

    @Override
    public List<LocationConfig> getLocationConfigs() {
        return this.locConfigs;
    }

    @Override
    public Duration getReadoutInterval() {
        return this.readoutInterval;
    }

    @Override
    public String getEmailSender() {
        return this.emailSender;
    }

    @Override
    public String getEmailBounceAddress() {
        return this.emailBounceTo;
    }

    @Override
    public String getSMTPServer() {
        return this.SMTPServer;
    }

    @Override
    public List<String> getEmailRecipients() {
        return Collections.unmodifiableList(Arrays.asList(this.emailRecipients));
    }

    @Override
    public List<String> getOPCServerInfo(String serverKey) {
        return Collections.unmodifiableList(this.opcServers.get(serverKey));
    }

    public void init() {
        ArrayList<String> missing = new ArrayList<String>();
        if (this.ccsConfig == null) {
            missing.add("CCS configuration service");
        }
        if (this.ccsPersist == null) {
            missing.add("CCS persistence service");
        }
        this.ccsPersist.setAutomatic(true, true);
        if (!missing.isEmpty()) {
            throw new RuntimeException("Can't find " + String.join((CharSequence)", ", missing));
        }
    }
}

