/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.motorplatform.main;

import java.util.ArrayList;
import java.util.List;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystem.motorplatform.bus.AxisStatus;

public class DummyAxis
implements HasLifecycle {
    private String axisName;
    private String units;
    private int index;
    private boolean enabled = false;
    private boolean moving = false;
    private boolean homed = false;
    private boolean atLow = false;
    private boolean atHigh = false;
    private double position = 0.0;
    private final List<String> faults = new ArrayList<String>();
    @ConfigurationParameter
    private double lowLimit = -1.0E20;
    @ConfigurationParameter
    private double highLimit = 1.0E20;

    public void init() {
        this.atLow = this.position <= this.lowLimit;
        this.atHigh = this.position >= this.highLimit;
    }

    public String getName() {
        return this.axisName;
    }

    public int getIndex() {
        return this.index;
    }

    public String getUnits() {
        return this.units;
    }

    public AxisStatus getStatus() {
        this.setFaults();
        return new AxisStatus(this.axisName, this.enabled, this.moving, this.homed, this.atLow, this.atHigh, this.faults, this.position);
    }

    public void setEnabled(boolean flag) {
        this.enabled = flag;
        this.homed = this.enabled && this.homed;
    }

    public void clearFaults() {
        this.setFaults();
    }

    private void setFaults() {
        this.faults.clear();
        if (this.position <= this.lowLimit) {
            this.faults.add("At low limit");
            this.atLow = true;
        } else {
            this.atLow = false;
        }
        if (this.position >= this.highLimit) {
            this.faults.add("At high limit");
            this.atHigh = true;
        } else {
            this.atHigh = false;
        }
        if (!this.enabled) {
            this.faults.add("Disabled");
        }
    }

    public void moveRelative(double distance) {
        if (this.enabled) {
            this.position += distance;
            this.homed = false;
        }
        this.checkPosition();
    }

    public void moveAbsolute(double position) {
        if (this.enabled) {
            this.position = position;
            this.homed = false;
        }
        this.checkPosition();
    }

    private void checkPosition() {
        if (this.position >= this.highLimit) {
            this.position = this.highLimit + 0.001;
        }
        if (this.position <= this.lowLimit) {
            this.position = this.lowLimit - 0.001;
        }
        this.setFaults();
    }

    public void home() {
        this.moveAbsolute(this.lowLimit + 0.001);
        this.homed = this.enabled;
    }
}

