/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.switches;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.utilities.conv.InputConversionEngine;

public class SwitchesOnOffCustomLevels {
    private final List<SwitchCustomLevel> customLevels = new ArrayList<SwitchCustomLevel>();
    private final Map<String, SwitchCustomLevel> customLevelsMap = new HashMap<String, SwitchCustomLevel>();

    public SwitchesOnOffCustomLevels(String stringRepresentation) {
        ArrayList customLevelsStrings = new ArrayList();
        customLevelsStrings.addAll((List)InputConversionEngine.convertArgToType((String)stringRepresentation, List.class));
        for (String str : customLevelsStrings) {
            SwitchCustomLevel scl = (SwitchCustomLevel)InputConversionEngine.convertArgToType((String)str, SwitchCustomLevel.class);
            this.addSwitchCustomLevel(scl);
        }
    }

    public SwitchesOnOffCustomLevels() {
    }

    public boolean isCommandRequestCompatibleWithCustomLevel(Agent agent, String switchName, boolean isOn) {
        SwitchCustomLevel scl = this.getCustomLevelForSwitchPosition(switchName, isOn);
        if (scl == null) {
            return true;
        }
        CommandRequest commandRequest = agent.getCommandForThisThread().getCommandRequest();
        return commandRequest.getLevel() >= scl.customLevel;
    }

    public String toString() {
        return this.customLevels.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SwitchesOnOffCustomLevels) {
            SwitchesOnOffCustomLevels in = (SwitchesOnOffCustomLevels)obj;
            return in.customLevels.equals(this.customLevels);
        }
        return false;
    }

    SwitchCustomLevel getCustomLevelForSwitchPosition(String switchName, boolean isOn) {
        return this.customLevelsMap.get(SwitchesOnOffCustomLevels.getKeyForSwitch(switchName, isOn));
    }

    public int getCustomLevelForSwitch(String switchName, boolean isOn) {
        SwitchCustomLevel scl = this.getCustomLevelForSwitchPosition(switchName, isOn);
        return scl != null ? scl.customLevel : -999;
    }

    final void addSwitchCustomLevel(SwitchCustomLevel scl) {
        this.customLevels.add(scl);
        this.addSwitchCustomLevelToMapAndValidate(scl);
    }

    final void addSwitchCustomLevel(String switchName, boolean isOn, int customLevel) {
        SwitchCustomLevel scl = new SwitchCustomLevel(switchName, isOn, customLevel);
        this.addSwitchCustomLevel(scl);
    }

    private void addSwitchCustomLevelToMapAndValidate(SwitchCustomLevel scl) {
        String key = SwitchesOnOffCustomLevels.getKeyForSwitch(scl.switchName, scl.isOn);
        if (this.customLevelsMap.containsKey(key)) {
            throw new IllegalArgumentException("Custom level already defined for switch " + key + " \"" + this.customLevelsMap.get(key) + "\"");
        }
        this.customLevelsMap.put(key, scl);
    }

    private static String getKeyForSwitch(String switchName, boolean isOn) {
        String key = switchName + (isOn ? "-On:" : "-Off:");
        return key.substring(0, key.length() - 1);
    }

    public static class SwitchCustomLevel {
        private final String switchName;
        private final int customLevel;
        private final boolean isOn;
        private static final String ON_SEPARATOR = "-On:";
        private static final String OFF_SEPARATOR = "-Off:";

        SwitchCustomLevel(String switchName, boolean isOn, int customLevel) {
            this.switchName = switchName;
            this.isOn = isOn;
            this.customLevel = customLevel;
        }

        public SwitchCustomLevel(String stringRepresentation) {
            this.isOn = stringRepresentation.contains(ON_SEPARATOR);
            String separator = this.isOn ? ON_SEPARATOR : OFF_SEPARATOR;
            String[] split = stringRepresentation.split(separator);
            if (split.length != 2) {
                throw new IllegalArgumentException("Illegal format for input string \"" + stringRepresentation + "\"");
            }
            this.switchName = split[0];
            try {
                this.customLevel = Integer.parseInt(split[1]);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Illegal format for input string \"" + stringRepresentation + "\"", e);
            }
        }

        public String toString() {
            return this.switchName + (this.isOn ? ON_SEPARATOR : OFF_SEPARATOR) + this.customLevel;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SwitchCustomLevel) {
                SwitchCustomLevel in = (SwitchCustomLevel)obj;
                return in.switchName.equals(this.switchName) && in.isOn == this.isOn && in.customLevel == this.customLevel;
            }
            return false;
        }

        int getCustomLevel() {
            return this.customLevel;
        }
    }
}

