/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.keyence;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.ascii.TestAscii;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.keyence.KeyenceG5001;

public class TestKeyenceG5001
extends TestAscii {
    protected KeyenceG5001 mydev;

    public TestKeyenceG5001() {
        super((Ascii)new KeyenceG5001());
        this.mydev = (KeyenceG5001)this.dev;
    }

    @Command(description="Set to communications mode.")
    public void commmode() throws DriverException {
        this.mydev.commmode();
    }

    @Command(description="Set to general mode.")
    public void genmode() throws DriverException {
        this.mydev.genmode();
    }

    @Command(description="Get a Keyence head measurement.")
    public String readdistance(@Argument(description="keyence head number") int ikey) throws DriverException {
        return "Measurement: " + this.mydev.readDistance(ikey);
    }

    @Command(description="Get both Keyence head measurements.")
    public String readdistance() throws DriverException {
        double[] values = this.mydev.readDistance();
        StringBuilder resp = new StringBuilder("Measurements:");
        for (double value : values) {
            resp.append(" ").append(value);
        }
        return resp.toString();
    }

    @Command(description="Get the number of samples.")
    public String getnsamps() throws DriverException {
        return "Number of samples: " + this.mydev.getnsamps();
    }

    @Command(description="Set the number of samples.")
    public void setnsamps(@Argument(description="number of samples") int nsamps) throws DriverException {
        this.mydev.setnsamps(nsamps);
    }

    @Command(description="Get the measurement mode for a given sensor head.")
    public String getmeasmode(@Argument(description="keyence head number") int ikey) throws DriverException {
        return "Measurement mode: " + this.mydev.getmeasmode(ikey);
    }

    @Command(description="Set measurement mode for a given sensor head.")
    public void setmeasmode(@Argument(description="keyence head number") int ikey, @Argument(description="measurement mode") int mode) throws DriverException {
        this.mydev.setmeasmode(ikey, mode);
    }

    @Command(description="Get the minimum display units for a given sensor head.")
    public String getmindispunit(@Argument(description="keyence head number") int ikey) throws DriverException {
        return "Minimum display units: " + this.mydev.getmindispunit(ikey);
    }

    @Command(description="Set the minimum display units for a given sensor head.")
    public void setmindispunit(@Argument(description="keyence head number") int ikey, @Argument(description="display units") int units) throws DriverException {
        this.mydev.setmindispunit(ikey, units);
    }

    @Command(name="readkey", description="Read response to Keyence command, stripped of echoed command.")
    public String readkey(@Argument(description="command to send") String command) throws DriverException {
        return "response: " + this.mydev.readKey(command);
    }

    @Command(name="writekey", description="Write Keyence command, read and test response.")
    public void writekey(@Argument(description="command to send") String command) throws DriverException {
        this.mydev.writeKey(command);
    }
}

