/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.messages.StatusStateChangeNotification;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.ocsbridge.sim.ControlledSubsystem;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMConfig;
import org.lsst.ccs.subsystem.ocsbridge.sim.ShutterInterface;
import org.lsst.ccs.subsystem.ocsbridge.states.ShutterState;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

class BonnShutterSubsystemLayer
extends ControlledSubsystem
implements ShutterInterface {
    private static final Logger LOG = Logger.getLogger(BonnShutterSubsystemLayer.class.getName());
    private static final Map<Enum<org.lsst.ccs.subsystem.bonnshutter.states.ShutterState>, Enum<ShutterState>> BONNSHUTTER_TO_SHUTTER_STATE = new HashMap<Enum<org.lsst.ccs.subsystem.bonnshutter.states.ShutterState>, Enum<ShutterState>>();

    BonnShutterSubsystemLayer(Subsystem mcm, CCS ccs, MCMConfig config) {
        super(mcm, config.getShutterSubsystemName(), ccs, config);
    }

    @Override
    public void expose(ImageName imageName, Duration exposeTime) throws ExecutionException {
        this.commandSender.sendCommand("takeExposure", (double)exposeTime.toMillis() / 1000.0);
        this.commandSender.sendCommand("waitForExposure", new Object[0]);
    }

    @Override
    public void open(ImageName imageName) throws ExecutionException {
        this.commandSender.sendCommand("openShutter", new Object[0]);
    }

    @Override
    public void close() throws ExecutionException {
        this.commandSender.sendCommand("closeShutter", new Object[0]);
    }

    @Override
    public void prepare() {
    }

    @Override
    protected void onStateChange(StatusStateChangeNotification statusChange) {
        CCSTimeStamp when = statusChange.getStateTransitionTimestamp();
        StateBundle newStates = statusChange.getNewState();
        StateBundle oldStates = statusChange.getOldState();
        StateBundle changedStates = newStates.diffState(oldStates);
        String cause = statusChange.getCause();
        changedStates.getDecodedStates().entrySet().stream().map(changedState -> (Enum)changedState.getValue()).forEachOrdered(value -> this.translateBonnShutterStateToShutterState(when, (Enum)value, cause));
    }

    private void translateBonnShutterStateToShutterState(CCSTimeStamp when, Enum value, String cause) {
        LOG.log(Level.INFO, "Got bonn-shutter state {0} ", value);
        Enum<ShutterState> converted = BONNSHUTTER_TO_SHUTTER_STATE.get(value);
        if (converted != null) {
            this.ccs.getAggregateStatus().add(when, new State<Enum<ShutterState>>(converted, cause));
        }
    }

    @Override
    public void setImageSequence(boolean imageSequence) {
    }

    static {
        BONNSHUTTER_TO_SHUTTER_STATE.put((Enum<org.lsst.ccs.subsystem.bonnshutter.states.ShutterState>)org.lsst.ccs.subsystem.bonnshutter.states.ShutterState.OPEN, ShutterState.OPEN);
        BONNSHUTTER_TO_SHUTTER_STATE.put((Enum<org.lsst.ccs.subsystem.bonnshutter.states.ShutterState>)org.lsst.ccs.subsystem.bonnshutter.states.ShutterState.OPENING, ShutterState.OPENING);
        BONNSHUTTER_TO_SHUTTER_STATE.put((Enum<org.lsst.ccs.subsystem.bonnshutter.states.ShutterState>)org.lsst.ccs.subsystem.bonnshutter.states.ShutterState.CLOSED, ShutterState.CLOSED);
        BONNSHUTTER_TO_SHUTTER_STATE.put((Enum<org.lsst.ccs.subsystem.bonnshutter.states.ShutterState>)org.lsst.ccs.subsystem.bonnshutter.states.ShutterState.CLOSING, ShutterState.CLOSING);
    }
}

