/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.vacuum;

import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.DerivedChannel;
import org.lsst.ccs.subsystem.vacuum.VacMaq20Device;
import org.lsst.ccs.subsystem.vacuum.VacSimMaq20Device;

public class FlineValvePositions
extends DerivedChannel
implements HasLifecycle {
    protected Object ValveLimitSwitchesObj;
    protected Object RunMode;
    protected String type;
    @LookupPath
    private String path;

    public void init() {
        if (this.ValveLimitSwitchesObj == null) {
            throw new RuntimeException(this.path + ": VacMaq20Device has not been defined");
        }
    }

    public String getForelineValveState(String type) {
        String val = null;
        if (((String)this.RunMode).contains("sim")) {
            if (type.contains("cryo")) {
                val = ((VacSimMaq20Device)this.ValveLimitSwitchesObj).getCryoLimitSwitchStateString();
            } else if (type.contains("hx")) {
                val = ((VacSimMaq20Device)this.ValveLimitSwitchesObj).getHxLimitSwitchStateString();
            }
        } else if (type.contains("cryo")) {
            val = ((VacMaq20Device)this.ValveLimitSwitchesObj).getCryoLimitSwitchStateString();
        } else if (type.contains("hx")) {
            val = ((VacMaq20Device)this.ValveLimitSwitchesObj).getHxLimitSwitchStateString();
        }
        return val;
    }

    public double evaluateDerivedValue() {
        double val = -1.0;
        if (((String)this.RunMode).contains("sim")) {
            if (this.type.contains("cryo")) {
                val = ((VacSimMaq20Device)this.ValveLimitSwitchesObj).getCryoLimitSwitchStateID().intValue();
            } else if (this.type.contains("hx")) {
                val = ((VacSimMaq20Device)this.ValveLimitSwitchesObj).getHxLimitSwitchStateID().intValue();
            }
        } else if (this.type.contains("cryo")) {
            val = ((VacMaq20Device)this.ValveLimitSwitchesObj).getCryoLimitSwitchStateID().intValue();
        } else if (this.type.contains("hx")) {
            val = ((VacMaq20Device)this.ValveLimitSwitchesObj).getHxLimitSwitchStateID().intValue();
        }
        return val;
    }
}

