/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.common;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedDuringMotionNoEncoder;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedDuringMotionWithEncoder;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenEPOS;
import org.lsst.ccs.subsystems.fcs.errors.EPOSConfigurationException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public interface EPOSController
extends PieceOfHardware,
HasLifecycle {
    public static final Logger FCSLOG = Logger.getLogger(EPOSController.class.getName());

    public int getStatusWord();

    public int readStatusWord();

    public void updateStatusWord();

    public short readControlWord();

    public void setEposState(EPOSEnumerations.EposState var1);

    public EPOSEnumerations.EposState getEposState();

    public void writeControlWord(int var1);

    default public void writeControlWord(EPOSEnumerations.ControlWord mode) {
        this.writeControlWord(mode.getValue());
    }

    default public List<String> getEPOSParameters() {
        return Arrays.stream(EPOSEnumerations.Parameter.values()).map(Enum::name).sorted().collect(Collectors.toList());
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="print status word in binary.")
    default public String printStatusWordInBinary() {
        return "0b" + Integer.toBinaryString(this.readStatusWord());
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Shutdown the controller - writeControlWord[6] and check that controller is in state READY_TO_SWITCH_ON.")
    default public void shutdownController() {
        this.writeControlWord(EPOSEnumerations.ControlWord.SHUTDOWN);
        this.checkState(EPOSEnumerations.EposState.READY_TO_SWITCH_ON);
        FCSLOG.finer(() -> this.getName() + ": is READY_TO_SWITCH_ON.");
        this.publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if controller state is state given as argument.")
    default public boolean isInState(EPOSEnumerations.EposState state) {
        return state == this.getEposState();
    }

    public static boolean isReadyToSwitchOn(int statusWord) {
        return (statusWord & 0x6F) == 33;
    }

    public static boolean isSwitchedOn(int statusWord) {
        return (statusWord & 0x6F) == 35;
    }

    public static boolean isSwitchOnDisabled(int statusWord) {
        return (statusWord & 0x4F) == 64;
    }

    public static boolean isOperationEnabled(int statusWord) {
        return (statusWord & 0x6F) == 39;
    }

    public static boolean isFault(int statusWord) {
        return (statusWord & 8) == 8;
    }

    public static boolean isQuickstop(int statusWord) {
        return (statusWord & 0x7F) == 23;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read statusWord by SDO and update eposState.")
    default public void updateEposState() {
        int statusWord = this.readStatusWord();
        this.updateEposState(statusWord);
    }

    default public void updatePositionFromSDO() {
        this.setPosition(this.readPosition());
    }

    default public void updateEposState(int statusWord) {
        if (EPOSController.isFault(statusWord)) {
            this.setEposState(EPOSEnumerations.EposState.FAULT);
        } else if (EPOSController.isSwitchOnDisabled(statusWord)) {
            this.setEposState(EPOSEnumerations.EposState.SWITCH_ON_DISABLED);
        } else if (EPOSController.isQuickstop(statusWord)) {
            FCSLOG.info("QUICKSTOP state " + this.getName() + " status word " + Integer.toBinaryString(this.readStatusWord()) + " error register " + this.getErrorRegister() + " last error code " + this.getLastErrorCode());
            if (this instanceof CanOpenEPOS) {
                FCSLOG.info("QUICKSTOP 0x6007" + ((CanOpenEPOS)this).readSDO(24583, 0) + " 0x605E " + ((CanOpenEPOS)this).readSDO(24670, 0));
            }
            this.setEposState(EPOSEnumerations.EposState.QUICKSTOP);
        } else if (EPOSController.isReadyToSwitchOn(statusWord)) {
            this.setEposState(EPOSEnumerations.EposState.READY_TO_SWITCH_ON);
        } else if (EPOSController.isSwitchedOn(statusWord)) {
            this.setEposState(EPOSEnumerations.EposState.SWITCHED_ON);
        } else if (EPOSController.isOperationEnabled(statusWord)) {
            this.setEposState(EPOSEnumerations.EposState.OPERATION_ENABLE);
        } else {
            this.setEposState(EPOSEnumerations.EposState.UNKNOWN_STATE);
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check controller state until a timeout of 500ms. If controller never goes in state given as argument, throw an Exception.")
    default public void checkState(EPOSEnumerations.EposState state) {
        long timeoutMillis = 500L;
        long timeStart = System.currentTimeMillis();
        long duration = 0L;
        boolean state_ok = false;
        while (!state_ok && duration <= timeoutMillis) {
            FcsUtils.sleep(2, this.getName());
            duration = System.currentTimeMillis() - timeStart;
            this.updateEposState();
            state_ok = this.isInState(state);
        }
        if (!state_ok) {
            String msg = this.getName() + String.format(" couldn't go to state %s during time allocated of %d ms controller state is %s", state, timeoutMillis, this.getEposState());
            FCSLOG.severe(msg);
            FCSLOG.severe("controller " + this.getName() + " in " + state + " status word " + Integer.toBinaryString(this.readStatusWord()) + " error register " + this.getErrorRegister() + " last error code " + this.getLastErrorCode() + " " + this.getLastErrorName());
            throw new FcsHardwareException(msg);
        }
        FCSLOG.info(this.getName() + String.format(" go to state %s duration = %d", state, duration));
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Disable voltage - writeControlWord[0] - and check that controller state is SWITCH_ON_DISABLED. This command does not activate holding brake. cf doc EPOS2_Firmware_Specification \u00a7 3.2 Device Control")
    default public void disableVoltage() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("disableVoltage-EPOS-" + this.getName());){
            this.writeControlWord(EPOSEnumerations.ControlWord.DISABLE_VOLTAGE);
            this.checkState(EPOSEnumerations.EposState.SWITCH_ON_DISABLED);
            FCSLOG.info(this.getName() + " High-level power is switched off.");
            this.updateDataDuringMotionFromSDO();
            this.publishData();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Command(type=Command.CommandType.ACTION, level=1, description="Go to state SWITCH_ON_DISABLED.cf doc EPOS2_Firmware_Specification \u00a7 3.2 Device Control")
    default public void goToSwitchOnDisabled() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("goToSwitchOnDisabled-EPOS-" + this.getName());){
            this.checkFault();
            this.updateEposState();
            EPOSEnumerations.EposState state = this.getEposState();
            switch (state) {
                case SWITCH_ON_DISABLED: {
                    FCSLOG.info(this.getName() + " Already SWITCH_ON_DISABLED.");
                    return;
                }
                case OPERATION_ENABLE: {
                    this.disableOperation();
                    this.disableVoltage();
                    return;
                }
                case SWITCHED_ON: 
                case READY_TO_SWITCH_ON: 
                case QUICKSTOP: {
                    this.disableVoltage();
                    return;
                }
                default: {
                    this.disableVoltage();
                    FCSLOG.severe(this.getName() + " is in BAD STATE " + state + ". This should not happen.");
                    return;
                }
            }
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Disable operation - writeControlWord[7] - and check that controller state is SWITCHED_ON. This command activates holding brake. cf doc EPOS2_Firmware_Specification \u00a7 3.2 Device Control")
    default public void disableOperation() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("EPOS-disableOperation-" + this.getName());){
            this.writeControlWord(EPOSEnumerations.ControlWord.DISABLE_OPERATION);
            this.checkState(EPOSEnumerations.EposState.SWITCHED_ON);
            FCSLOG.info(this.getName() + " Drive function is disabled.");
            this.publishData();
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Switch on and enable controller - writeControlWord[0xF] - and check that controller state is in state OPERATION_ENABLE within 500ms.")
    default public void switchOnEnableOperation() {
        this.writeControlWord(EPOSEnumerations.ControlWord.ENABLE_OPERATION);
        this.checkState(EPOSEnumerations.EposState.OPERATION_ENABLE);
        FCSLOG.info(this.getName() + " Drive function is enabled.");
        this.publishData();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Command(type=Command.CommandType.ACTION, level=1, description="Got to state OPERATION_ENABLE.cf doc EPOS2_Firmware_Specification \u00a7 3.2 Device Control")
    default public void goToOperationEnable() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("goToOperationEnable-EPOS-" + this.getName());){
            FCSLOG.info("goToOperationEnable entry state " + this.getEposState());
            this.checkFault();
            this.updateEposState();
            EPOSEnumerations.EposState state = this.getEposState();
            switch (state) {
                case OPERATION_ENABLE: {
                    FCSLOG.info(this.getName() + " Already in state OPERATION_ENABLE.");
                    return;
                }
                case SWITCH_ON_DISABLED: {
                    this.shutdownController();
                    this.switchOnEnableOperation();
                    return;
                }
                case SWITCHED_ON: 
                case READY_TO_SWITCH_ON: {
                    this.switchOnEnableOperation();
                    return;
                }
                default: {
                    throw new FcsHardwareException(this.getName() + " is in bad state " + state + ". This should not happen.");
                }
            }
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Stop action and goToSwitchOnDisabled controller.")
    default public void stopAction() {
        EPOSEnumerations.EposMode mode = this.getMode();
        switch (mode) {
            case HOMING: {
                this.writeControlWord(EPOSEnumerations.ControlWord.HALT_HOMING);
                break;
            }
            case CURRENT: {
                this.writeCurrent(0);
                break;
            }
            case PROFILE_POSITION: {
                this.stopPosition();
                break;
            }
            case PROFILE_VELOCITY: {
                this.stopVelocity();
                break;
            }
        }
        this.goToSwitchOnDisabled();
        FCSLOG.info(this.getName() + " ACTION STOPPED");
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="QuickStop.")
    default public void quickStop() {
        FCSLOG.finer(() -> this.getName() + " running QUICKSTOP command.");
        EPOSEnumerations.EposMode mode = this.getMode();
        switch (mode) {
            case HOMING: 
            case PROFILE_POSITION: 
            case VELOCITY: {
                this.writeControlWord(EPOSEnumerations.ControlWord.QUICK_STOP);
                break;
            }
            case CURRENT: {
                this.writeCurrent(0);
                break;
            }
            case MASTER_ENCODER: {
                break;
            }
            default: {
                throw new IllegalArgumentException(this.getName() + " has invalid Epos mode: " + mode);
            }
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="This command enables the controller : i.e. this makes it able to receive commands.it does shutdownController, then switchOnEnableOperation.")
    default public void enable() {
        this.shutdownController();
        this.switchOnEnableOperation();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if the controller is enabled, indicated by (statusWord & 0x6F) equaling 0x27.")
    default public boolean isEnabled() {
        int statusWord = this.readStatusWord();
        this.updateEposState(statusWord);
        return EPOSController.isOperationEnabled(statusWord);
    }

    public void changeMode(EPOSEnumerations.EposMode var1);

    public EPOSEnumerations.EposMode readMode();

    public EPOSEnumerations.EposMode getMode();

    default public boolean isInMode(EPOSEnumerations.EposMode aMode) {
        return aMode.equals((Object)this.getMode());
    }

    default public void checkEposMode(EPOSEnumerations.EposMode aMode) {
        EPOSEnumerations.EposMode myMode = this.readMode();
        if (aMode != myMode) {
            throw new FcsHardwareException(this.getName() + " is not in mode " + aMode);
        }
    }

    public int readCurrent();

    public int readCurrentAverageValue();

    public int readVelocity();

    public int readFollowingError();

    @Command(type=Command.CommandType.ACTION, level=1, description="In CURRENT mode this methods send a current to the motor. index:0x2030 subindex:0 size:2")
    public void writeCurrent(int var1) throws EPOSConfigurationException;

    @Command(type=Command.CommandType.ACTION, level=3, description="Enables controller and sets the current value in the EPOS CPU.")
    default public void enableAndWriteCurrent(int aValue) {
        this.goToOperationEnable();
        this.writeCurrent(aValue);
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Define the actual position as position given as argument.")
    default public void defineAbsolutePosition(int position) {
        FCSLOG.finer(() -> this.getName() + " Defining Absolute Position:" + position);
        this.changeMode(EPOSEnumerations.EposMode.HOMING);
        this.writeParameter(EPOSEnumerations.Parameter.HomePosition, position);
        this.writeParameter(EPOSEnumerations.Parameter.HomingMethod, 35);
        this.writeControlWord(EPOSEnumerations.ControlWord.SHUTDOWN);
        FcsUtils.sleep(50, this.getName());
        this.writeControlWord(EPOSEnumerations.ControlWord.SWITCH_ON);
        FcsUtils.sleep(50, this.getName());
        this.writeControlWord(EPOSEnumerations.ControlWord.ABSOLUTE_POSITION);
    }

    @Command(type=Command.CommandType.QUERY, level=3, description="Check if homing has been done otherwise throws an Exception.")
    default public void checkHomingDone() {
        long timeout = 500L;
        long timeStart = System.currentTimeMillis();
        long duration = 0L;
        while (!this.isHomingAttained() && duration <= timeout) {
            FCSLOG.info(this.getName() + " homing target not yet reached. duration=" + duration);
            duration = System.currentTimeMillis() - timeStart;
        }
        if (!this.isHomingAttained()) {
            throw new FcsHardwareException(this.getName() + " couldn't do homing : target is not reached within timeout of " + timeout + "milliseconds.");
        }
        this.writeControlWord(EPOSEnumerations.ControlWord.SWITCH_ON);
        FCSLOG.info(this.getName() + " ==> END homing");
    }

    default public void definePositionFromNegativeLimitSwitch() {
        FCSLOG.finer(() -> this.getName() + " Homing with homing method negative limit switch");
        this.changeMode(EPOSEnumerations.EposMode.HOMING);
        this.writeParameter(EPOSEnumerations.Parameter.HomePosition, 0);
        this.writeParameter(EPOSEnumerations.Parameter.HomingMethod, 17);
        this.goToOperationEnable();
        this.writeControlWord(EPOSEnumerations.ControlWord.ABSOLUTE_POSITION);
    }

    default public void defineHomingCurrentThresholdNegativeSpeed(int currentThreshold) {
        FCSLOG.finer(() -> this.getName() + " Homing with method Current Threshold Negative Speed");
        this.changeMode(EPOSEnumerations.EposMode.HOMING);
        this.writeParameter(EPOSEnumerations.Parameter.HomeOffset, 1000);
        this.writeParameter(EPOSEnumerations.Parameter.CurrentThresholdHomingMode, currentThreshold);
        this.writeParameter(EPOSEnumerations.Parameter.HomingMethod, -4);
        this.goToOperationEnable();
        this.writeControlWord(EPOSEnumerations.ControlWord.ABSOLUTE_POSITION);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="In PROFILE_POSITION Mode this methods returns the current position. index:0x6064 subindex:0")
    default public int readPosition() {
        int pos = (int)this.readParameter(EPOSEnumerations.Parameter.PositionActualValue);
        this.setPosition(pos);
        return pos;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="read HomingMethod parameter")
    default public byte readHomingMethod() {
        return (byte)this.readParameter(EPOSEnumerations.Parameter.HomingMethod);
    }

    public int getCurrent();

    public int getAverageCurrent();

    public int getFollowingError();

    public int getPosition();

    public int getVelocity();

    public long getProfileAcceleration();

    public long getProfileDeceleration();

    public long getProfileVelocity();

    public void setCurrent(int var1);

    public void setPosition(int var1);

    public void setVelocity(int var1);

    public void setProfileVelocity(long var1);

    public void setProfileAcceleration(long var1);

    public void setProfileDeceleration(long var1);

    @Command(type=Command.CommandType.QUERY, level=1, description="Read the position returned by the absolute encoder (single serial data) index:0x2211 subindex:3")
    default public int readSSIPosition() {
        return (int)this.readParameter(EPOSEnumerations.Parameter.SSIEncoderActualPosition);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read the controller structure : dual loop or not. Should be 0 or 1index:0x2220 subindex:0")
    default public int readControllerStructure() {
        return (int)this.readParameter(EPOSEnumerations.Parameter.ControllerStructure);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="In PROFILE_POSITION returns the value of the parameter ProfileVelocity. index:0x6081 subindex:0")
    default public long readProfileVelocity() {
        long profileVelocity = this.readParameter(EPOSEnumerations.Parameter.ProfileVelocity);
        this.setProfileVelocity(profileVelocity);
        FCSLOG.finer(() -> this.getName() + ":readProfileVelocity=" + profileVelocity);
        return profileVelocity;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="In PROFILE_POSITION returns the value of the parameter ProfileAcceleration. index:0x6083 subindex:0")
    default public long readProfileAcceleration() {
        long profileAcceleration = this.readParameter(EPOSEnumerations.Parameter.ProfileAcceleration);
        this.setProfileAcceleration(profileAcceleration);
        FCSLOG.finer(() -> this.getName() + ":readProfileAcceleration=" + profileAcceleration);
        return profileAcceleration;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="In PROFILE_POSITION returns the value of the parameter ProfileDeceleration. index:0x6084 subindex:0")
    default public long readProfileDeceleration() {
        long profileDeceleration = this.readParameter(EPOSEnumerations.Parameter.ProfileDeceleration);
        this.setProfileDeceleration(profileDeceleration);
        FCSLOG.finer(() -> this.getName() + ":readProfileDeceleration=" + profileDeceleration);
        return profileDeceleration;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read PositionSensorType. index:0x2210 subindex:2")
    default public int readPositionSensorType() {
        return (int)this.readParameter(EPOSEnumerations.Parameter.PositionSensorType);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="In PROFILE_POSITION mode this methods set the target position.index:0x607A subindex:0 size:4")
    public void writeTargetPosition(int var1);

    default public void changeProfileVelocity(int newVelocity) {
        FCSLOG.info(this.getName() + " changing ProfileVelocity to " + newVelocity);
        try {
            this.writeParameter(EPOSEnumerations.Parameter.ProfileVelocity, newVelocity);
            this.setProfileVelocity(newVelocity);
        }
        catch (Exception ex) {
            String msg = this.getName() + " : could not change ProfileVelocity to value " + newVelocity;
            FCSLOG.severe(msg);
            throw new FcsHardwareException(msg, ex);
        }
    }

    default public void changeProfileAcceleration(int newAcceleration) {
        FCSLOG.info(this.getName() + " changing ProfileAcceleration to " + newAcceleration);
        try {
            this.writeParameter(EPOSEnumerations.Parameter.ProfileAcceleration, newAcceleration);
            this.setProfileAcceleration(newAcceleration);
        }
        catch (Exception ex) {
            String msg = this.getName() + " : could not change ProfileAcceleration to value " + newAcceleration;
            FCSLOG.severe(msg);
            throw new FcsHardwareException(msg, ex);
        }
    }

    default public void changeProfileDeceleration(int newDeceleration) {
        FCSLOG.info(this.getName() + " changing ProfileDeceleration to " + newDeceleration);
        try {
            this.writeParameter(EPOSEnumerations.Parameter.ProfileDeceleration, newDeceleration);
            this.setProfileDeceleration(newDeceleration);
        }
        catch (Exception ex) {
            String msg = this.getName() + " : could not change ProfileDeceleration to value " + newDeceleration;
            FCSLOG.severe(msg);
            throw new FcsHardwareException(msg, ex);
        }
    }

    public boolean isParametersOK();

    public long readParameter(EPOSEnumerations.Parameter var1);

    public void writeParameter(EPOSEnumerations.Parameter var1, int var2);

    public void checkParameters(EPOSEnumerations.EposMode var1);

    public void writeParameters(EPOSEnumerations.EposMode var1);

    @Command(type=Command.CommandType.ACTION, level=3, description="Write in the CPU of the EPOS device the values of the parameters set for the mode.")
    default public void writeParameters() {
        this.readMode();
        this.writeParameters(this.getMode());
    }

    @Command(name="readParameter", type=Command.CommandType.QUERY, level=1, description="Reads in the EPOS CPU the value of the selected parameter")
    default public long readParameterFromList(@Argument(allowedValueProvider="getEPOSParameters", description="Parameter name") String name) {
        EPOSEnumerations.Parameter param = EPOSEnumerations.Parameter.valueOf(name);
        return this.readParameter(param);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read the parameters for the actual mode.")
    default public String readParameters() {
        return this.readParametersForMode(this.readMode());
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="This methods reads in the CPU of the EPOS the values of the parameters for a given mode.")
    default public String readParametersForMode(EPOSEnumerations.EposMode aMode) {
        EPOSEnumerations.Parameter[] params;
        String modeIS = aMode.toString();
        StringBuilder sb = new StringBuilder(this.getName() + " parameters VALUES in decimal format for mode ");
        sb.append(modeIS);
        sb.append("\n");
        for (EPOSEnumerations.Parameter param : params = aMode.getParameters()) {
            sb.append(param.toString());
            sb.append("=");
            long valueInt = this.readParameter(param);
            sb.append(valueInt);
            sb.append("\n");
        }
        FCSLOG.finer(() -> this.getName() + sb.toString());
        return sb.toString();
    }

    default public void writeParameters(Map<String, Integer> paramMap) {
        for (Map.Entry<String, Integer> entry : paramMap.entrySet()) {
            String paramName = entry.getKey();
            int value = entry.getValue();
            this.writeParameter(EPOSEnumerations.Parameter.valueOf(paramName), value);
        }
    }

    public static long convertEPOSValue(EPOSEnumerations.Parameter param, long value, String myName) {
        if (!param.isSigned()) {
            return value;
        }
        if (param.getSize() == 4) {
            return (int)value;
        }
        if (param.getSize() == 2) {
            return (short)value;
        }
        if (param.getSize() == 1) {
            return (byte)value;
        }
        throw new EPOSConfigurationException(myName + ":\f" + param.getSize() + " => bad value for size");
    }

    public boolean isInError();

    public String getErrorRegister();

    public int getLastErrorCode();

    public String getLastErrorName();

    public int getErrorHistoryNB();

    public String updateAndDisplayErrorHistory();

    public void checkFault();

    public void checkFault(boolean var1);

    public void faultReset();

    @Command(type=Command.CommandType.QUERY, level=1, description="In HOMING mode and PROFILE_POSITION mode this indicates that the position is reached. (bit 10 of status word is 1)")
    default public boolean isTargetReached() {
        int bit10 = this.readStatusWord() >> 10 & 1;
        return bit10 == 1;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="In HOMING mode this indicates that homing is done for the controller.(bit 12 of status word is 1)")
    default public boolean isHomingAttained() {
        int bit12 = this.readStatusWord() >> 12 & 1;
        return bit12 == 1;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Reads the homing status on the controller, True means that the homing as been done and is still in memory.")
    default public boolean checkHomingStatusOnController() {
        int statusWord = this.readStatusWord();
        return (statusWord >> 15 & 1) == 1;
    }

    default public void checkTargetReached(long timeout) {
        long timeStart = System.currentTimeMillis();
        long duration = 0L;
        while (!this.isTargetReached() && duration <= timeout) {
            FCSLOG.info(this.getName() + " target is not yet reached.");
            duration = System.currentTimeMillis() - timeStart;
        }
        if (!this.isTargetReached()) {
            String msg = this.getName() + " couldn't reach target during time allocated of " + timeout + " ms";
            FCSLOG.info(msg);
            throw new FcsHardwareException(msg);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Enable controller and go to absolute position. Doesn't check condition. DANGER !!!! ")
    default public void enableAndWriteAbsolutePosition(int pos) {
        this.goToOperationEnable();
        this.writeTargetPosition(pos);
        this.writeControlWord(EPOSEnumerations.ControlWord.ABSOLUTE_POSITION_AND_MOVE);
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Enable controller and go to relative position. Doesn't check condition. DANGER !!!! ")
    default public void enableAndWriteRelativePosition(int pos) {
        this.goToOperationEnable();
        this.writeTargetPosition(pos);
        this.writeControlWord(EPOSEnumerations.ControlWord.RELATIVE_POSITION_AND_MOVE);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Stop motion when in mode PROFILE_POSITION. (writeControlWord(0x010F))")
    default public void stopPosition() {
        if (!this.isInMode(EPOSEnumerations.EposMode.PROFILE_POSITION)) {
            throw new RejectedCommandException(this.getName() + " is not in PROFILE_POSITION mode.");
        }
        this.writeControlWord(EPOSEnumerations.ControlWord.STOP_POSITIONING);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Stop motion when in mode PROFILE_VELOCITY. (writeControlWord(0x0107)")
    default public void stopVelocity() {
        if (!this.isInMode(EPOSEnumerations.EposMode.PROFILE_VELOCITY)) {
            throw new RejectedCommandException(this.getName() + " is not in PROFILE_VELOCITY mode.");
        }
        this.writeControlWord(263);
    }

    default public void updateDataDuringMotionFromSDO() {
        this.readCurrent();
        this.readCurrentAverageValue();
        this.readFollowingError();
        this.readPosition();
        this.readVelocity();
    }

    default public StatusDataPublishedByEPOSController createStatusDataPublishedByEPOSController() {
        StatusDataPublishedByEPOSController status = new StatusDataPublishedByEPOSController(this.isBooted(), this.isInitialized(), this.isInError(), this.getErrorRegister(), this.getErrorHistoryNB(), this.getLastErrorCode(), this.getLastErrorName());
        status.setMode(this.getMode());
        status.setState(this.getEposState());
        status.setCurrent(this.getCurrent());
        status.setPosition(this.getPosition());
        status.setVelocity(this.getVelocity());
        status.setProfileAcceleration(this.getProfileAcceleration());
        status.setProfileDeceleration(this.getProfileDeceleration());
        status.setProfileVelocity(this.getProfileVelocity());
        status.setAverageCurrent(this.getAverageCurrent());
        status.setFollowingError(this.getFollowingError());
        return status;
    }

    default public StatusDataPublishedDuringMotionNoEncoder createStatusDataPublishedDuringMotionNoEncoder() {
        StatusDataPublishedDuringMotionWithEncoder status = new StatusDataPublishedDuringMotionWithEncoder();
        status.setCurrent(this.getCurrent());
        status.setAverageCurrent(this.getAverageCurrent());
        status.setVelocity(this.getVelocity());
        return status;
    }

    default public StatusDataPublishedDuringMotionWithEncoder createStatusDataPublishedDuringMotionWithEncoder() {
        StatusDataPublishedDuringMotionWithEncoder status = new StatusDataPublishedDuringMotionWithEncoder();
        status.setCurrent(this.getCurrent());
        status.setAverageCurrent(this.getAverageCurrent());
        status.setVelocity(this.getVelocity());
        status.setFollowingError(this.getFollowingError());
        status.setPosition(this.getPosition());
        return status;
    }

    public void publishDataDuringMotion();
}

