/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.motorplatform.bot;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.aerotech.AerotechPro165;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;
import org.lsst.ccs.drivers.keyence.KeyenceG5001;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystem.motorplatform.bot.AnalogInput;
import org.lsst.ccs.subsystem.motorplatform.bot.Axis;
import org.lsst.ccs.subsystem.motorplatform.bot.DigitalInput;
import org.lsst.ccs.subsystem.motorplatform.bot.DigitalOutput;
import org.lsst.ccs.subsystem.motorplatform.bus.AxisStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.ChangeAxisEnable;
import org.lsst.ccs.subsystem.motorplatform.bus.ChangeOutputLine;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAllFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAxisFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearCapture;
import org.lsst.ccs.subsystem.motorplatform.bus.ControllerStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.EnableAllAxes;
import org.lsst.ccs.subsystem.motorplatform.bus.HomeAxis;
import org.lsst.ccs.subsystem.motorplatform.bus.IOStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.MotorCommandListener;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisAbsolute;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisRelative;
import org.lsst.ccs.subsystem.motorplatform.bus.PlatformConfig;
import org.lsst.ccs.subsystem.motorplatform.bus.SendAxisStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.SendConfiguration;
import org.lsst.ccs.subsystem.motorplatform.bus.SendControllerStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.SetupCapture;
import org.lsst.ccs.subsystem.motorplatform.bus.StopAllMotion;
import org.lsst.ccs.subsystem.motorplatform.bus.bot.LampStatus;
import org.lsst.ccs.subsystem.motorplatform.main.CheckException;
import org.lsst.ccs.utilities.logging.Logger;

public class Ensemble
implements MotorCommandListener,
HasLifecycle {
    private static final Logger LOG = Logger.getLogger((String)Ensemble.class.getName());
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private List<Axis> axisComponents = Collections.synchronizedList(new ArrayList());
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private List<DigitalInput> digitalIns = Collections.synchronizedList(new ArrayList());
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private List<DigitalOutput> digitalOuts = Collections.synchronizedList(new ArrayList());
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private List<AnalogInput> analogs = Collections.synchronizedList(new ArrayList());
    @ConfigurationParameter(description="The name of the configuration used.")
    private volatile String configurationName = "<safe default>";
    @ConfigurationParameter(description="How often to check for the completion of a long-running operation such as a move.")
    private volatile Duration completionCheckInterval = Duration.ofMillis(100L);
    @ConfigurationParameter(description="The timeout to use for simple actions that don't cause motion.")
    private volatile Duration briefActionTimeout = Duration.ofMillis(10L);
    @ConfigurationParameter(description="The IP address of the motor controller.")
    private volatile String IPv4Address = "192.168.10.40";
    @ConfigurationParameter(description="The interval between periodic status updates.")
    private volatile Duration statusUpdateInterval = Duration.ofMillis(1000L);
    @ConfigurationParameter(description="The serial port device name for the Keyence comm link.")
    private volatile String keyenceCommPort = "/dev/ttyS0";
    @ConfigurationParameter(description="The baud rate for the Keyence comm link.")
    private volatile int keyenceBaud = 115200;
    @ConfigurationParameter(description="How long to wait for a reply to a chat command.")
    private volatile Duration chatTimeout = Duration.ofSeconds(300L);
    @ConfigurationParameter(description="Camera coordinate of BOT X=0 (mm).")
    private volatile double xcam0 = 0.0;
    @ConfigurationParameter(description="Camera coordinate of BOT Y=0 (mm).")
    private volatile double ycam0 = 0.0;
    @ConfigurationParameter(description="The rotation angle from camera to BOT axes (rad).")
    private volatile double phi = Math.PI;
    private volatile Map<String, Axis> axisMap;
    private volatile ExecutorService programExec;
    private volatile ScheduledExecutorService miscExec;
    private volatile AerotechPro165 programLink;
    private volatile BlockingQueue<AerotechPro165> miscLink;
    private volatile BlockingQueue<KeyValueData> resultQueue;
    private volatile Instant currentActionDeadline;
    private volatile String commStatus;
    private volatile String actionStatus;
    private volatile KeyenceG5001 keyence;
    private volatile double xoff_ls = 0.0;
    private volatile double yoff_ls = 0.0;
    private static final Pattern tmop = Pattern.compile("^\\s*CHAT\\s+TIMEOUT\\s+(\\d+|DEFAULT)\\s*$", 2);
    private final int PROGRAM_LINK_PORT = 8000;
    private final int MISC_LINK_PORT = 8001;

    private Ensemble() {
    }

    public KeyValueData getNextResult() throws InterruptedException {
        return this.resultQueue.take();
    }

    public void start() {
        try {
            this.initializeKeyence();
        }
        catch (DriverException exc) {
            throw new RuntimeException(exc);
        }
        try {
            this.createCommLinks();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.setActionDeadline(this.briefActionTimeout);
        this.resultQueue = new ArrayBlockingQueue<KeyValueData>(1000);
        this.axisMap = new TreeMap<String, Axis>();
        for (Axis a : this.axisComponents) {
            this.axisMap.put(a.getName(), a);
        }
        this.digitalIns.sort((x, y) -> Integer.compare(x.getOrder(), y.getOrder()));
        this.digitalOuts.sort((x, y) -> Integer.compare(x.getOrder(), y.getOrder()));
        this.analogs.sort((x, y) -> Integer.compare(x.getOrder(), y.getOrder()));
        this.commStatus = "UP";
        this.actionStatus = "OK";
        this.programExec = Executors.newSingleThreadExecutor();
        this.miscExec = Executors.newSingleThreadScheduledExecutor();
        this.clearAllFaults(new ClearAllFaults());
        long updateMillis = this.statusUpdateInterval.toMillis();
        this.miscExec.scheduleAtFixedRate(this::publishAll, 0L, updateMillis, TimeUnit.MILLISECONDS);
        this.miscExec.scheduleAtFixedRate(this::restartProcessing, updateMillis, updateMillis, TimeUnit.MILLISECONDS);
    }

    private void initializeKeyence() throws DriverException {
        this.keyence = new KeyenceG5001();
        this.keyence.open(DriverConstants.ConnType.SERIAL, this.keyenceCommPort, this.keyenceBaud);
        this.keyence.setTimeout((double)this.chatTimeout.toMillis());
    }

    public void shutdown() {
        try {
            this.programExec.shutdownNow();
            this.programExec.awaitTermination(50L, TimeUnit.MILLISECONDS);
            this.miscExec.shutdownNow();
            this.miscExec.awaitTermination(50L, TimeUnit.MILLISECONDS);
            this.stopEverything();
            this.keyence.close();
        }
        catch (InterruptedException exc) {
            LOG.log(Level.SEVERE, "Hardware shutdown was interrupted!", (Throwable)exc);
            Thread.currentThread().interrupt();
        }
        catch (DriverException exc) {
            throw new RuntimeException(exc);
        }
        finally {
            this.commStatus = "DOWN";
            this.actionStatus = "STOPPED";
        }
    }

    @Command(description="Executes a Keyence command and returns the result string.", level=1, timeout=3600)
    public String keyenceChat(@Argument(name="command", description="The Keyence command.") String command) {
        try {
            SynchronousQueue result = new SynchronousQueue();
            this.miscExec.submit(() -> this.runChatCommand(command, false, result));
            return (String)result.take();
        }
        catch (RejectedExecutionException exc) {
            return "ERROR: SHUTDOWN";
        }
        catch (InterruptedException exc) {
            return "ERROR: INTERRUPTED";
        }
    }

    @Command(description="Executes an Aerotech command and returns the result string.", level=1, timeout=3600)
    public String aerotechChat(@Argument(name="command", description="The Aerotech command.") String command) {
        try {
            SynchronousQueue result = new SynchronousQueue();
            this.miscExec.submit(() -> this.runChatCommand(command, true, result));
            return (String)result.take();
        }
        catch (RejectedExecutionException exc) {
            return "ERROR: SHUTDOWN";
        }
        catch (InterruptedException exc) {
            return "ERROR: INTERRUPTED";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runChatCommand(String command, boolean isAerotech, SynchronousQueue<String> result) {
        AerotechPro165 sender = isAerotech ? this.borrowMiscLink() : this.keyence;
        Matcher m = tmop.matcher(command);
        try {
            if (m.matches()) {
                if (m.group(1).toUpperCase().equals("DEFAULT")) {
                    sender.setTimeout((double)this.chatTimeout.toMillis());
                } else {
                    sender.setTimeout(1000 * Integer.valueOf(m.group(1)));
                }
                result.put("DONE");
            } else {
                String reply = sender.read(command);
                result.put(reply);
            }
        }
        catch (DriverTimeoutException exc) {
            try {
                result.put("ERROR: READ TIMEOUT");
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        catch (DriverException exc) {
            try {
                result.put("ERROR: ASCII DRIVER EXCEPTION " + exc.getMessage());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        catch (NumberFormatException exc) {
            try {
                result.put("ERROR: BAD NUMBER");
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        catch (InterruptedException exc) {
            result.offer("ERROR: INTERRUPTED");
        }
        catch (Exception exc) {
            try {
                result.put("ERROR: EXCEPTION " + exc.getMessage());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        finally {
            if (isAerotech) {
                this.returnMiscLink(sender);
            }
        }
    }

    public void changeAxisEnable(ChangeAxisEnable cmd) {
        this.runProgramCall(aero -> {
            Axis axis = this.getAxis(cmd.getAxisName());
            if (cmd.isEnabled()) {
                axis.enable((AerotechPro165)aero);
            } else {
                axis.disable((AerotechPro165)aero);
            }
            this.sendAxisStatus(new SendAxisStatus(cmd.getAxisName()));
        }, "changeAxisEnable", this.briefActionTimeout);
    }

    public void changeOutputLine(ChangeOutputLine cmd) {
        DigitalOutput out = this.digitalOuts.get(cmd.getLineIndex());
        this.runProgramCall(aero -> out.setState((AerotechPro165)aero, cmd.getNewState()), "changeOutputLine", this.briefActionTimeout);
        this.publishIOStatus();
    }

    public void clearAllFaults(ClearAllFaults cmd) {
        this.runProgramCall(aero -> {
            this.acknowledgeAll((AerotechPro165)aero);
            this.axisMap.values().stream().forEach(axis -> this.sendAxisStatus(new SendAxisStatus(axis.getName())));
        }, "clearAllFaults", this.briefActionTimeout);
    }

    public void clearAxisFaults(ClearAxisFaults cmd) {
        this.runProgramCall(aero -> {
            Axis axis = this.getAxis(cmd.getAxisName());
            axis.clearFaults((AerotechPro165)aero);
            this.sendAxisStatus(new SendAxisStatus(cmd.getAxisName()));
        }, "clearAxisFaults", this.briefActionTimeout);
    }

    public void clearCapture(ClearCapture cmd) {
    }

    public void enableAllAxes(EnableAllAxes cmd) {
        this.runProgramCall(aero -> this.axisMap.keySet().stream().forEach(name -> {
            this.axisMap.get(name).enable((AerotechPro165)aero);
            this.sendAxisStatus(new SendAxisStatus(name));
        }), "enableAllAxes", this.briefActionTimeout);
    }

    public void moveAxisRelative(MoveAxisRelative cmd) {
        this.runProgramCall(aero -> {
            Axis axis = this.getAxis(cmd.getAxisName());
            axis.moveRelative((AerotechPro165)aero, cmd);
            this.sendAxisStatus(new SendAxisStatus(cmd.getAxisName()));
        }, aero -> {
            Axis axis = this.getAxis(cmd.getAxisName());
            ArrayList<String> codes = new ArrayList<String>(2);
            int ccode = axis.getMoveCompletionCode((AerotechPro165)aero);
            boolean hasFaults = axis.hasFaults((AerotechPro165)aero);
            if (ccode != 0) {
                codes.add(String.format("CODE %d", ccode));
            }
            if (hasFaults) {
                codes.add("FAULT");
            }
            if (!codes.isEmpty()) {
                throw new CheckException(String.join((CharSequence)",", codes), String.format("Move on %s axis failed.", axis.getName()));
            }
        }, "moveAxisRelative", () -> {
            Axis axis = this.getAxis(cmd.getAxisName());
            return axis.getRelativeMoveTimeout(cmd);
        });
    }

    public void moveAxisAbsolute(MoveAxisAbsolute cmd) {
        this.runProgramCall(aero -> {
            Axis axis = this.getAxis(cmd.getAxisName());
            axis.moveAbsolute((AerotechPro165)aero, cmd);
            this.sendAxisStatus(new SendAxisStatus(cmd.getAxisName()));
        }, aero -> {
            Axis axis = this.getAxis(cmd.getAxisName());
            ArrayList<String> codes = new ArrayList<String>(2);
            int ccode = axis.getMoveCompletionCode((AerotechPro165)aero);
            boolean hasFaults = axis.hasFaults((AerotechPro165)aero);
            if (ccode != 0) {
                codes.add(String.format("CODE %d", ccode));
            }
            if (hasFaults) {
                codes.add("FAULT");
            }
            if (!codes.isEmpty()) {
                throw new CheckException(String.join((CharSequence)",", codes), String.format("Move on %s axis failed.", axis.getName()));
            }
        }, "moveAxisAbsolute", () -> {
            Axis axis = this.getAxis(cmd.getAxisName());
            return axis.getAbsoluteMoveTimeout(cmd);
        });
    }

    public void homeAxis(HomeAxis cmd) {
        Axis ax = this.axisMap.get(cmd.getAxisName());
        this.runProgramCall(aero -> {
            Axis axis = this.getAxis(cmd.getAxisName());
            axis.home((AerotechPro165)aero);
            this.sendAxisStatus(new SendAxisStatus(cmd.getAxisName()));
        }, aero -> {
            Axis axis = this.getAxis(cmd.getAxisName());
            int ccode = axis.getHomingCompletionCode((AerotechPro165)aero);
            if (ccode != 0) {
                throw new CheckException(String.format("CODE %d", ccode), String.format("Homing on %s axis failed.", axis.getName()));
            }
        }, "homeAxis", () -> {
            Axis axis = this.getAxis(cmd.getAxisName());
            return axis.getHomingTimeout();
        });
    }

    public void sendAxisStatus(SendAxisStatus cmd) {
        this.publishAxisStatus(cmd.getAxisName());
    }

    public void sendConfiguration(SendConfiguration cmd) {
        PlatformConfig config = this.getConfiguration();
        try {
            this.resultQueue.put(new KeyValueData("PlatformConfig", (Serializable)config));
        }
        catch (InterruptedException ex) {
            LOG.log(Level.SEVERE, "Sending of platform configuration was interrupted.", (Throwable)ex);
            Thread.currentThread().interrupt();
        }
    }

    public PlatformConfig getConfiguration() {
        ArrayList<Axis> axes = new ArrayList<Axis>(this.axisComponents);
        axes.sort((x, y) -> Integer.compare(x.getIndex(), y.getIndex()));
        ArrayList<DigitalInput> dins = new ArrayList<DigitalInput>(this.digitalIns);
        dins.sort((x, y) -> Integer.compare(x.getOrder(), y.getOrder()));
        ArrayList<DigitalOutput> douts = new ArrayList<DigitalOutput>(this.digitalOuts);
        douts.sort((x, y) -> Integer.compare(x.getOrder(), y.getOrder()));
        ArrayList<AnalogInput> ains = new ArrayList<AnalogInput>(this.analogs);
        ains.sort((x, y) -> Integer.compare(x.getOrder(), y.getOrder()));
        PlatformConfig config = new PlatformConfig(axes.stream().map(Axis::getName).collect(Collectors.toList()), Collections.emptyList(), dins.stream().map(DigitalInput::getName).collect(Collectors.toList()), douts.stream().map(DigitalOutput::getName).collect(Collectors.toList()), ains.stream().map(AnalogInput::getDescription).collect(Collectors.toList()), this.configurationName, axes.stream().map(Axis::getUnits).collect(Collectors.toList()));
        return config;
    }

    public void sendControllerStatus(SendControllerStatus cmd) {
        this.publishControllerStatus();
    }

    public void setupCapture(SetupCapture cmd) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAllMotion(StopAllMotion cmd) {
        AerotechPro165 aero = null;
        String actstat = "FAILED";
        try {
            aero = this.borrowMiscLink();
            String cmdstr = this.axisMap.values().stream().map(Axis::getName).collect(Collectors.joining(" ", "ABORT ", ""));
            aero.writeAP(cmdstr);
            this.programExec.shutdownNow();
            this.programExec = Executors.newSingleThreadExecutor();
            actstat = "OK";
        }
        catch (NullPointerException ex) {
            LOG.log(Level.SEVERE, "A stop-all-motion request timed out!", (Throwable)ex);
        }
        catch (DriverException ex) {
            LOG.log(Level.SEVERE, "A stop-all-motion request failed!", (Throwable)ex);
        }
        finally {
            this.returnMiscLink(aero);
            this.actionStatus = actstat;
        }
    }

    public Map<String, Double> getLampParameters() {
        HashMap<String, Double> parms = new HashMap<String, Double>(5);
        parms.put("xcam0", this.xcam0);
        parms.put("ycam0", this.ycam0);
        parms.put("phi", this.phi);
        parms.put("xoff_ls", this.xoff_ls);
        parms.put("yoff_ls", this.yoff_ls);
        return Collections.unmodifiableMap(parms);
    }

    public void setLampPosition(double xcam, double ycam) {
        List<Double> xybot = this.cameraToBot(xcam, ycam);
        this.moveAxisAbsolute(new MoveAxisAbsolute("X", xybot.get(0).doubleValue(), this.getAxis("X").getMaxSpeed()));
        this.moveAxisAbsolute(new MoveAxisAbsolute("Y", xybot.get(1).doubleValue(), this.getAxis("Y").getMaxSpeed()));
    }

    public void setLampOffset(double xoff_ls, double yoff_ls) {
        this.xoff_ls = xoff_ls;
        this.yoff_ls = yoff_ls;
    }

    private List<Double> cameraToBot(double xcam, double ycam) {
        double xbot = (xcam - this.xcam0) * Math.cos(this.phi) + (ycam - this.ycam0) * Math.sin(this.phi) - this.xoff_ls;
        double ybot = -(xcam - this.xcam0) * Math.sin(this.phi) + (ycam - this.ycam0) * Math.cos(this.phi) - this.yoff_ls;
        return Collections.unmodifiableList(Arrays.asList(xbot, ybot));
    }

    private List<Double> botToCamera(double xbot, double ybot) {
        double xcam = (xbot + this.xoff_ls) * Math.cos(this.phi) - (ybot + this.yoff_ls) * Math.sin(this.phi) + this.xcam0;
        double ycam = (xbot + this.xoff_ls) * Math.sin(this.phi) + (ybot + this.yoff_ls) * Math.cos(this.phi) + this.ycam0;
        return Collections.unmodifiableList(Arrays.asList(xcam, ycam));
    }

    private void restartProcessing() {
        if (this.programExec.isShutdown()) {
            // empty if block
        }
    }

    private void publishIOStatus() {
        this.runProgramCall(aero -> {
            int dins = 0;
            int douts = 0;
            ArrayList<Double> anas = new ArrayList<Double>();
            if (this.digitalIns.size() > 0) {
                DigitalInput digi = this.digitalIns.get(0);
                String axis = digi.getAxis().getName();
                int port = digi.getPort();
                dins = (int)aero.readDoubleAP(String.format("DIN(%s,%d)", axis, port));
            }
            for (AnalogInput ana : this.analogs) {
                String axis = ana.getAxis().getName();
                int chan = ana.getChannel();
                anas.add(aero.readDoubleAP(String.format("AIN(%s,%d)", axis, chan)));
            }
            this.resultQueue.put(new KeyValueData("IOStatus", (Serializable)new IOStatus(dins, douts, anas)));
        }, "publishIOStatus", this.briefActionTimeout);
    }

    private void publishControllerStatus() {
        this.runProgramCall(aero -> {
            boolean motionEnabled = false;
            try {
                motionEnabled = !this.checkEstop((AerotechPro165)aero);
            }
            catch (Exception exc) {
                this.commStatus = "DOWN";
            }
            ControllerStatus status = new ControllerStatus(this.commStatus, motionEnabled, this.actionStatus);
            this.resultQueue.put(new KeyValueData("ControllerStatus", (Serializable)status));
        }, "controllerStatus", this.briefActionTimeout);
    }

    private void publishAll() {
        this.publishControllerStatus();
        this.publishIOStatus();
        this.runProgramCall(acr -> {
            AxisStatus xstatus = this.getAxis("X").getStatus((AerotechPro165)acr);
            AxisStatus ystatus = this.getAxis("Y").getStatus((AerotechPro165)acr);
            boolean isMoving = xstatus.isMoving() || ystatus.isMoving();
            boolean hasFault = 0 < xstatus.getFaults().size() + ystatus.getFaults().size();
            double xbot = xstatus.getPosition();
            double ybot = ystatus.getPosition();
            List<Double> xycam = this.botToCamera(xbot, ybot);
            LampStatus lamp = new LampStatus(xycam.get(0).doubleValue(), xycam.get(1).doubleValue(), xbot, ybot, isMoving, hasFault);
            this.resultQueue.put(new KeyValueData("AxisStatus/X", (Serializable)xstatus));
            this.resultQueue.put(new KeyValueData("AxisStatus/Y", (Serializable)ystatus));
            this.resultQueue.put(new KeyValueData("LampStatus", (Serializable)lamp));
            if (this.axisMap.containsKey("THETA")) {
                AxisStatus tstatus = this.getAxis("THETA").getStatus((AerotechPro165)acr);
                this.resultQueue.put(new KeyValueData("AxisStatus/THETA", (Serializable)tstatus));
            }
        }, "axisStatus", this.briefActionTimeout.multipliedBy(10L));
    }

    private void publishAxisStatus(String axisName) {
        this.runMiscCommand(acr -> {
            Axis axis = this.getAxis(axisName);
            String key = String.format("AxisStatus/%s", axisName);
            this.resultQueue.put(new KeyValueData(key, (Serializable)axis.getStatus((AerotechPro165)acr)));
        }, this.briefActionTimeout);
    }

    private void runProgramCall(MyConsumer<AerotechPro165> action, MyConsumer<AerotechPro165> postCheck, String actionName, Supplier<Duration> actionTimeout) {
        if (!this.programExec.isShutdown()) {
            String[] actstat = new String[]{"FAILED"};
            this.programExec.submit(() -> {
                AerotechPro165 aero = null;
                try {
                    aero = this.programLink;
                    this.waitForIdleController(aero);
                    this.setActionDeadline((Duration)actionTimeout.get());
                    action.accept(aero);
                    this.waitForIdleController(aero);
                    if (postCheck != null) {
                        postCheck.accept(aero);
                    }
                    actstat[0] = "OK";
                }
                catch (InterruptedException exc) {
                    LOG.log(Level.SEVERE, "{0} was interrupted. {1}", new Object[]{actionName, exc});
                }
                catch (TimeoutException exc) {
                    LOG.log(Level.SEVERE, "{0} timed out. {1}", new Object[]{actionName, exc});
                    actstat[0] = "TIMEOUT";
                }
                catch (CheckException exc) {
                    actstat[0] = exc.getCode();
                    LOG.log(Level.SEVERE, "{0} failed its post-check. {1}", new Object[]{actionName, exc});
                    actstat[0] = exc.getCode();
                }
                catch (Exception exc) {
                    LOG.log(Level.SEVERE, "{0} threw an exception. {1}", new Object[]{actionName, exc});
                    this.cleanupAfterProgramFailure(exc);
                    this.commStatus = "DOWN";
                }
                finally {
                    this.actionStatus = actstat[0];
                }
            });
        }
    }

    private void runProgramCall(MyConsumer<AerotechPro165> action, String actionName, Duration actionTimeout) {
        this.runProgramCall(action, null, actionName, () -> actionTimeout);
    }

    private void runMiscCommand(MyConsumer<AerotechPro165> action, Duration actionTimeout) {
        if (!this.miscExec.isShutdown()) {
            this.miscExec.submit(() -> {
                AerotechPro165 aero = null;
                try {
                    aero = this.borrowMiscLink();
                    action.accept(aero);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception exc) {
                    LOG.log(Level.WARNING, "Command failure.", (Throwable)exc);
                }
                finally {
                    this.returnMiscLink(aero);
                }
            });
        }
    }

    private void runKeyenceCommand(String action, SynchronousQueue<String> result) {
        if (!this.programExec.isShutdown()) {
            this.programExec.submit(() -> {
                try {
                    result.put(this.keyence.read(action));
                }
                catch (InterruptedException exc) {
                    LOG.log(Level.SEVERE, "{0} was interrupted. {1}", new Object[]{action, exc});
                }
                catch (Exception exc) {
                    LOG.log(Level.SEVERE, "{0} threw an exception. {1}", new Object[]{action, exc});
                }
            });
        }
    }

    private void waitForIdleController(AerotechPro165 aero) throws TimeoutException, InterruptedException, DriverException {
        while (true) {
            Instant now = Instant.now();
            TaskState state = TaskState.values()[(int)aero.readDoubleAP("TASKSTATE(1)")];
            if (state != TaskState.RUNNING && state != TaskState.PAUSED) break;
            if (Instant.now().isAfter(this.currentActionDeadline)) {
                throw new TimeoutException("Timeout waiting for controller programs to stop running.");
            }
            Thread.sleep(this.completionCheckInterval.toMillis());
        }
    }

    private void cleanupAfterProgramFailure(Exception exc) {
        this.programExec.shutdownNow();
        LOG.log(Level.WARNING, "Program call failed. Commencing cleanup.", (Throwable)exc);
        try {
            this.stopEverything();
        }
        catch (Exception exc2) {
            LOG.log(Level.WARNING, "Unable to stop motion after a program call failed.", (Throwable)exc2);
        }
    }

    private Axis getAxis(String name) throws IllegalArgumentException {
        Axis axis = this.axisMap.get(name);
        if (axis == null) {
            throw new IllegalArgumentException(String.format("%s is a bad axis name.", name));
        }
        return axis;
    }

    private void setActionDeadline(Duration timeout) {
        this.currentActionDeadline = Instant.now().plus(timeout);
    }

    private AerotechPro165 borrowMiscLink() {
        try {
            return this.miscLink.take();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(ex);
        }
    }

    private void returnMiscLink(AerotechPro165 aero) {
        this.miscLink.add(aero);
    }

    private void discardMiscLink() {
        try {
            ArrayList links = new ArrayList();
            this.miscLink.drainTo(links);
            for (AerotechPro165 aero : links) {
                aero.close();
            }
        }
        catch (DriverException ex) {
            throw new Error(ex);
        }
    }

    private void discardProgramLink() {
        try {
            this.programLink.close();
        }
        catch (DriverException ex) {
            throw new Error(ex);
        }
        finally {
            this.programLink = null;
        }
    }

    private void stopEverything() throws InterruptedException {
        AerotechPro165 aero = this.borrowMiscLink();
        String abort = this.axisMap.values().stream().map(Axis::getName).collect(Collectors.joining(" ", "ABORT ", ""));
        try {
            aero.writeAP("PROGRAM STOP 1");
            aero.writeAP(abort);
        }
        catch (DriverException ex) {
            throw new Error(ex);
        }
        finally {
            this.returnMiscLink(aero);
        }
    }

    private void createCommLinks() throws DriverException {
        this.programLink = new AerotechPro165();
        this.programLink.openNet(this.IPv4Address, 8000);
        this.miscLink = new ArrayBlockingQueue<AerotechPro165>(1);
        AerotechPro165 misc = new AerotechPro165();
        misc.openNet(this.IPv4Address, 8001);
        misc.setTimeout((double)this.chatTimeout.toMillis());
        this.miscLink.offer(misc);
    }

    private void acknowledgeAll(AerotechPro165 aero) {
        try {
            aero.writeAP("ACKNOWLEDGEALL");
        }
        catch (DriverException ex) {
            throw new Error(ex);
        }
    }

    private boolean checkEstop(AerotechPro165 aero) {
        for (Axis ax : this.axisMap.values()) {
            if (!ax.hasESTOP(aero)) continue;
            return true;
        }
        return false;
    }

    private static enum TaskState {
        INACTIVE,
        IDLE,
        READY,
        RUNNING,
        PAUSED,
        COMPLETE,
        ERROR;

    }

    private static interface MyConsumer<T> {
        public void accept(T var1) throws Exception;
    }
}

