/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.plc;

import java.nio.ByteBuffer;
import java.time.Duration;
import org.lsst.ccs.subsystem.shutter.plc.MsgToPLC;

public class TakeExposure
extends MsgToPLC {
    private final Duration exposureTime;

    public TakeExposure(Duration exposureTime) {
        this.exposureTime = exposureTime;
    }

    public TakeExposure(ByteBuffer data) {
        super(data);
        this.exposureTime = Duration.ofMillis(data.getInt());
    }

    @Override
    public void encode(ByteBuffer data) {
        super.encode(data);
        data.putInt((int)this.exposureTime.toMillis());
    }

    @Override
    public String toString() {
        return "TakeExposure{" + super.toString() + " exposureTime=" + this.exposureTime + "}";
    }
}

