/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.services.AgentExecutionService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.refrig.CompLimits;
import org.lsst.ccs.subsystem.refrig.CompMaq20Device;
import org.lsst.ccs.subsystem.refrig.CompPlutoDevice;
import org.lsst.ccs.subsystem.refrig.FanControl;
import org.lsst.ccs.subsystem.refrig.constants.CompAlert;
import org.lsst.ccs.subsystem.refrig.constants.CompSwConds;
import org.lsst.ccs.subsystem.refrig.constants.CompSwitches;
import org.lsst.ccs.subsystem.refrig.constants.CompressorState;
import org.lsst.ccs.subsystem.refrig.constants.ConditionState;
import org.lsst.ccs.subsystem.refrig.constants.LatchState;
import org.lsst.ccs.subsystem.refrig.constants.SwCondState;
import org.lsst.ccs.subsystem.refrig.constants.SwitchState;
import org.lsst.ccs.subsystem.refrig.data.CompState;
import org.lsst.ccs.subsystem.refrig.data.RefrigException;

public class Compressor
implements HasLifecycle {
    protected static final String COMP_LIMITS = "CompLimits";
    private static final int MIN_SW_STATE_SITS = 5;
    private static final Map<Integer, CompAlert> ccsAlertMap = new HashMap<Integer, CompAlert>();
    private static final Map<Integer, CompAlert> plcAlertMap;
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentExecutionService agentExecutionService;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    protected CompPlutoDevice plutoDevc;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    protected CompMaq20Device maq20Devc;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    protected final Map<String, Channel> channelMap = new HashMap<String, Channel>();
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private FanControl fanControl;
    protected String discPressChan;
    protected String discTempChan;
    protected String suctTempChan;
    protected String cmprPowerChan;
    private static final Logger LOG;
    protected final CompState state;
    protected final SwitchDevice[] switchDevices;
    protected final int[] switchChannels;
    protected Channel discPress;
    protected Channel discTemp;
    protected boolean gotCommand = false;
    protected boolean stateChanged = false;
    private final LatchState[] savedLatchStates = new LatchState[10];
    protected CompLimits.LimitData[] limitData;
    protected final SwCondData[] condData = new SwCondData[17];
    private final SwCondState[] savedSwStates = new SwCondState[17];
    private final Map<String, Boolean> activeAlertMap = new HashMap<String, Boolean>();
    private final AlertEnableSwitch alertEnableSwitch = new AlertEnableSwitch();
    private int activeConds = 0;
    private boolean powerEnabled = false;
    private boolean alertsEnabled = false;
    private CondState vacState = CondState.GOOD;
    private final IgnoreTimer ignoreTimer = new IgnoreTimer();
    private AgentExecutionService.Task ignoreTimerTask;

    public Compressor(CompState state) {
        this.state = state;
        this.switchDevices = new SwitchDevice[9];
        this.switchChannels = new int[9];
        for (int j = 0; j < 17; ++j) {
            this.condData[j] = new SwCondData();
        }
    }

    public void init() {
        CompAlert alert;
        this.alertService.registerAlert(CompAlert.PLC_DEAD.newAlert(this.name));
        for (int cond : plcAlertMap.keySet()) {
            alert = plcAlertMap.get(cond);
            this.alertService.registerAlert(alert.newAlert(this.name));
        }
        for (int cond : ccsAlertMap.keySet()) {
            alert = ccsAlertMap.get(cond);
            this.alertService.registerAlert(alert.newAlert(this.name));
        }
    }

    public void postInit() {
        Channel cmprPower;
        Channel suctTemp;
        if (this.plutoDevc == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"plutoDevc", (String)"not specified");
        }
        if (this.maq20Devc == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"maq20Devc", (String)"not specified");
        }
        Channel channel = this.discTemp = this.discTempChan != null ? this.channelMap.get(this.discTempChan) : null;
        if (this.discTemp == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"discTempChan", (String)"not specified or not defined");
        }
        this.condData[1].channel = this.discTemp;
        Channel channel2 = suctTemp = this.suctTempChan != null ? this.channelMap.get(this.suctTempChan) : null;
        if (suctTemp == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"suctTempChan", (String)"not specified or not defined");
        }
        this.condData[2].channel = suctTemp;
        Channel channel3 = this.discPress = this.discPressChan != null ? this.channelMap.get(this.discPressChan) : null;
        if (this.discPress == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"discPressChan", (String)"not specified or not defined");
        }
        this.condData[0].channel = this.discPress;
        Channel channel4 = cmprPower = this.cmprPowerChan != null ? this.channelMap.get(this.cmprPowerChan) : null;
        if (cmprPower == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"cmprPowerChan", (String)"not specified or not defined");
        }
        this.condData[3].channel = cmprPower;
        this.condData[5].immedCond = false;
        this.condData[10].immedCond = false;
        this.switchDevices[0] = this.plutoDevc;
        this.switchChannels[0] = 0;
        this.switchDevices[2] = this.plutoDevc;
        this.switchChannels[2] = 1;
        this.switchDevices[7] = this.alertEnableSwitch;
        this.state.setName(this.name);
        this.plutoDevc.setType(this.state.getType());
        this.maq20Devc.setType(this.state.getType());
    }

    public void postStart() {
        if (this.fanControl != null) {
            LOG.log(Level.INFO, "Starting fan speed controller for compressor {0}", this.name);
            this.fanControl.startLoop();
        }
    }

    public void setIndex(int index) {
        this.state.setIndex(index);
    }

    public int getIndex() {
        return this.state.getIndex();
    }

    @Command(type=Command.CommandType.QUERY, description="Get the valid switch names", level=0)
    public List<String> getSwitchNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (int swId : this.state.getValidSwitches()) {
            names.add(CompSwitches.ID_MAP.get(swId));
        }
        return names;
    }

    @Command(type=Command.CommandType.ACTION, description="Set a compressor's switch state")
    public synchronized void setSwitchOn(@Argument(description="Switch name") String swName, @Argument(description="Whether to turn on") boolean on) throws RefrigException {
        this.gotCommand = true;
        Integer swId = CompSwitches.NAME_MAP.get(swName);
        if (swId == null || !this.state.getValidSwitches().contains(swId)) {
            throw new RefrigException("Invalid switch name: " + swName);
        }
        if (swId != 0 || !on || this.activeConds == 0) {
            this.setSwitch(swId, on);
            if (swId == 0) {
                this.powerEnabled = on;
            }
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Reset a compressor's latches")
    public synchronized void resetLatches() {
        this.gotCommand = true;
        this.plutoDevc.resetLatches();
    }

    @Command(type=Command.CommandType.ACTION, description="Set to ignore a bad vacuum")
    public void setIgnoreVacuumBad(@Argument(description="Duration of ignore state (minutes)", defaultValue="10") double mins) {
        if (this.setVacState(CondState.BAD, CondState.BAD_IGNORE) || this.setVacState(CondState.GOOD, CondState.GOOD_IGNORE)) {
            this.ignoreTimer.setPeriod(mins);
            this.ignoreTimerTask = this.agentExecutionService.task((Runnable)this.ignoreTimer);
            this.ignoreTimerTask.start();
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Clear ignoring a bad vacuum")
    public void clearIgnoreVacuumBad() {
        if (this.setVacState(CondState.BAD_IGNORE, CondState.BAD) || this.setVacState(CondState.GOOD_IGNORE, CondState.GOOD)) {
            this.ignoreTimerTask.cancel(true);
        }
    }

    public synchronized boolean updateSystem() {
        this.checkLimits();
        return this.updateState();
    }

    public CompState getState() {
        return this.state;
    }

    public void setPlateTempLow(boolean on) {
        this.condData[5].newImmedCond = on;
    }

    public void setVacuumBad(boolean on) {
        if (on) {
            boolean x = this.setVacState(CondState.GOOD, CondState.BAD) || this.setVacState(CondState.GOOD_IGNORE, CondState.BAD_IGNORE);
        } else {
            boolean x = this.setVacState(CondState.BAD, CondState.GOOD) || this.setVacState(CondState.BAD_IGNORE, CondState.GOOD_IGNORE);
        }
    }

    private synchronized void checkLimits() {
        for (int cond : this.state.getValidSwConditions()) {
            SwCondData cd = this.condData[cond];
            if (cd.immedCond != null && cd.newImmedCond != cd.immedCond) {
                cd.immedCond = cd.newImmedCond;
                if (cd.immedCond.booleanValue()) {
                    if (cd.isWarning) {
                        cd.swState = SwCondState.WARNING;
                    } else {
                        cd.swState = SwCondState.ACTIVE;
                        this.setCondition(cond);
                    }
                } else {
                    cd.swState = SwCondState.CLEAR;
                    this.clearCondition(cond);
                }
            }
            if (cd.channel == null) continue;
            CompLimits.LimitData ld = this.limitData[cond];
            double value = cd.channel.getValue();
            if (cd.channel2 != null) {
                value = Math.abs(value - cd.channel2.getValue());
            }
            if (Double.isNaN(value)) continue;
            long endTime = cd.endTime;
            SwCondState swState = cd.swState;
            if (!ld.isLower && value > ld.immedLimit || ld.isLower && value < ld.immedLimit) {
                endTime = -1L;
                swState = SwCondState.ACTIVE;
            } else if (!ld.isLower && value > ld.delayLimit || ld.isLower && value < ld.delayLimit) {
                if (endTime == 0L) {
                    endTime = System.currentTimeMillis() + (long)ld.delayTime;
                    swState = SwCondState.DLYPEND;
                }
                if (endTime >= 0L && (ld.delayTime < 0 && this.state.getConditionState(14) == ConditionState.YES || ld.delayTime >= 0 && System.currentTimeMillis() > endTime)) {
                    endTime = -1L;
                    swState = SwCondState.DLYACTV;
                }
            } else {
                endTime = 0L;
                swState = SwCondState.CLEAR;
            }
            if (swState != cd.provSwState) {
                cd.provCount = 0;
                cd.provSwState = swState;
            }
            if (++cd.provCount < 5 || cd.provSwState == cd.swState) continue;
            cd.value = value;
            cd.swState = cd.provSwState;
            cd.endTime = endTime;
            if (endTime < 0L) {
                this.setCondition(cond);
                continue;
            }
            this.clearCondition(cond);
        }
    }

    protected synchronized boolean updateState() {
        Object latchState;
        boolean changed = this.gotCommand;
        this.gotCommand = false;
        for (int sw : this.state.getValidSwitches()) {
            Boolean on = this.switchDevices[sw].isSwitchOn(this.switchChannels[sw]);
            SwitchState swState = on == null ? SwitchState.OFFLINE : (on != false ? SwitchState.ON : SwitchState.OFF);
            SwitchState oldSwState = this.state.getSwitchState(sw);
            if (sw == 0 && oldSwState == SwitchState.OFFLINE && swState == SwitchState.ON) {
                this.powerEnabled = true;
            }
            if (swState == oldSwState) continue;
            this.state.setSwitchState(sw, swState);
            changed = true;
        }
        for (int cond : this.state.getValidConditions()) {
            ConditionState condState = this.plutoDevc.getConditionState(cond);
            if (condState == this.state.getConditionState(cond)) continue;
            this.state.setConditionState(cond, condState);
            changed = true;
        }
        boolean cmprPowered = this.state.getConditionState(3) != ConditionState.NO;
        for (int cond : this.state.getValidLatches()) {
            LatchState oldLatchState;
            latchState = this.plutoDevc.getLatchState(cond);
            if (latchState != (oldLatchState = this.state.getLatchState(cond))) {
                this.state.setLatchState(cond, (LatchState)((Object)latchState));
                changed = true;
            }
            LatchState savedLatchState = this.savedLatchStates[cond];
            if (this.alertsEnabled || this.powerEnabled) {
                if ((savedLatchState == null || latchState == savedLatchState) && (savedLatchState != null || latchState == oldLatchState)) continue;
                this.raisePlcAlert(cond, (LatchState)((Object)latchState), savedLatchState == null ? oldLatchState : savedLatchState);
                this.savedLatchStates[cond] = null;
                continue;
            }
            if (savedLatchState != null || latchState == oldLatchState) continue;
            this.savedLatchStates[cond] = oldLatchState;
        }
        boolean swDisabled = false;
        boolean swWarning = false;
        latchState = this.state.getValidSwConditions().iterator();
        while (latchState.hasNext()) {
            SwCondState swState;
            int cond = (Integer)latchState.next();
            SwCondData cd = this.condData[cond];
            SwCondState swCondState = swState = !cd.isWarning && cd.noShutoff && this.powerEnabled ? SwCondState.CLEAR : cd.swState;
            if (swState == SwCondState.ACTIVE || swState == SwCondState.DLYACTV) {
                swDisabled = true;
            } else if (swState == SwCondState.WARNING || swState == SwCondState.DLYPEND) {
                swWarning = true;
            }
            SwCondState oldSwState = this.state.getSwConditionState(cond);
            if (swState != oldSwState) {
                this.state.setSwConditionState(cond, swState);
                changed = true;
            }
            if (cd.isWarning) continue;
            SwCondState savedSwState = this.savedSwStates[cond];
            if (this.alertsEnabled || this.powerEnabled) {
                if ((savedSwState == null || swState == savedSwState) && (savedSwState != null || swState == oldSwState)) continue;
                this.raiseCcsAlert(cond, cd.value, swState);
                this.savedSwStates[cond] = null;
                continue;
            }
            if (savedSwState != null || swState == oldSwState) continue;
            this.savedSwStates[cond] = oldSwState;
        }
        Boolean active = this.plutoDevc.isPLCActive();
        CompressorState compState = active == null ? CompressorState.OFFLINE : (!active.booleanValue() ? CompressorState.PLC_DEAD : (this.state.getConditionState(11) == ConditionState.NO ? CompressorState.HW_DSAB : (swDisabled ? CompressorState.SW_DSAB : (this.state.getConditionState(2) == ConditionState.YES ? (swWarning ? CompressorState.WAIT_WRN : CompressorState.WAITING) : (this.state.getConditionState(3) == ConditionState.YES ? (swWarning ? CompressorState.RUN_WRN : CompressorState.RUNNING) : (swWarning ? CompressorState.STOP_WRN : CompressorState.STOPPED))))));
        CompressorState oldCompState = this.state.getCompressorState();
        boolean bl = this.stateChanged = compState != oldCompState;
        if (this.stateChanged) {
            if (compState == CompressorState.PLC_DEAD) {
                this.raiseAlert(CompAlert.PLC_DEAD, AlertState.ALARM, this.name + " PLC has died: error code = " + this.plutoDevc.getErrorCode());
            } else if (oldCompState == CompressorState.PLC_DEAD) {
                this.lowerAlert(CompAlert.PLC_DEAD, this.name + " PLC is alive");
            }
            this.state.setCompressorState(compState);
            changed = true;
        }
        if (this.powerEnabled && !cmprPowered) {
            this.disable();
        }
        return changed;
    }

    private void raisePlcAlert(int cond, LatchState latchState, LatchState oldLatchState) {
        CompAlert alert = plcAlertMap.get(cond);
        if (latchState == LatchState.ACTIVE) {
            this.raiseAlert(alert, AlertState.ALARM, this.name + " PLC error condition set");
        } else if (latchState == LatchState.WARNING) {
            this.raiseAlert(alert, AlertState.WARNING, this.name + " PLC warning condition set");
        } else {
            if (latchState == LatchState.LATCHED && oldLatchState == LatchState.CLEAR) {
                this.raiseAlert(alert, AlertState.ALARM, this.name + " PLC error condition set");
            }
            this.lowerAlert(alert, this.name + " PLC error condition cleared");
        }
    }

    private void raiseCcsAlert(int cond, double value, SwCondState swState) {
        CompAlert alert = ccsAlertMap.get(cond);
        boolean isImmed = this.condData[cond].immedCond != null;
        String sValue = String.format("%.1f", value);
        CompLimits.LimitData ld = this.limitData[cond];
        switch (swState) {
            case ACTIVE: {
                this.raiseAlert(alert, AlertState.ALARM, this.name + " CCS immediate error condition set" + (String)(isImmed ? "" : ": value (" + sValue + (ld.isLower ? ") < " : ") > ") + ld.immedLimit));
                break;
            }
            case DLYACTV: {
                String timeText = ld.delayTime >= 0 ? " for " + ld.delayTime / 1000 + " sec" : " and compressor on for 8 hours";
                this.raiseAlert(alert, AlertState.ALARM, this.name + " CCS delayed error condition set: value (" + sValue + (ld.isLower ? ") < " : ") > ") + ld.delayLimit + timeText);
                break;
            }
            case DLYPEND: {
                this.raiseAlert(alert, AlertState.WARNING, this.name + " CCS delayed error condition pending: value (" + sValue + (ld.isLower ? ") < " : ") > ") + ld.delayLimit);
                break;
            }
            default: {
                this.lowerAlert(alert, this.name + " CCS error condition cleared" + (String)(isImmed ? "" : ": value = " + sValue));
            }
        }
    }

    protected void setSwitch(int sw, boolean on) throws RefrigException {
        this.switchDevices[sw].setSwitchOn(this.switchChannels[sw], on);
    }

    private void setCondition(int cond) {
        LOG.log(Level.FINE, "{0} compressor encountered \"{1}\" condition", new Object[]{this.name, CompSwConds.DESCS[cond]});
        if (!this.condData[cond].noShutoff) {
            this.disable();
        }
        this.activeConds |= 1 << cond;
    }

    private void clearCondition(int cond) {
        this.activeConds &= ~(1 << cond);
    }

    private void disable() {
        try {
            this.setSwitch(0, false);
            this.powerEnabled = false;
        }
        catch (RefrigException e) {
            LOG.log(Level.SEVERE, "Error shutting off {0} compressor: {1}", new Object[]{this.name, e});
        }
    }

    protected void raiseAlert(CompAlert alert, AlertState state, String cond) {
        this.activeAlertMap.put(alert.getId(this.name), true);
        this.alertService.raiseAlert(alert.newAlert(this.name), state, cond);
    }

    protected void lowerAlert(CompAlert alert, String cond) {
        if (this.activeAlertMap.put(alert.getId(this.name), false) == Boolean.TRUE) {
            this.alertService.raiseAlert(alert.newAlert(this.name), AlertState.NOMINAL, cond);
        }
    }

    protected boolean areEqual(double value1, double value2) {
        return value1 == value2 || Double.isNaN(value1) && Double.isNaN(value2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setVacState(CondState oldState, CondState newState) {
        CondState condState = this.vacState;
        synchronized (condState) {
            if (this.vacState != oldState) {
                return false;
            }
            this.vacState = newState;
            if (oldState == CondState.BAD) {
                this.condData[10].newImmedCond = false;
            }
            if (newState == CondState.BAD) {
                this.condData[10].newImmedCond = true;
            }
            return true;
        }
    }

    static {
        ccsAlertMap.put(0, CompAlert.DISC_PRESS_HIGH);
        ccsAlertMap.put(1, CompAlert.DISC_TEMP_HIGH);
        ccsAlertMap.put(3, CompAlert.COMP_POWER_HIGH);
        ccsAlertMap.put(7, CompAlert.LIQD_TEMP_HIGH);
        ccsAlertMap.put(6, CompAlert.OIL_LEVEL_LOW);
        ccsAlertMap.put(2, CompAlert.SUCT_TEMP_LOW);
        ccsAlertMap.put(4, CompAlert.PHASE_TEMP_HIGH);
        ccsAlertMap.put(5, CompAlert.CRYO_TEMP_LOW);
        ccsAlertMap.put(8, CompAlert.PRESS_DIFF_HIGH);
        ccsAlertMap.put(9, CompAlert.DISC_TEMP_LOW);
        ccsAlertMap.put(10, CompAlert.VACUUM_BAD);
        plcAlertMap = new HashMap<Integer, CompAlert>();
        plcAlertMap.put(3, CompAlert.DISC_PRESS_HIGH_PLC);
        plcAlertMap.put(0, CompAlert.DISC_TEMP_HIGH_PLC);
        plcAlertMap.put(4, CompAlert.COMP_POWER_HIGH_PLC);
        plcAlertMap.put(2, CompAlert.LIQD_TEMP_HIGH_PLC);
        plcAlertMap.put(9, CompAlert.OIL_LEVEL_LOW_PLC);
        plcAlertMap.put(1, CompAlert.SUCT_TEMP_LOW_PLC);
        plcAlertMap.put(8, CompAlert.AFTER_TEMP_HIGH_PLC);
        plcAlertMap.put(7, CompAlert.SENS_READ_BAD_PLC);
        plcAlertMap.put(6, CompAlert.SMOKE_DETC_PLC);
        plcAlertMap.put(5, CompAlert.EXT_PERMIT_PLC);
        LOG = Logger.getLogger(Compressor.class.getName());
    }

    public static class SwCondData {
        protected Channel channel = null;
        protected Channel channel2 = null;
        protected boolean isWarning = false;
        protected boolean noShutoff = false;
        protected Boolean immedCond = null;
        protected boolean newImmedCond = false;
        private double value = 0.0;
        private long endTime = 0L;
        private SwCondState swState = SwCondState.CLEAR;
        private SwCondState provSwState = SwCondState.CLEAR;
        private int provCount = 0;
    }

    class AlertEnableSwitch
    implements SwitchDevice {
        AlertEnableSwitch() {
        }

        @Override
        public void setSwitchOn(int chan, boolean on) {
            Compressor.this.alertsEnabled = on;
        }

        @Override
        public Boolean isSwitchOn(int chan) {
            return Compressor.this.alertsEnabled || Compressor.this.powerEnabled;
        }
    }

    private static enum CondState {
        GOOD,
        BAD,
        GOOD_IGNORE,
        BAD_IGNORE;

    }

    private class IgnoreTimer
    extends Thread {
        long period = 600000L;

        private IgnoreTimer() {
        }

        @Override
        public void run() {
            try {
                Thread.sleep(this.period);
                Compressor.this.clearIgnoreVacuumBad();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void setPeriod(double mins) {
            this.period = (long)(60000.0 * mins);
        }
    }

    public static interface SwitchDevice {
        public void setSwitchOn(int var1, boolean var2) throws RefrigException;

        public Boolean isSwitchOn(int var1);
    }
}

