/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.camera.kafka.avro;

import java.io.File;
import java.io.PrintWriter;
import java.util.Map;
import java.util.TreeSet;
import org.apache.avro.Schema;
import org.lsst.ccs.camera.Camera;
import org.lsst.ccs.camera.kafka.avro.AvroSchemaMapper;
import org.lsst.ccs.camera.kafka.avro.Topic;

public class AvroSchemaGenerator {
    public static void main(String[] args) throws Exception {
        String defaultOutput = "/tmp";
        if (args.length > 0) {
            defaultOutput = args[0];
        }
        File outputLocation = new File(defaultOutput);
        for (Camera c : Camera.values()) {
            AvroSchemaMapper mapper = new AvroSchemaMapper(c);
            mapper.buildSchemasForLocalDictionaries();
            File outputDir = new File(outputLocation, c.getCscName());
            outputDir.mkdirs();
            TreeSet<String> allTags = new TreeSet<String>();
            for (Map.Entry<String, Topic> e : mapper.getAllTopicsMap().entrySet()) {
                File avroSchemaFile = new File(outputDir, e.getKey() + ".avsc");
                Topic t = e.getValue();
                allTags.addAll(t.getTags());
                Schema schemaToWrite = mapper.getSchemaForTopic(t);
                avroSchemaFile.createNewFile();
                try (PrintWriter pw = new PrintWriter(avroSchemaFile);){
                    pw.print(schemaToWrite.toString(true));
                }
            }
            File allTagsFile = new File(outputLocation, c.getCscName() + "_allTags.txt");
            allTagsFile.createNewFile();
            try (PrintWriter pw = new PrintWriter(allTagsFile);){
                for (String tag : allTags) {
                    pw.println(tag);
                }
            }
            File trendingMapFile = new File(outputLocation, c.getCscName() + "_trending.map");
            trendingMapFile.createNewFile();
            try (PrintWriter pw = new PrintWriter(trendingMapFile);){
                pw.println("# Conversion map from CCS path to InfluxDb data location and corresponding tags.");
                pw.println("# Each line contains the following information:");
                pw.println("# CCS_path  Topic_full_name Field_name Map_of_tags");
                for (String path : mapper.getAvailablePaths()) {
                    Topic.TopicField topicField = mapper.getTopicFieldForPath(path);
                    Topic topic = topicField.getTopic();
                    pw.println(path + " " + topic.getFullName() + " " + topicField.getName() + " " + mapper.getTagValuesForPath(path));
                }
            }
        }
    }
}

