/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.io.Serializable;
import java.time.Duration;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Agent;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.DataProviderDictionary;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentLockService;
import org.lsst.ccs.services.AgentLoginService;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommandExecutor;
import org.lsst.ccs.subsystem.ocsbridge.HeaderServiceEventHandler;
import org.lsst.ccs.subsystem.ocsbridge.MCMCCSLayer;
import org.lsst.ccs.subsystem.ocsbridge.MCMLayer;
import org.lsst.ccs.subsystem.ocsbridge.MotionLockUnlockEventHandler;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridge;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridgeConfig;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridgeSALLayer;
import org.lsst.ccs.subsystem.ocsbridge.SoftwareVersionsGenerator;
import org.lsst.ccs.subsystem.ocsbridge.states.CameraMotionState;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.sal.SAL;
import org.lsst.sal.SALCommand;
import org.lsst.sal.SALEvent;
import org.lsst.sal.SALTelemetry;
import org.lsst.sal.camera.states.CCSCommandStateEvent;
import org.lsst.sal.camera.states.OfflineDetailedStateEvent;
import org.lsst.sal.camera.states.SummaryStateEvent;

public class OCSSubsystem
extends Subsystem
implements HasLifecycle {
    private static final Logger LOG = Logger.getLogger(OCSSubsystem.class.getName());
    private OCSBridge ocsBridge;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private OCSBridgeConfig config;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStateService agentStateService;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private HeaderServiceEventHandler headerServiceEventHandler;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private MotionLockUnlockEventHandler motionLockUnlockEventHandler;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentLockService agentLockService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentLoginService loginService;
    private MCMLayer mcmLayer;

    OCSSubsystem() {
        super("ocs-bridge", AgentInfo.AgentType.OCS_BRIDGE);
    }

    public void init() {
        this.agentStateService.registerState(SummaryStateEvent.SummaryState.class, "SAL Summary State", (Object)this);
        this.agentStateService.registerState(OfflineDetailedStateEvent.OfflineState.class, "SAL Offline State", (Object)this);
        this.agentStateService.registerState(CCSCommandStateEvent.CCSCommandState.class, "SAL Command State", (Object)this);
        this.agentStateService.registerState(CameraMotionState.class, "Camera Motion Locked State", (Object)this);
    }

    public void postInit() {
        this.loginService.login(this.config.getUserID(), "noCredentialsNeeded");
        CCS ccs = new CCS();
        this.mcmLayer = new MCMCCSLayer(this, ccs, this.config, this.loginService, this.agentLockService);
        this.ocsBridge = new OCSBridge(this.config, ccs, this.mcmLayer);
    }

    public void shutdown() {
        this.mcmLayer.shutdown();
    }

    public void postStart() {
        State lse209State = this.ocsBridge.getLse209State();
        State offlineState = this.ocsBridge.getOfflineState();
        State<CCSCommandStateEvent.CCSCommandState> commandState = this.ocsBridge.getCommandState();
        SoftwareVersionsGenerator softwareVersionsGenerator = new SoftwareVersionsGenerator(this.ocsBridge, (Agent)this);
        this.agentStateService.updateAgentState(new Enum[]{lse209State.getState(), offlineState.getState(), commandState.getState(), CameraMotionState.UNLOCKED});
        State.StateChangeListener<Enum> l = (when, state, oldState, cause) -> {
            this.agentStateService.updateAgentState(when, new Enum[]{state});
            if (state == SummaryStateEvent.SummaryState.STANDBY) {
                softwareVersionsGenerator.run(true);
            }
        };
        lse209State.addStateChangeListener(l);
        offlineState.addStateChangeListener(l);
        commandState.addStateChangeListener(l);
        this.ocsBridge.setCCSCommandExecutor(new CCSCommandExecutor(){

            @Override
            void sendAck(CCSCommand.CCSAckOrNack can) {
                OCSSubsystem.this.sendAck(can.getDuration().plus(Duration.ofMillis(100L)));
            }

            @Override
            void sendNack(CCSCommand.CCSAckOrNack can) {
                OCSSubsystem.this.sendNack((Serializable)((Object)can.getReason()));
            }
        });
        OCSBridgeSALLayer ocsInterface = new OCSBridgeSALLayer(this.ocsBridge);
        if (this.headerServiceEventHandler != null) {
            ocsInterface.addSALEventListener(this.headerServiceEventHandler);
        }
        if (this.motionLockUnlockEventHandler != null) {
            SAL<SALCommand, SALEvent, SALTelemetry> mtRotatorManager = this.config.getMTRotatorManager();
            LOG.log(Level.INFO, "Got mtRotatorManager {0}", mtRotatorManager);
            SAL<SALCommand, SALEvent, SALTelemetry> mtMountManager = this.config.getMTMountManager();
            LOG.log(Level.INFO, "Got mtMountManager {0}", mtMountManager);
            this.motionLockUnlockEventHandler.setManagers(mtRotatorManager, mtMountManager);
            ocsInterface.addSALEventListener(this.motionLockUnlockEventHandler);
            this.ocsBridge.setMotionLockUnlockEventHandler(this.motionLockUnlockEventHandler);
        }
        this.ocsBridge.setOCSCommandExecutor(ocsInterface);
        ocsInterface.start();
        softwareVersionsGenerator.run(false);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void setAvailable() throws Exception {
        CCSCommand.CCSSetAvailableCommand setAvailable = new CCSCommand.CCSSetAvailableCommand();
        this.ocsBridge.execute(setAvailable);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void revokeAvailable() throws Exception {
        CCSCommand.CCSRevokeAvailableCommand revokeAvailable = new CCSCommand.CCSRevokeAvailableCommand();
        this.ocsBridge.execute(revokeAvailable);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void simulateFault() throws Exception {
        CCSCommand.CCSSimulateFaultCommand simulateFault = new CCSCommand.CCSSimulateFaultCommand();
        this.ocsBridge.execute(simulateFault);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void clearFault() throws Exception {
        CCSCommand.CCSClearFaultCommand clearFault = new CCSCommand.CCSClearFaultCommand();
        this.ocsBridge.execute(clearFault);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void lockMotion() throws Exception {
        CCSCommand.CCSLockMotionCommand lockMotion = new CCSCommand.CCSLockMotionCommand();
        this.ocsBridge.execute(lockMotion);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void unlockMotion() throws Exception {
        CCSCommand.CCSUnlockMotionCommand unlockMotion = new CCSCommand.CCSUnlockMotionCommand();
        this.ocsBridge.execute(unlockMotion);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void createTestAlert(String message, String level, boolean cleared) throws Exception {
        CCSCommand.CCSCreateTestAlertCommand createTestAlert = new CCSCommand.CCSCreateTestAlertCommand(message, level, cleared);
        this.ocsBridge.execute(createTestAlert);
    }

    void addSubsystem(AgentInfo ai, DataProviderDictionary dict) {
        this.ocsBridge.addSubsystem(ai, dict);
    }

    void removeSubsystem(String subsystemName) {
        this.ocsBridge.removeSubsystem(subsystemName);
    }
}

