/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.xmlrpc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.astrogrid.samp.Message;
import org.astrogrid.samp.Response;
import org.astrogrid.samp.ShutdownManager;
import org.astrogrid.samp.client.CallableClient;
import org.astrogrid.samp.client.SampException;
import org.astrogrid.samp.xmlrpc.SampXmlRpcClient;

class XmlRpcCallableClient
implements CallableClient {
    private final SampXmlRpcClient xClient_;
    private final String privateKey_;
    private static volatile boolean isShutdown_;

    public XmlRpcCallableClient(SampXmlRpcClient xClient, String privateKey) {
        this.xClient_ = xClient;
        this.privateKey_ = privateKey;
    }

    public void receiveCall(String senderId, String msgId, Message msg) throws SampException {
        this.exec("receiveCall", new Object[]{senderId, msgId, msg});
    }

    public void receiveNotification(String senderId, Message msg) throws SampException {
        this.exec("receiveNotification", new Object[]{senderId, msg});
    }

    public void receiveResponse(String responderId, String msgTag, Response response) throws SampException {
        this.exec("receiveResponse", new Object[]{responderId, msgTag, response});
    }

    private void exec(String methodName, Object[] params) throws SampException {
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add(this.privateKey_);
        for (int ip = 0; ip < params.length; ++ip) {
            paramList.add(params[ip]);
        }
        try {
            this.rawExec("samp.client." + methodName, paramList);
        }
        catch (IOException e) {
            throw new SampException(e.getMessage(), e);
        }
    }

    private void rawExec(String fqName, List paramList) throws IOException {
        if (isShutdown_) {
            this.xClient_.callAndWait(fqName, paramList);
        } else {
            this.xClient_.callAndForget(fqName, paramList);
        }
    }

    static {
        ShutdownManager.getInstance().registerHook(XmlRpcCallableClient.class, 0, new Runnable(){

            public void run() {
                isShutdown_ = true;
            }
        });
    }
}

